/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SignerLocation;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampInclude;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SignatureBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.signature.DSSSignatureUtils;
import eu.europa.esig.dss.xades.signature.DetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.EnvelopingSignatureBuilder;
import eu.europa.esig.dss.xades.signature.InternallyDetachedSignatureBuilder;
import eu.europa.esig.dss.xades.signature.XAdESBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XAdESSignatureBuilder
extends XAdESBuilder
implements SignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureBuilder.class);
    protected boolean built = false;
    protected DSSDocument detachedDocument;
    protected static final String DEFAULT_CANONICALIZATION_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    protected String keyInfoCanonicalizationMethod;
    protected String signedInfoCanonicalizationMethod;
    protected String signedPropertiesCanonicalizationMethod;
    protected final String deterministicId;
    protected Element signatureDom;
    protected Element keyInfoDom;
    protected Element signedInfoDom;
    protected Element signatureValueDom;
    protected Element qualifyingPropertiesDom;
    protected Element signedPropertiesDom;
    protected Element signedSignaturePropertiesDom;
    protected Element signedDataObjectPropertiesDom;
    protected Element unsignedSignaturePropertiesDom;
    protected static final String KEYINFO_SUFFIX = "keyInfo-";
    protected static final String TIMESTAMP_SUFFIX = "TS-";
    protected static final String VALUE_SUFFIX = "value-";
    protected static final String XADES_SUFFIX = "xades-";
    protected static final String OBJECT_ID_SUFFIX = "o-";
    protected static final String REFERENCE_ID_SUFFIX = "r-";

    public static XAdESSignatureBuilder getSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        switch (params.getSignaturePackaging()) {
            case ENVELOPED: {
                return new EnvelopedSignatureBuilder(params, document, certificateVerifier);
            }
            case ENVELOPING: {
                return new EnvelopingSignatureBuilder(params, document, certificateVerifier);
            }
            case DETACHED: {
                return new DetachedSignatureBuilder(params, document, certificateVerifier);
            }
            case INTERNALLY_DETACHED: {
                return new InternallyDetachedSignatureBuilder(params, document, certificateVerifier);
            }
        }
        throw new DSSException("Unsupported packaging " + (Object)((Object)params.getSignaturePackaging()));
    }

    public XAdESSignatureBuilder(XAdESSignatureParameters params, DSSDocument detachedDocument, CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        this.params = params;
        this.detachedDocument = detachedDocument;
        this.deterministicId = params.getDeterministicId();
    }

    protected void setCanonicalizationMethods(XAdESSignatureParameters params, String canonicalizationMethod) {
        this.keyInfoCanonicalizationMethod = this.getCanonicalizationMethod(params.getKeyInfoCanonicalizationMethod(), canonicalizationMethod);
        this.signedInfoCanonicalizationMethod = this.getCanonicalizationMethod(params.getSignedInfoCanonicalizationMethod(), canonicalizationMethod);
        this.signedPropertiesCanonicalizationMethod = this.getCanonicalizationMethod(params.getSignedPropertiesCanonicalizationMethod(), canonicalizationMethod);
    }

    private String getCanonicalizationMethod(String signatureParameterCanonicalizationMethod, String defaultCanonicalizationMethod) {
        if (Utils.isStringNotBlank(signatureParameterCanonicalizationMethod)) {
            return signatureParameterCanonicalizationMethod;
        }
        return defaultCanonicalizationMethod;
    }

    public byte[] build() throws DSSException {
        this.documentDom = this.buildRootDocumentDom();
        List<DSSReference> references = this.params.getReferences();
        if (Utils.isCollectionEmpty(references)) {
            List<DSSReference> defaultReferences = this.createDefaultReferences();
            this.params.setReferences(defaultReferences);
        } else {
            this.checkReferencesValidity();
        }
        this.incorporateFiles();
        this.incorporateSignatureDom();
        this.incorporateSignedInfo();
        this.incorporateSignatureValue();
        this.incorporateKeyInfo();
        this.incorporateObject();
        if (this.params.getSignedData() == null) {
            this.incorporateReferences();
            this.incorporateReferenceSignedProperties();
            this.incorporateReferenceKeyInfo();
        }
        byte[] canonicalizedSignedInfo = DSSXMLUtils.canonicalizeSubtree(this.signedInfoCanonicalizationMethod, this.getNodeToCanonicalize(this.signedInfoDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalized SignedInfo         --> {}", (Object)new String(canonicalizedSignedInfo));
            byte[] digest = DSSUtils.digest(DigestAlgorithm.SHA256, canonicalizedSignedInfo);
            LOG.trace("Canonicalized SignedInfo SHA256  --> {}", (Object)Utils.toBase64(digest));
        }
        this.built = true;
        return canonicalizedSignedInfo;
    }

    private void checkReferencesValidity() {
        for (DSSReference reference : this.params.getReferences()) {
            List<DSSTransform> transforms = reference.getTransforms();
            if (!Utils.isCollectionNotEmpty(transforms)) continue;
            boolean incorrectUsageOfEnvelopedSignature = false;
            String referenceWrongMessage = "Reference setting is not correct! ";
            for (DSSTransform transform : transforms) {
                switch (transform.getAlgorithm()) {
                    case "http://www.w3.org/2000/09/xmldsig#base64": {
                        if (this.params.isEmbedXML()) {
                            throw new DSSException(referenceWrongMessage + "The embedXML(true) parameter is not compatible with base64 transform.");
                        }
                        if (this.params.isManifestSignature()) {
                            throw new DSSException(referenceWrongMessage + "Manifest signature is not compatible with base64 transform.");
                        }
                        if (SignaturePackaging.ENVELOPED.equals((Object)this.params.getSignaturePackaging())) {
                            throw new DSSException(referenceWrongMessage + "Base64 transform is not compatible with Enveloped signature format.");
                        }
                        if (transforms.size() <= 1) break;
                        throw new DSSException(referenceWrongMessage + "Base64 transform cannot be used with other transformations.");
                    }
                    case "http://www.w3.org/2000/09/xmldsig#enveloped-signature": {
                        incorrectUsageOfEnvelopedSignature = true;
                        break;
                    }
                    case "http://www.w3.org/2006/12/xml-c14n11": 
                    case "http://www.w3.org/2006/12/xml-c14n11#WithComments": 
                    case "http://www.w3.org/2001/10/xml-exc-c14n#": 
                    case "http://www.w3.org/2001/10/xml-exc-c14n#WithComments": 
                    case "http://www.w3.org/TR/2001/REC-xml-c14n-20010315": 
                    case "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments": {
                        if (!incorrectUsageOfEnvelopedSignature) break;
                        incorrectUsageOfEnvelopedSignature = false;
                        break;
                    }
                }
            }
            if (!incorrectUsageOfEnvelopedSignature) continue;
            throw new DSSException(referenceWrongMessage + "Enveloped Signature Transform must be followed up by a Canonicalization Transform.");
        }
    }

    protected void incorporateFiles() {
    }

    protected Document buildRootDocumentDom() {
        return DomUtils.buildDOM();
    }

    public void incorporateSignatureDom() {
        this.signatureDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:Signature");
        this.signatureDom.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        this.signatureDom.setAttribute("Id", this.deterministicId);
        Node parentNodeOfSignature = this.getParentNodeOfSignature();
        parentNodeOfSignature.appendChild(this.signatureDom);
    }

    protected Node getParentNodeOfSignature() {
        return this.documentDom;
    }

    public void incorporateSignedInfo() {
        if (this.params.getSignedData() != null) {
            LOG.debug("Using explict SignedInfo from parameter");
            this.signedInfoDom = DomUtils.buildDOM(this.params.getSignedData()).getDocumentElement();
            this.signedInfoDom = (Element)this.documentDom.importNode(this.signedInfoDom, true);
            this.signatureDom.appendChild(this.signedInfoDom);
            return;
        }
        this.signedInfoDom = DomUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo");
        this.incorporateCanonicalizationMethod(this.signedInfoDom, this.signedInfoCanonicalizationMethod);
        Element signatureMethod = DomUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod");
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        DigestAlgorithm digestAlgorithm = this.params.getDigestAlgorithm();
        MaskGenerationFunction mgf = this.params.getMaskGenerationFunction();
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm, mgf);
        String signatureAlgorithmXMLId = signatureAlgorithm.getUri();
        if (Utils.isStringBlank(signatureAlgorithmXMLId)) {
            throw new DSSException("Unsupported signature algorithm " + signatureAlgorithm);
        }
        signatureMethod.setAttribute("Algorithm", signatureAlgorithmXMLId);
    }

    private void incorporateCanonicalizationMethod(Element parentDom, String signedInfoCanonicalizationMethod) {
        Element canonicalizationMethodDom = DomUtils.addElement(this.documentDom, parentDom, "http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonicalizationMethodDom.setAttribute("Algorithm", signedInfoCanonicalizationMethod);
    }

    private void incorporateReferences() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            this.incorporateReference(reference);
        }
    }

    protected void incorporateKeyInfo() throws DSSException {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signature DOM later");
            return;
        }
        Element keyInfoDom = DomUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        if (this.params.isSignKeyInfo()) {
            keyInfoDom.setAttribute("Id", KEYINFO_SUFFIX + this.deterministicId);
        }
        BaselineBCertificateSelector certSelector = new BaselineBCertificateSelector(this.certificateVerifier, this.params);
        List<CertificateToken> certificates = certSelector.getCertificates();
        if (this.params.isAddX509SubjectName()) {
            for (CertificateToken token : certificates) {
                Element x509DataDom = DomUtils.addElement(this.documentDom, keyInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
                this.addSubjectAndCertificate(x509DataDom, token);
            }
        } else {
            Element x509DataDom = DomUtils.addElement(this.documentDom, keyInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509Data");
            for (CertificateToken token : certificates) {
                this.addCertificate(x509DataDom, token);
            }
        }
        this.keyInfoDom = keyInfoDom;
    }

    private void addSubjectAndCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement(this.documentDom, x509DataDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509SubjectName", token.getSubjectX500Principal().getName("RFC2253"));
        this.addCertificate(x509DataDom, token);
    }

    private void addCertificate(Element x509DataDom, CertificateToken token) {
        DomUtils.addTextElement(this.documentDom, x509DataDom, "http://www.w3.org/2000/09/xmldsig#", "ds:X509Certificate", Utils.toBase64(token.getEncoded()));
    }

    protected void incorporateObject() {
        if (this.params.getSignedAdESObject() != null) {
            LOG.debug("Incorporating signed XAdES Object from parameter");
            Node signedObjectDom = DomUtils.buildDOM(this.params.getSignedAdESObject()).getDocumentElement();
            signedObjectDom = this.documentDom.importNode(signedObjectDom, true);
            this.signatureDom.appendChild(signedObjectDom);
            return;
        }
        Element objectDom = DomUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Object");
        this.qualifyingPropertiesDom = DomUtils.addElement(this.documentDom, objectDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:QualifyingProperties");
        this.qualifyingPropertiesDom.setAttribute("xmlns:xades", XAdESNamespaces.getXAdESDefaultNamespace());
        this.qualifyingPropertiesDom.setAttribute("Target", "#" + this.deterministicId);
        this.incorporateSignedProperties();
    }

    protected void incorporateReferenceSignedProperties() {
        Element reference = DomUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        reference.setAttribute("Type", this.xPathQueryHolder.XADES_SIGNED_PROPERTIES);
        reference.setAttribute("URI", "#xades-" + this.deterministicId);
        Element transforms = DomUtils.addElement(this.documentDom, reference, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        Element transform = DomUtils.addElement(this.documentDom, transforms, "http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        transform.setAttribute("Algorithm", this.signedPropertiesCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        this.incorporateDigestMethod(reference, digestAlgorithm);
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.signedPropertiesCanonicalizationMethod, this.getNodeToCanonicalize(this.signedPropertiesDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method  --> {}", (Object)this.signedPropertiesCanonicalizationMethod);
            LOG.trace("Canonicalised REF_2      --> {}", (Object)new String(canonicalizedBytes));
        }
        this.incorporateDigestValueOfReference(reference, digestAlgorithm, canonicalizedBytes);
    }

    protected void incorporateReferenceKeyInfo() {
        if (!this.params.isSignKeyInfo()) {
            return;
        }
        Element reference = DomUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        reference.setAttribute("URI", "#keyInfo-" + this.deterministicId);
        Element transforms = DomUtils.addElement(this.documentDom, reference, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        Element transform = DomUtils.addElement(this.documentDom, transforms, "http://www.w3.org/2000/09/xmldsig#", "ds:Transform");
        transform.setAttribute("Algorithm", this.keyInfoCanonicalizationMethod);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        this.incorporateDigestMethod(reference, digestAlgorithm);
        byte[] canonicalizedBytes = DSSXMLUtils.canonicalizeSubtree(this.keyInfoCanonicalizationMethod, this.getNodeToCanonicalize(this.keyInfoDom));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalization method   --> {}", (Object)this.keyInfoCanonicalizationMethod);
            LOG.trace("Canonicalised REF_KeyInfo --> {}", (Object)new String(canonicalizedBytes));
        }
        this.incorporateDigestValueOfReference(reference, digestAlgorithm, canonicalizedBytes);
    }

    protected DigestAlgorithm getReferenceDigestAlgorithmOrDefault(XAdESSignatureParameters params) {
        return params.getReferenceDigestAlgorithm() != null ? params.getReferenceDigestAlgorithm() : params.getDigestAlgorithm();
    }

    private void incorporateReference(DSSReference dssReference) {
        List<DSSTransform> dssTransforms;
        String referenceType;
        String uri;
        Element referenceDom = DomUtils.addElement(this.documentDom, this.signedInfoDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
        if (dssReference.getId() != null) {
            referenceDom.setAttribute("Id", dssReference.getId());
        }
        if ((uri = dssReference.getUri()) != null) {
            referenceDom.setAttribute("URI", uri);
        }
        if ((referenceType = dssReference.getType()) != null) {
            referenceDom.setAttribute("Type", referenceType);
        }
        if ((dssTransforms = dssReference.getTransforms()) != null) {
            Element transformsDom = DomUtils.addElement(this.documentDom, referenceDom, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
            for (DSSTransform dssTransform : dssTransforms) {
                dssTransform.createTransform(this.documentDom, transformsDom);
            }
        }
        DigestAlgorithm digestAlgorithm = dssReference.getDigestMethodAlgorithm();
        this.incorporateDigestMethod(referenceDom, digestAlgorithm);
        DSSDocument canonicalizedDocument = this.transformReference(dssReference);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reference canonicalization method  --> {}", (Object)this.signedInfoCanonicalizationMethod);
        }
        this.incorporateDigestValue(referenceDom, dssReference, digestAlgorithm, canonicalizedDocument);
    }

    private void incorporateDigestValueOfReference(Element referenceDom, DigestAlgorithm digestAlgorithm, byte[] canonicalizedBytes) {
        Element digestValueDom = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        String base64EncodedDigestBytes = Utils.toBase64(DSSUtils.digest(digestAlgorithm, canonicalizedBytes));
        Text textNode = this.documentDom.createTextNode(base64EncodedDigestBytes);
        digestValueDom.appendChild(textNode);
        referenceDom.appendChild(digestValueDom);
    }

    private List<DSSReference> createDefaultReferences() {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        references.add(this.createReference(this.detachedDocument, 1));
        return references;
    }

    List<DSSReference> createReferencesForDocuments(List<DSSDocument> documents) {
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        int referenceIndex = 1;
        for (DSSDocument dssDocument : documents) {
            references.add(this.createReference(dssDocument, referenceIndex));
            ++referenceIndex;
        }
        return references;
    }

    protected abstract DSSReference createReference(DSSDocument var1, int var2);

    protected abstract DSSDocument transformReference(DSSReference var1);

    protected void incorporateSignatureValue() {
        this.signatureValueDom = DomUtils.addElement(this.documentDom, this.signatureDom, "http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue");
        this.signatureValueDom.setAttribute("Id", VALUE_SUFFIX + this.deterministicId);
    }

    protected void incorporateSignedProperties() {
        this.signedPropertiesDom = DomUtils.addElement(this.documentDom, this.qualifyingPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignedProperties");
        this.signedPropertiesDom.setAttribute("Id", XADES_SUFFIX + this.deterministicId);
        this.incorporateSignedSignatureProperties();
        this.incorporateSignedDataObjectProperties();
    }

    protected void incorporateSignedSignatureProperties() {
        this.signedSignaturePropertiesDom = DomUtils.addElement(this.documentDom, this.signedPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignedSignatureProperties");
        this.incorporateSigningTime();
        this.incorporateSigningCertificate();
        this.incorporatePolicy();
        this.incorporateSignatureProductionPlace();
        this.incorporateSignerRole();
    }

    private void incorporatePolicy() {
        Policy signaturePolicy = this.params.bLevel().getSignaturePolicy();
        if (signaturePolicy != null) {
            Element signaturePolicyIdentifierDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignaturePolicyIdentifier");
            String signaturePolicyId = signaturePolicy.getId();
            if (Utils.isStringEmpty(signaturePolicyId)) {
                DomUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignaturePolicyImplied");
            } else {
                String spuri;
                String description;
                Element signaturePolicyIdDom = DomUtils.addElement(this.documentDom, signaturePolicyIdentifierDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignaturePolicyId");
                Element sigPolicyIdDom = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SigPolicyId");
                Element identifierDom = DomUtils.addTextElement(this.documentDom, sigPolicyIdDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:Identifier", signaturePolicyId);
                String qualifier = signaturePolicy.getQualifier();
                if (Utils.isStringNotBlank(qualifier)) {
                    identifierDom.setAttribute("Qualifier", qualifier);
                }
                if (Utils.isStringNotEmpty(description = signaturePolicy.getDescription())) {
                    DomUtils.addTextElement(this.documentDom, sigPolicyIdDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:Description", description);
                }
                if (signaturePolicy.getDigestAlgorithm() != null && signaturePolicy.getDigestValue() != null) {
                    Element sigPolicyHashDom = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SigPolicyHash");
                    DigestAlgorithm digestAlgorithm = signaturePolicy.getDigestAlgorithm();
                    this.incorporateDigestMethod(sigPolicyHashDom, digestAlgorithm);
                    byte[] hashValue = signaturePolicy.getDigestValue();
                    String bas64EncodedHashValue = Utils.toBase64(hashValue);
                    DomUtils.addTextElement(this.documentDom, sigPolicyHashDom, "http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue", bas64EncodedHashValue);
                }
                if (Utils.isStringNotEmpty(spuri = signaturePolicy.getSpuri())) {
                    Element sigPolicyQualifiers = DomUtils.addElement(this.documentDom, signaturePolicyIdDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SigPolicyQualifiers");
                    Element sigPolicyQualifier = DomUtils.addElement(this.documentDom, sigPolicyQualifiers, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SigPolicyQualifier");
                    DomUtils.addTextElement(this.documentDom, sigPolicyQualifier, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SPURI", spuri);
                }
            }
        }
    }

    private void incorporateSigningTime() {
        Date signingDate = this.params.bLevel().getSigningDate();
        XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar(signingDate);
        String xmlSigningTime = xmlGregorianCalendar.toXMLFormat();
        Element signingTimeDom = this.documentDom.createElementNS(XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SigningTime");
        this.signedSignaturePropertiesDom.appendChild(signingTimeDom);
        Text textNode = this.documentDom.createTextNode(xmlSigningTime);
        signingTimeDom.appendChild(textNode);
    }

    private void incorporateSigningCertificate() {
        if (this.params.getSigningCertificate() == null && this.params.isGenerateTBSWithoutCertificate()) {
            return;
        }
        HashSet<CertificateToken> certificates = new HashSet<CertificateToken>();
        certificates.add(this.params.getSigningCertificate());
        if (this.params.isEn319132()) {
            this.incorporateSigningCertificateV2(certificates);
        } else {
            this.incorporateSigningCertificateV1(certificates);
        }
    }

    private void incorporateSigningCertificateV1(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), XAdESNamespaces.getXADES_SIGNING_CERTIFICATE());
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV1(certDom, certificate);
        }
    }

    private void incorporateSigningCertificateV2(Set<CertificateToken> certificates) {
        Element signingCertificateDom = DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), XAdESNamespaces.getXADES_SIGNING_CERTIFICATE_V2());
        for (CertificateToken certificate : certificates) {
            Element certDom = this.incorporateCert(signingCertificateDom, certificate);
            this.incorporateIssuerV2(certDom, certificate);
        }
    }

    private void incorporateSignedDataObjectProperties() {
        this.signedDataObjectPropertiesDom = DomUtils.addElement(this.documentDom, this.signedPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignedDataObjectProperties");
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference reference : references) {
            String dataObjectFormatObjectReference = "#" + reference.getId();
            Element dataObjectFormatDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:DataObjectFormat");
            dataObjectFormatDom.setAttribute("ObjectReference", dataObjectFormatObjectReference);
            Element mimeTypeDom = DomUtils.addElement(this.documentDom, dataObjectFormatDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:MimeType");
            MimeType dataObjectFormatMimeType = this.getReferenceMimeType(reference);
            DomUtils.setTextNode(this.documentDom, mimeTypeDom, dataObjectFormatMimeType.getMimeTypeString());
        }
        this.incorporateCommitmentTypeIndications();
        this.incorporateContentTimestamps();
    }

    private MimeType getReferenceMimeType(DSSReference reference) {
        MimeType dataObjectFormatMimeType = MimeType.BINARY;
        DSSDocument content = reference.getContents();
        if (content != null && content.getMimeType() != null) {
            dataObjectFormatMimeType = content.getMimeType();
        }
        return dataObjectFormatMimeType;
    }

    private void incorporateContentTimestamps() {
        List<TimestampToken> contentTimestamps = this.params.getContentTimestamps();
        if (contentTimestamps == null) {
            return;
        }
        for (TimestampToken contentTimestamp : contentTimestamps) {
            String timestampId = TIMESTAMP_SUFFIX + contentTimestamp.getDSSIdAsString();
            TimestampType timeStampType = contentTimestamp.getTimeStampType();
            if (TimestampType.ALL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                Element allDataObjectsTimestampDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:AllDataObjectsTimeStamp");
                allDataObjectsTimestampDom.setAttribute("Id", timestampId);
                this.addTimestamp(allDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            if (TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP.equals((Object)timeStampType)) {
                Element individualDataObjectsTimestampDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:IndividualDataObjectsTimeStamp");
                individualDataObjectsTimestampDom.setAttribute("Id", timestampId);
                this.addTimestamp(individualDataObjectsTimestampDom, contentTimestamp);
                continue;
            }
            throw new DSSException("Only types ALL_DATA_OBJECTS_TIMESTAMP and INDIVIDUAL_DATA_OBJECTS_TIMESTAMP are allowed");
        }
    }

    private void incorporateSignerRole() {
        List<String> claimedSignerRoles = this.params.bLevel().getClaimedSignerRoles();
        if (claimedSignerRoles != null) {
            Element signerRoleDom = this.params.isEn319132() ? DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignerRoleV2") : DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignerRole");
            if (Utils.isCollectionNotEmpty(claimedSignerRoles)) {
                Element claimedRolesDom = DomUtils.addElement(this.documentDom, signerRoleDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:ClaimedRoles");
                this.addRoles(claimedSignerRoles, claimedRolesDom, "xades:ClaimedRole");
            }
        }
    }

    private void addRoles(List<String> signerRoles, Element rolesDom, String roleType) {
        for (String signerRole : signerRoles) {
            Element roleDom = DomUtils.addElement(this.documentDom, rolesDom, XAdESNamespaces.getXAdESDefaultNamespace(), roleType);
            DomUtils.setTextNode(this.documentDom, roleDom, signerRole);
        }
    }

    private void incorporateSignatureProductionPlace() {
        SignerLocation signatureProductionPlace = this.params.bLevel().getSignerLocation();
        if (signatureProductionPlace != null) {
            String country;
            String postalCode;
            String stateOrProvince;
            String streetAddress;
            Element signatureProductionPlaceDom = this.params.isEn319132() ? DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignatureProductionPlaceV2") : DomUtils.addElement(this.documentDom, this.signedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:SignatureProductionPlace");
            String city = signatureProductionPlace.getLocality();
            if (city != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:City", city);
            }
            if (this.params.isEn319132() && (streetAddress = signatureProductionPlace.getStreet()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:StreetAddress", streetAddress);
            }
            if ((stateOrProvince = signatureProductionPlace.getStateOrProvince()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:StateOrProvince", stateOrProvince);
            }
            if ((postalCode = signatureProductionPlace.getPostalCode()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:PostalCode", postalCode);
            }
            if ((country = signatureProductionPlace.getCountry()) != null) {
                DomUtils.addTextElement(this.documentDom, signatureProductionPlaceDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CountryName", country);
            }
        }
    }

    private void incorporateCommitmentTypeIndications() {
        List<String> commitmentTypeIndications = this.params.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            for (String commitmentTypeIndication : commitmentTypeIndications) {
                Element commitmentTypeIndicationDom = DomUtils.addElement(this.documentDom, this.signedDataObjectPropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CommitmentTypeIndication");
                Element commitmentTypeIdDom = DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CommitmentTypeId");
                DomUtils.addTextElement(this.documentDom, commitmentTypeIdDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:Identifier", commitmentTypeIndication);
                DomUtils.addElement(this.documentDom, commitmentTypeIndicationDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:AllSignedDataObjects");
            }
        }
    }

    @Override
    public DSSDocument signDocument(byte[] signatureValue) throws DSSException {
        if (!this.built) {
            this.build();
        }
        EncryptionAlgorithm encryptionAlgorithm = this.params.getEncryptionAlgorithm();
        byte[] signatureValueBytes = DSSSignatureUtils.convertToXmlDSig(encryptionAlgorithm, signatureValue);
        String signatureValueBase64Encoded = Utils.toBase64(signatureValueBytes);
        Text signatureValueNode = this.documentDom.createTextNode(signatureValueBase64Encoded);
        this.signatureValueDom.appendChild(signatureValueNode);
        return this.createXmlDocument();
    }

    protected void addTimestamp(Element timestampElement, TimestampToken token) {
        String canonicalizationMethod;
        List<TimestampInclude> includes = token.getTimestampIncludes();
        if (includes != null) {
            for (TimestampInclude include : includes) {
                Element timestampIncludeElement = this.documentDom.createElementNS(XAdESNamespaces.getXAdESDefaultNamespace(), "xades:Include");
                String uri = include.getURI();
                if (!uri.startsWith("#")) {
                    uri = "#" + uri;
                }
                timestampIncludeElement.setAttribute("URI", uri);
                timestampIncludeElement.setAttribute("referencedData", "true");
                timestampElement.appendChild(timestampIncludeElement);
            }
        }
        if (Utils.isStringNotEmpty(canonicalizationMethod = token.getCanonicalizationMethod())) {
            Element canonicalizationMethodElement = this.documentDom.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
            canonicalizationMethodElement.setAttribute("Algorithm", canonicalizationMethod);
            timestampElement.appendChild(canonicalizationMethodElement);
        }
        Element encapsulatedTimestampElement = this.documentDom.createElementNS(XAdESNamespaces.getXAdESDefaultNamespace(), "xades:EncapsulatedTimeStamp");
        encapsulatedTimestampElement.setTextContent(Utils.toBase64(token.getEncoded()));
        timestampElement.appendChild(encapsulatedTimestampElement);
    }

    protected byte[] applyTransformations(DSSDocument dssDocument, List<DSSTransform> transforms, Node nodeToTransform) {
        byte[] transformedReferenceBytes = null;
        for (DSSTransform transform : transforms) {
            if (nodeToTransform == null) {
                nodeToTransform = DomUtils.buildDOM(dssDocument);
            }
            transformedReferenceBytes = transform.getBytesAfterTranformation(nodeToTransform);
            nodeToTransform = DomUtils.buildDOM(transformedReferenceBytes);
        }
        return transformedReferenceBytes;
    }

    protected Node getNodeToCanonicalize(Node node) {
        if (this.params.isPrettyPrint()) {
            return DSSXMLUtils.getIndentedNode(this.documentDom, node);
        }
        return node;
    }

    @Override
    protected void alignNodes() {
        if (this.unsignedSignaturePropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.unsignedSignaturePropertiesDom);
        }
        if (this.qualifyingPropertiesDom != null) {
            DSSXMLUtils.alignChildrenIndents(this.qualifyingPropertiesDom);
        }
    }
}

