/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.XAdESNamespaces;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.ResponderId;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.w3c.dom.Element;

public class XAdESLevelC
extends XAdESLevelBaselineT {
    public XAdESLevelC(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    private void incorporateCRLRefs(Element completeRevocationRefsDom, Set<RevocationToken> processedRevocationTokens) throws DSSException {
        RevocationToken revocationToken;
        if (processedRevocationTokens.isEmpty()) {
            return;
        }
        boolean containsCrlToken = false;
        Iterator<RevocationToken> iterator = processedRevocationTokens.iterator();
        while (iterator.hasNext() && !(containsCrlToken = (revocationToken = iterator.next()) instanceof CRLToken)) {
        }
        if (!containsCrlToken) {
            return;
        }
        Element crlRefsDom = DomUtils.addElement(this.documentDom, completeRevocationRefsDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CRLRefs");
        for (RevocationToken revocationToken2 : processedRevocationTokens) {
            if (!(revocationToken2 instanceof CRLToken)) continue;
            CRLToken crl = (CRLToken)revocationToken2;
            Element crlRefDom = DomUtils.addElement(this.documentDom, crlRefsDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CRLRef");
            Element digestAlgAndValueDom = DomUtils.addElement(this.documentDom, crlRefDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:DigestAlgAndValue");
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA1;
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, revocationToken2);
            Element crlIdentifierDom = DomUtils.addElement(this.documentDom, crlRefDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CRLIdentifier");
            String issuerX500PrincipalName = crl.getIssuerX500Principal().getName();
            DomUtils.addTextElement(this.documentDom, crlIdentifierDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:Issuer", issuerX500PrincipalName);
            Date thisUpdate = crl.getThisUpdate();
            XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar(thisUpdate);
            String thisUpdateAsXmlFormat = xmlGregorianCalendar.toXMLFormat();
            DomUtils.addTextElement(this.documentDom, crlIdentifierDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:IssueTime", thisUpdateAsXmlFormat);
        }
    }

    private void incorporateOCSPRefs(Element completeRevocationRefsDom, Set<RevocationToken> processedRevocationTokens) throws DSSException {
        RevocationToken revocationToken;
        if (processedRevocationTokens.isEmpty()) {
            return;
        }
        boolean containsOCSPToken = false;
        Iterator<RevocationToken> iterator = processedRevocationTokens.iterator();
        while (iterator.hasNext() && !(containsOCSPToken = (revocationToken = iterator.next()) instanceof OCSPToken)) {
        }
        if (!containsOCSPToken) {
            return;
        }
        Element ocspRefsDom = DomUtils.addElement(this.documentDom, completeRevocationRefsDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:OCSPRefs");
        for (RevocationToken revocationToken2 : processedRevocationTokens) {
            BasicOCSPResp basicOcspResp;
            if (!(revocationToken2 instanceof OCSPToken) || (basicOcspResp = ((OCSPToken)revocationToken2).getBasicOCSPResp()) == null) continue;
            Element ocspRefDom = DomUtils.addElement(this.documentDom, ocspRefsDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:OCSPRef");
            Element ocspIdentifierDom = DomUtils.addElement(this.documentDom, ocspRefDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:OCSPIdentifier");
            Element responderIDDom = DomUtils.addElement(this.documentDom, ocspIdentifierDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:ResponderID");
            RespID respID = basicOcspResp.getResponderId();
            ResponderId responderId = DSSRevocationUtils.getDSSResponderId(respID);
            if (Utils.isStringNotEmpty(responderId.getName())) {
                DomUtils.addTextElement(this.documentDom, responderIDDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:ByName", responderId.getName());
            } else {
                String base64EncodedKeyHashOctetStringBytes = Utils.toBase64(responderId.getKey());
                DomUtils.addTextElement(this.documentDom, responderIDDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:ByKey", base64EncodedKeyHashOctetStringBytes);
            }
            Date producedAt = basicOcspResp.getProducedAt();
            XMLGregorianCalendar xmlGregorianCalendar = DomUtils.createXMLGregorianCalendar(producedAt);
            String producedAtXmlEncoded = xmlGregorianCalendar.toXMLFormat();
            DomUtils.addTextElement(this.documentDom, ocspIdentifierDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:ProducedAt", producedAtXmlEncoded);
            Element digestAlgAndValueDom = DomUtils.addElement(this.documentDom, ocspRefDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:DigestAlgAndValue");
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA1;
            this.incorporateDigestMethod(digestAlgAndValueDom, digestAlgorithm);
            this.incorporateDigestValue(digestAlgAndValueDom, digestAlgorithm, revocationToken2);
        }
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        Element levelTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (!this.xadesSignature.hasCProfile() || SignatureLevel.XAdES_C.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel)) {
            ValidationContext validationContext = this.xadesSignature.getSignatureValidationContext(this.certificateVerifier);
            Element toRemove = this.xadesSignature.getCompleteCertificateRefs();
            this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
            Element completeCertificateRefsDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CompleteCertificateRefs");
            Element certRefsDom = DomUtils.addElement(this.documentDom, completeCertificateRefsDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CertRefs");
            CertificateToken certificateToken = this.xadesSignature.getSigningCertificateToken();
            Set<CertificateToken> processedCertificateTokens = validationContext.getProcessedCertificates();
            HashSet<CertificateToken> processedCertificateTokenList = new HashSet<CertificateToken>();
            processedCertificateTokenList.addAll(processedCertificateTokens);
            processedCertificateTokenList.remove(certificateToken);
            HashSet<CertificateToken> x509CertificateProcessedList = processedCertificateTokenList;
            this.incorporateCertificateRef(certRefsDom, x509CertificateProcessedList);
            toRemove = this.xadesSignature.getCompleteRevocationRefs();
            this.removeChild(this.unsignedSignaturePropertiesDom, toRemove);
            Element completeRevocationRefsDom = DomUtils.addElement(this.documentDom, this.unsignedSignaturePropertiesDom, XAdESNamespaces.getXAdESDefaultNamespace(), "xades:CompleteRevocationRefs");
            this.incorporateCRLRefs(completeRevocationRefsDom, validationContext.getProcessedRevocations());
            this.incorporateOCSPRefs(completeRevocationRefsDom, validationContext.getProcessedRevocations());
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelTUnsignedProperties);
        }
    }
}

