/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.List;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.XMLSignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class XAdESSignatureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESSignatureUtils.class);

    public static List<DSSDocument> getSignerDocuments(XAdESSignature signature) {
        signature.checkSignatureIntegrity();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        SignatureCryptographicVerification signatureCryptographicVerification = signature.getSignatureCryptographicVerification();
        if (!signatureCryptographicVerification.isSignatureValid()) {
            return result;
        }
        List<Reference> references = signature.getReferences();
        if (Utils.isCollectionNotEmpty(references)) {
            for (Reference reference : references) {
                DSSDocument referenceDocument;
                if (!XAdESSignatureUtils.isReferenceLinkedToDocument(reference, signature) || (referenceDocument = XAdESSignatureUtils.getReferenceDocument(reference, signature)) == null) continue;
                result.add(referenceDocument);
            }
        }
        return result;
    }

    private static DSSDocument getReferenceDocument(Reference reference, XAdESSignature signature) {
        if (reference.typeIsReferenceToObject()) {
            List<Element> signatureObjects = signature.getSignatureObjects();
            for (Element sigObject : signatureObjects) {
                byte[] bytes;
                String objectId = sigObject.getAttribute("Id");
                if (!Utils.endsWithIgnoreCase(reference.getURI(), objectId) || (bytes = DSSXMLUtils.getNodeBytes(sigObject)) == null) continue;
                return new InMemoryDocument(bytes, objectId);
            }
        } else {
            try {
                return new InMemoryDocument(reference.getReferencedBytes(), reference.getURI());
            }
            catch (XMLSignatureException e) {
                LOG.warn("Unable to retrieve reference {}", (Object)reference.getId(), (Object)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("A referenced document not found for a reference with Id : [{}]", (Object)reference.getId());
        }
        return null;
    }

    private static boolean isReferenceLinkedToDocument(Reference reference, XAdESSignature signature) {
        String referenceType = reference.getType();
        if (Utils.isStringEmpty(referenceType)) {
            String referenceUri = reference.getURI();
            referenceUri = DomUtils.getId(referenceUri);
            Element element = DomUtils.getElement(signature.getSignatureElement(), "./*" + DomUtils.getXPathByIdAttribute(referenceUri));
            return element == null;
        }
        return DSSXMLUtils.isObjectReferenceType(referenceType) || DSSXMLUtils.isManifestReferenceType(referenceType);
    }
}

