/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.signature.DocumentSignatureService;
import eu.europa.esig.dss.ws.converter.DTOConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteDocument;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.signature.common.AbstractRemoteSignatureServiceImpl;
import eu.europa.esig.dss.ws.signature.common.RemoteDocumentSignatureService;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDocumentSignatureServiceImpl
extends AbstractRemoteSignatureServiceImpl
implements RemoteDocumentSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteDocumentSignatureServiceImpl.class);
    private DocumentSignatureService<XAdESSignatureParameters> xadesService;
    private DocumentSignatureService<CAdESSignatureParameters> cadesService;
    private DocumentSignatureService<PAdESSignatureParameters> padesService;
    private DocumentSignatureService<ASiCWithXAdESSignatureParameters> asicWithXAdESService;
    private DocumentSignatureService<ASiCWithCAdESSignatureParameters> asicWithCAdESService;

    public void setXadesService(DocumentSignatureService<XAdESSignatureParameters> xadesService) {
        this.xadesService = xadesService;
    }

    public void setCadesService(DocumentSignatureService<CAdESSignatureParameters> cadesService) {
        this.cadesService = cadesService;
    }

    public void setPadesService(DocumentSignatureService<PAdESSignatureParameters> padesService) {
        this.padesService = padesService;
    }

    public void setAsicWithXAdESService(DocumentSignatureService<ASiCWithXAdESSignatureParameters> asicWithXAdESService) {
        this.asicWithXAdESService = asicWithXAdESService;
    }

    public void setAsicWithCAdESService(DocumentSignatureService<ASiCWithCAdESSignatureParameters> asicWithCAdESService) {
        this.asicWithCAdESService = asicWithCAdESService;
    }

    private DocumentSignatureService getServiceForSignature(RemoteSignatureParameters parameters) {
        ASiCContainerType asicContainerType = parameters.getAsicContainerType();
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        SignatureForm signatureForm = signatureLevel.getSignatureForm();
        if (asicContainerType != null) {
            switch (signatureForm) {
                case XAdES: {
                    return this.asicWithXAdESService;
                }
                case CAdES: {
                    return this.asicWithCAdESService;
                }
            }
            throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + (Object)((Object)signatureForm));
        }
        switch (signatureForm) {
            case XAdES: {
                return this.xadesService;
            }
            case CAdES: {
                return this.cadesService;
            }
            case PAdES: {
                return this.padesService;
            }
        }
        throw new DSSException("Unrecognized format " + (Object)((Object)signatureLevel));
    }

    @Override
    public ToBeSignedDTO getDataToSign(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters) {
        LOG.info("GetDataToSign in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters);
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
        ToBeSigned dataToSign = service.getDataToSign(dssDocument, parameters);
        LOG.info("GetDataToSign is finished");
        return DTOConverter.toToBeSignedDTO(dataToSign);
    }

    @Override
    public RemoteDocument signDocument(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters, SignatureValueDTO signatureValueDTO) {
        LOG.info("SignDocument in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters);
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
        DSSDocument signDocument = service.signDocument(dssDocument, parameters, this.toSignatureValue(signatureValueDTO));
        LOG.info("SignDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(signDocument);
    }

    @Override
    public RemoteDocument extendDocument(RemoteDocument remoteDocument, RemoteSignatureParameters remoteParameters) {
        LOG.info("ExtendDocument in process...");
        AbstractSignatureParameters parameters = this.createParameters(remoteParameters);
        DocumentSignatureService service = this.getServiceForSignature(remoteParameters);
        DSSDocument dssDocument = RemoteDocumentConverter.toDSSDocument(remoteDocument);
        DSSDocument extendDocument = service.extendDocument(dssDocument, parameters);
        LOG.info("ExtendDocument is finished");
        return RemoteDocumentConverter.toRemoteDocument(extendDocument);
    }
}

