/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.signature.common;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.model.BLevelParameters;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.SignerLocation;
import eu.europa.esig.dss.model.TimestampParameters;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.pades.PAdESSignatureParameters;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.ws.converter.RemoteCertificateConverter;
import eu.europa.esig.dss.ws.converter.RemoteDocumentConverter;
import eu.europa.esig.dss.ws.dto.RemoteCertificate;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteBLevelParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteSignatureParameters;
import eu.europa.esig.dss.ws.signature.dto.parameters.RemoteTimestampParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import java.util.List;

public abstract class AbstractRemoteSignatureServiceImpl {
    protected AbstractSignatureParameters getASiCSignatureParameters(ASiCContainerType asicContainerType, SignatureForm signatureForm) {
        switch (signatureForm) {
            case CAdES: {
                ASiCWithCAdESSignatureParameters asicWithCAdESParameters = new ASiCWithCAdESSignatureParameters();
                asicWithCAdESParameters.aSiC().setContainerType(asicContainerType);
                return asicWithCAdESParameters;
            }
            case XAdES: {
                ASiCWithXAdESSignatureParameters asicWithXAdESParameters = new ASiCWithXAdESSignatureParameters();
                asicWithXAdESParameters.aSiC().setContainerType(asicContainerType);
                return asicWithXAdESParameters;
            }
        }
        throw new DSSException("Unrecognized format (XAdES or CAdES are allowed with ASiC) : " + (Object)((Object)signatureForm));
    }

    protected AbstractSignatureParameters createParameters(RemoteSignatureParameters remoteParameters) {
        AbstractSignatureParameters parameters = null;
        ASiCContainerType asicContainerType = remoteParameters.getAsicContainerType();
        SignatureForm signatureForm = remoteParameters.getSignatureLevel().getSignatureForm();
        if (asicContainerType != null) {
            parameters = this.getASiCSignatureParameters(asicContainerType, signatureForm);
        } else {
            switch (signatureForm) {
                case CAdES: {
                    parameters = new CAdESSignatureParameters();
                    break;
                }
                case PAdES: {
                    PAdESSignatureParameters padesParams = new PAdESSignatureParameters();
                    padesParams.setSignatureSize(18944);
                    parameters = padesParams;
                    break;
                }
                case XAdES: {
                    parameters = new XAdESSignatureParameters();
                    break;
                }
                default: {
                    throw new DSSException("Unsupported signature form : " + (Object)((Object)signatureForm));
                }
            }
        }
        this.fillParameters(parameters, remoteParameters);
        return parameters;
    }

    protected void fillParameters(AbstractSignatureParameters parameters, RemoteSignatureParameters remoteParameters) {
        List<RemoteCertificate> remoteCertificateChain;
        parameters.setBLevelParams(this.toBLevelParameters(remoteParameters.getBLevelParams()));
        parameters.setDetachedContents(RemoteDocumentConverter.toDSSDocuments(remoteParameters.getDetachedContents()));
        parameters.setDigestAlgorithm(remoteParameters.getDigestAlgorithm());
        parameters.setEncryptionAlgorithm(remoteParameters.getEncryptionAlgorithm());
        parameters.setReferenceDigestAlgorithm(remoteParameters.getReferenceDigestAlgorithm());
        parameters.setSignatureLevel(remoteParameters.getSignatureLevel());
        parameters.setSignaturePackaging(remoteParameters.getSignaturePackaging());
        parameters.setSignatureTimestampParameters(this.toTimestampParameters(remoteParameters.getSignatureTimestampParameters()));
        parameters.setArchiveTimestampParameters(this.toTimestampParameters(remoteParameters.getArchiveTimestampParameters()));
        parameters.setContentTimestampParameters(this.toTimestampParameters(remoteParameters.getContentTimestampParameters()));
        parameters.setSignWithExpiredCertificate(remoteParameters.isSignWithExpiredCertificate());
        parameters.setGenerateTBSWithoutCertificate(remoteParameters.isGenerateTBSWithoutCertificate());
        RemoteCertificate signingCertificate = remoteParameters.getSigningCertificate();
        if (signingCertificate != null) {
            CertificateToken certificateToken = RemoteCertificateConverter.toCertificateToken(signingCertificate);
            parameters.setSigningCertificate(certificateToken);
        }
        if (Utils.isCollectionNotEmpty(remoteCertificateChain = remoteParameters.getCertificateChain())) {
            parameters.setCertificateChain(RemoteCertificateConverter.toCertificateTokens(remoteCertificateChain));
        }
    }

    private BLevelParameters toBLevelParameters(RemoteBLevelParameters remoteBLevelParameters) {
        BLevelParameters bLevelParameters = new BLevelParameters();
        bLevelParameters.setClaimedSignerRoles(remoteBLevelParameters.getClaimedSignerRoles());
        bLevelParameters.setCommitmentTypeIndications(remoteBLevelParameters.getCommitmentTypeIndications());
        bLevelParameters.setSigningDate(remoteBLevelParameters.getSigningDate());
        bLevelParameters.setTrustAnchorBPPolicy(remoteBLevelParameters.isTrustAnchorBPPolicy());
        Policy policy = new Policy();
        policy.setDescription(remoteBLevelParameters.getPolicyDescription());
        policy.setDigestAlgorithm(remoteBLevelParameters.getPolicyDigestAlgorithm());
        policy.setDigestValue(remoteBLevelParameters.getPolicyDigestValue());
        policy.setId(remoteBLevelParameters.getPolicyId());
        policy.setQualifier(remoteBLevelParameters.getPolicyQualifier());
        policy.setSpuri(remoteBLevelParameters.getPolicySpuri());
        bLevelParameters.setSignaturePolicy(policy);
        SignerLocation signerLocation = new SignerLocation();
        signerLocation.setCountry(remoteBLevelParameters.getSignerLocationCountry());
        signerLocation.setLocality(remoteBLevelParameters.getSignerLocationLocality());
        signerLocation.setPostalAddress(remoteBLevelParameters.getSignerLocationPostalAddress());
        signerLocation.setPostalCode(remoteBLevelParameters.getSignerLocationPostalCode());
        signerLocation.setStateOrProvince(remoteBLevelParameters.getSignerLocationStateOrProvince());
        signerLocation.setStreet(remoteBLevelParameters.getSignerLocationStreet());
        bLevelParameters.setSignerLocation(signerLocation);
        return bLevelParameters;
    }

    private TimestampParameters toTimestampParameters(RemoteTimestampParameters remoteTimestampParameters) {
        TimestampParameters timestampParameters = new TimestampParameters();
        timestampParameters.setCanonicalizationMethod(remoteTimestampParameters.getCanonicalizationMethod());
        timestampParameters.setDigestAlgorithm(remoteTimestampParameters.getDigestAlgorithm());
        return timestampParameters;
    }

    protected SignatureValue toSignatureValue(SignatureValueDTO signatureValueDTO) {
        return new SignatureValue(signatureValueDTO.getAlgorithm(), signatureValueDTO.getValue());
    }
}

