/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.EncapsulatedCertificateTokenIdentifier;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.ISignatureAttribute;
import eu.europa.esig.dss.validation.ListCRLSource;
import eu.europa.esig.dss.validation.ListOCSPSource;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimestampSource<SignatureAttribute extends ISignatureAttribute>
implements SignatureTimestampSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTimestampSource.class);
    protected final SignatureCertificateSource signatureCertificateSource;
    protected final SignatureCRLSource signatureCRLSource;
    protected final SignatureOCSPSource signatureOCSPSource;
    protected final String signatureId;
    protected final transient List<SignatureScope> signatureScopes;
    protected CertificatePool certificatePool;
    protected ListCRLSource crlSource;
    protected ListOCSPSource ocspSource;
    protected CommonCertificateSource timestampCertificateSource = new CommonCertificateSource();
    private Map<String, List<CertificateToken>> certificateMap;
    private List<TimestampToken> contentTimestamps;
    private List<TimestampToken> signatureTimestamps;
    private List<TimestampToken> sigAndRefsTimestamps;
    private List<TimestampToken> refsOnlyTimestamps;
    private List<TimestampToken> archiveTimestamps;

    protected AbstractTimestampSource(AdvancedSignature signature) {
        this.signatureCertificateSource = signature.getCertificateSource();
        this.signatureCRLSource = signature.getCRLSource();
        this.signatureOCSPSource = signature.getOCSPSource();
        this.signatureId = signature.getId();
        this.signatureScopes = signature.getSignatureScopes();
    }

    @Override
    public List<TimestampToken> getContentTimestamps() {
        if (this.contentTimestamps == null) {
            this.createAndValidate();
        }
        return this.contentTimestamps;
    }

    @Override
    public List<TimestampToken> getSignatureTimestamps() {
        if (this.signatureTimestamps == null) {
            this.createAndValidate();
        }
        return this.signatureTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX1() {
        if (this.sigAndRefsTimestamps == null) {
            this.createAndValidate();
        }
        return this.sigAndRefsTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX2() {
        if (this.refsOnlyTimestamps == null) {
            this.createAndValidate();
        }
        return this.refsOnlyTimestamps;
    }

    @Override
    public List<TimestampToken> getArchiveTimestamps() {
        if (this.archiveTimestamps == null) {
            this.createAndValidate();
        }
        return this.archiveTimestamps;
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        return Collections.emptyList();
    }

    @Override
    public List<TimestampToken> getAllTimestamps() {
        ArrayList<TimestampToken> timestampTokens = new ArrayList<TimestampToken>();
        timestampTokens.addAll(this.getContentTimestamps());
        timestampTokens.addAll(this.getSignatureTimestamps());
        timestampTokens.addAll(this.getTimestampsX1());
        timestampTokens.addAll(this.getTimestampsX2());
        timestampTokens.addAll(this.getArchiveTimestamps());
        return timestampTokens;
    }

    @Override
    public ListCRLSource getCommonCRLSource() {
        if (this.crlSource == null) {
            this.createAndValidate();
        }
        return this.crlSource;
    }

    @Override
    public ListOCSPSource getCommonOCSPSource() {
        if (this.ocspSource == null) {
            this.createAndValidate();
        }
        return this.ocspSource;
    }

    protected void createAndValidate() {
        this.makeTimestampTokens();
        this.validateTimestamps();
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (this.archiveTimestamps == null) {
            this.createAndValidate();
        }
        this.processExternalTimestamp(timestamp);
        switch (timestamp.getTimeStampType()) {
            case CONTENT_TIMESTAMP: 
            case ALL_DATA_OBJECTS_TIMESTAMP: 
            case INDIVIDUAL_DATA_OBJECTS_TIMESTAMP: {
                this.contentTimestamps.add(timestamp);
                break;
            }
            case SIGNATURE_TIMESTAMP: {
                this.signatureTimestamps.add(timestamp);
                break;
            }
            case VALIDATION_DATA_REFSONLY_TIMESTAMP: {
                this.refsOnlyTimestamps.add(timestamp);
                break;
            }
            case VALIDATION_DATA_TIMESTAMP: {
                this.sigAndRefsTimestamps.add(timestamp);
                break;
            }
            case ARCHIVE_TIMESTAMP: {
                this.archiveTimestamps.add(timestamp);
                break;
            }
            default: {
                LOG.warn("The signature timestamp source does not support timestamp tokens with type [{}]. The TimestampToken was not added.", (Object)timestamp.getTimeStampType().name());
            }
        }
    }

    protected void makeTimestampTokens() {
        this.contentTimestamps = new ArrayList<TimestampToken>();
        this.signatureTimestamps = new ArrayList<TimestampToken>();
        this.sigAndRefsTimestamps = new ArrayList<TimestampToken>();
        this.refsOnlyTimestamps = new ArrayList<TimestampToken>();
        this.archiveTimestamps = new ArrayList<TimestampToken>();
        this.crlSource = new ListCRLSource(this.signatureCRLSource);
        this.ocspSource = new ListOCSPSource(this.signatureOCSPSource);
        SignatureProperties<SignatureAttribute> signedSignatureProperties = this.getSignedSignatureProperties();
        List<SignatureAttribute> signedAttributes = signedSignatureProperties.getAttributes();
        for (ISignatureAttribute signedAttribute : signedAttributes) {
            List<TimestampedReference> references;
            TimestampToken timestampToken;
            if (this.isContentTimestamp(signedAttribute) ? (timestampToken = this.makeTimestampToken(signedAttribute, TimestampType.CONTENT_TIMESTAMP, this.getAllContentTimestampReferences())) == null : (this.isAllDataObjectsTimestamp(signedAttribute) ? (timestampToken = this.makeTimestampToken(signedAttribute, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP, this.getAllContentTimestampReferences())) == null : !this.isIndividualDataObjectsTimestamp(signedAttribute) || (timestampToken = this.makeTimestampToken(signedAttribute, TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP, references = this.getIndividualContentTimestampedReferences(signedAttribute))) == null)) continue;
            this.populateTimestampCertificateSource(timestampToken);
            this.contentTimestamps.add(timestampToken);
        }
        SignatureProperties<SignatureAttribute> unsignedSignatureProperties = this.getUnsignedSignatureProperties();
        if (!unsignedSignatureProperties.isExist()) {
            return;
        }
        ArrayList<TimestampToken> timestamps = new ArrayList<TimestampToken>();
        ArrayList<TimestampedReference> encapsulatedReferences = new ArrayList<TimestampedReference>();
        List<SignatureAttribute> unsignedAttributes = unsignedSignatureProperties.getAttributes();
        for (ISignatureAttribute unsignedAttribute : unsignedAttributes) {
            TimestampToken timestampToken;
            if (this.isSignatureTimestamp(unsignedAttribute)) {
                timestampToken = this.makeTimestampToken(unsignedAttribute, TimestampType.SIGNATURE_TIMESTAMP, this.getSignatureTimestampReferences());
                if (timestampToken == null) continue;
                this.signatureTimestamps.add(timestampToken);
            } else {
                ArrayList<TimestampedReference> references;
                if (this.isCompleteCertificateRef(unsignedAttribute)) {
                    encapsulatedReferences.addAll(this.getTimestampedCertificateRefs(unsignedAttribute));
                    continue;
                }
                if (this.isAttributeCertificateRef(unsignedAttribute)) {
                    encapsulatedReferences.addAll(this.getTimestampedCertificateRefs(unsignedAttribute));
                    continue;
                }
                if (this.isCompleteRevocationRef(unsignedAttribute)) {
                    encapsulatedReferences.addAll(this.getTimestampedRevocationRefs(unsignedAttribute));
                    continue;
                }
                if (this.isAttributeRevocationRef(unsignedAttribute)) {
                    encapsulatedReferences.addAll(this.getTimestampedRevocationRefs(unsignedAttribute));
                    continue;
                }
                if (this.isRefsOnlyTimestamp(unsignedAttribute)) {
                    timestampToken = this.makeTimestampToken(unsignedAttribute, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP, encapsulatedReferences);
                    if (timestampToken == null) continue;
                    this.refsOnlyTimestamps.add(timestampToken);
                } else if (this.isSigAndRefsTimestamp(unsignedAttribute)) {
                    references = new ArrayList<TimestampedReference>();
                    this.addReferencesForPreviousTimestamps(references, this.filterSignatureTimestamps(timestamps));
                    this.addReferences(references, encapsulatedReferences);
                    timestampToken = this.makeTimestampToken(unsignedAttribute, TimestampType.VALIDATION_DATA_TIMESTAMP, references);
                    if (timestampToken == null) continue;
                    this.sigAndRefsTimestamps.add(timestampToken);
                } else {
                    if (this.isCertificateValues(unsignedAttribute)) {
                        encapsulatedReferences.addAll(this.getTimestampedCertificateValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isRevocationValues(unsignedAttribute)) {
                        encapsulatedReferences.addAll(this.getTimestampedRevocationValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isArchiveTimestamp(unsignedAttribute)) {
                        references = new ArrayList();
                        this.addReferencesForPreviousTimestamps(references, timestamps);
                        this.addReferences(references, encapsulatedReferences);
                        timestampToken = this.makeTimestampToken(unsignedAttribute, TimestampType.ARCHIVE_TIMESTAMP, references);
                        if (timestampToken == null) continue;
                        timestampToken.setArchiveTimestampType(this.getArchiveTimestampType(unsignedAttribute));
                        this.addReferences(timestampToken.getTimestampedReferences(), this.getSignedDataReferences(timestampToken));
                        this.archiveTimestamps.add(timestampToken);
                    } else {
                        if (this.isTimeStampValidationData(unsignedAttribute)) {
                            encapsulatedReferences.addAll(this.getTimestampValidationData(unsignedAttribute));
                            continue;
                        }
                        LOG.warn("The unsigned attribute with name [{}] is not supported", (Object)unsignedAttribute.toString());
                        continue;
                    }
                }
            }
            this.populateTimestampCertificateSource(timestampToken);
            timestamps.add(timestampToken);
        }
    }

    protected abstract SignatureProperties<SignatureAttribute> getSignedSignatureProperties();

    protected abstract SignatureProperties<SignatureAttribute> getUnsignedSignatureProperties();

    protected abstract boolean isContentTimestamp(SignatureAttribute var1);

    protected abstract boolean isAllDataObjectsTimestamp(SignatureAttribute var1);

    protected abstract boolean isIndividualDataObjectsTimestamp(SignatureAttribute var1);

    protected abstract boolean isSignatureTimestamp(SignatureAttribute var1);

    protected abstract boolean isCompleteCertificateRef(SignatureAttribute var1);

    protected abstract boolean isAttributeCertificateRef(SignatureAttribute var1);

    protected abstract boolean isCompleteRevocationRef(SignatureAttribute var1);

    protected abstract boolean isAttributeRevocationRef(SignatureAttribute var1);

    protected abstract boolean isRefsOnlyTimestamp(SignatureAttribute var1);

    protected abstract boolean isSigAndRefsTimestamp(SignatureAttribute var1);

    protected abstract boolean isCertificateValues(SignatureAttribute var1);

    protected abstract boolean isRevocationValues(SignatureAttribute var1);

    protected abstract boolean isArchiveTimestamp(SignatureAttribute var1);

    protected abstract boolean isTimeStampValidationData(SignatureAttribute var1);

    protected abstract TimestampToken makeTimestampToken(SignatureAttribute var1, TimestampType var2, List<TimestampedReference> var3);

    protected List<TimestampedReference> getAllContentTimestampReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (Utils.isCollectionNotEmpty(this.signatureScopes)) {
            for (SignatureScope signatureScope : this.signatureScopes) {
                this.addReference(references, new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
        }
        return references;
    }

    protected abstract List<TimestampedReference> getIndividualContentTimestampedReferences(SignatureAttribute var1);

    protected List<TimestampedReference> getSignatureTimestampReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReferences(references, this.getAllContentTimestampReferences());
        this.addReference(references, new TimestampedReference(this.signatureId, TimestampedObjectType.SIGNATURE));
        this.addReferences(references, this.getSigningCertificateTimestampReferences());
        return references;
    }

    protected List<TimestampedReference> getSigningCertificateTimestampReferences() {
        return this.createReferencesForCertificates(this.signatureCertificateSource.getSigningCertificates());
    }

    protected List<TimestampedReference> createReferencesForCertificates(Collection<CertificateToken> certificates) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (CertificateToken certificateToken : certificates) {
            this.addReference(references, new TimestampedReference(certificateToken.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return references;
    }

    protected List<TimestampedReference> getTimestampedCertificateRefs(SignatureAttribute unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (Digest certDigest : this.getCertificateRefDigests(unsignedAttribute)) {
            CertificateToken certificate = this.signatureCertificateSource.getCertificateTokenByDigest(certDigest);
            if (certificate == null) {
                certificate = this.timestampCertificateSource.getCertificateTokenByDigest(certDigest);
            }
            if (certificate != null) {
                timestampedReferences.add(new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
                continue;
            }
            CertificateRef certificateRef = this.signatureCertificateSource.getCertificateRefByDigest(certDigest);
            if (certificateRef == null) continue;
            timestampedReferences.add(new TimestampedReference(certificateRef.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return timestampedReferences;
    }

    protected abstract List<Digest> getCertificateRefDigests(SignatureAttribute var1);

    protected List<TimestampedReference> getTimestampedRevocationRefs(SignatureAttribute unsignedAttribute) {
        Object identifier;
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (Digest refDigest : this.getRevocationRefCRLDigests(unsignedAttribute)) {
            identifier = this.crlSource.getIdentifier(refDigest);
            if (identifier != null) {
                timestampedReferences.add(new TimestampedReference(identifier.asXmlId(), TimestampedObjectType.REVOCATION));
                continue;
            }
            CRLRef crlRef = this.crlSource.getCRLRefByDigest(refDigest);
            if (crlRef == null) continue;
            timestampedReferences.add(new TimestampedReference(crlRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        for (Digest refDigest : this.getRevocationRefOCSPDigests(unsignedAttribute)) {
            identifier = this.ocspSource.getIdentifier(refDigest);
            if (identifier != null) {
                timestampedReferences.add(new TimestampedReference(((EncapsulatedRevocationTokenIdentifier)identifier).asXmlId(), TimestampedObjectType.REVOCATION));
                continue;
            }
            OCSPRef ocspRef = this.ocspSource.getOCSPRefByDigest(refDigest);
            if (ocspRef == null) continue;
            timestampedReferences.add(new TimestampedReference(ocspRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected abstract List<Digest> getRevocationRefCRLDigests(SignatureAttribute var1);

    protected abstract List<Digest> getRevocationRefOCSPDigests(SignatureAttribute var1);

    protected List<TimestampedReference> getTimestampedCertificateValues(SignatureAttribute unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (EncapsulatedCertificateTokenIdentifier certificateIdentifier : this.getEncapsulatedCertificateIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(certificateIdentifier.asXmlId(), TimestampedObjectType.CERTIFICATE));
        }
        return timestampedReferences;
    }

    protected abstract List<EncapsulatedCertificateTokenIdentifier> getEncapsulatedCertificateIdentifiers(SignatureAttribute var1);

    protected List<TimestampedReference> getTimestampedRevocationValues(SignatureAttribute unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (EncapsulatedRevocationTokenIdentifier encapsulatedRevocationTokenIdentifier : this.getEncapsulatedCRLIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(encapsulatedRevocationTokenIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        for (EncapsulatedRevocationTokenIdentifier encapsulatedRevocationTokenIdentifier : this.getEncapsulatedOCSPIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(encapsulatedRevocationTokenIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected abstract List<CRLBinary> getEncapsulatedCRLIdentifiers(SignatureAttribute var1);

    protected abstract List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(SignatureAttribute var1);

    protected List<TimestampedReference> getSignedDataReferences(TimestampToken timestampToken) {
        return new ArrayList<TimestampedReference>();
    }

    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        return new ArrayList<TimestampedReference>();
    }

    protected List<TimestampedReference> getTimestampValidationData(SignatureAttribute unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (EncapsulatedCertificateTokenIdentifier encapsulatedCertificateTokenIdentifier : this.getEncapsulatedCertificateIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(encapsulatedCertificateTokenIdentifier.asXmlId(), TimestampedObjectType.CERTIFICATE));
        }
        for (EncapsulatedRevocationTokenIdentifier encapsulatedRevocationTokenIdentifier : this.getEncapsulatedCRLIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(encapsulatedRevocationTokenIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        for (EncapsulatedRevocationTokenIdentifier encapsulatedRevocationTokenIdentifier : this.getEncapsulatedOCSPIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(encapsulatedRevocationTokenIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected void addReference(List<TimestampedReference> referenceList, TimestampedReference referenceToAdd) {
        this.addReferences(referenceList, Arrays.asList(referenceToAdd));
    }

    protected void addReferences(List<TimestampedReference> referenceList, List<TimestampedReference> referencesToAdd) {
        for (TimestampedReference reference : referencesToAdd) {
            if (referenceList.contains(reference)) continue;
            referenceList.add(reference);
        }
    }

    private List<TimestampToken> filterSignatureTimestamps(List<TimestampToken> previousTimestampedTimestamp) {
        ArrayList<TimestampToken> result = new ArrayList<TimestampToken>();
        for (TimestampToken timestampToken : previousTimestampedTimestamp) {
            if (!TimestampType.SIGNATURE_TIMESTAMP.equals((Object)timestampToken.getTimeStampType())) continue;
            result.add(timestampToken);
        }
        return result;
    }

    protected void addReferencesForPreviousTimestamps(List<TimestampedReference> references, List<TimestampToken> timestampedTimestamps) {
        for (TimestampToken timestampToken : timestampedTimestamps) {
            this.addReference(references, new TimestampedReference(timestampToken.getDSSIdAsString(), TimestampedObjectType.TIMESTAMP));
            this.addTimestampedReferences(references, timestampToken);
            this.addEncapsulatedValuesFromTimestamp(references, timestampToken);
        }
    }

    private void addTimestampedReferences(List<TimestampedReference> references, TimestampToken timestampedTimestamp) {
        for (TimestampedReference timestampedReference : timestampedTimestamp.getTimestampedReferences()) {
            this.addReference(references, timestampedReference);
        }
    }

    protected void addEncapsulatedValuesFromTimestamp(List<TimestampedReference> references, TimestampToken timestampedTimestamp) {
        List<CertificateToken> certificates = timestampedTimestamp.getCertificates();
        for (CertificateToken certificate : certificates) {
            this.addReference(references, new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
    }

    protected abstract ArchiveTimestampType getArchiveTimestampType(SignatureAttribute var1);

    protected void validateTimestamps() {
        byte[] timestampBytes;
        TimestampDataBuilder timestampDataBuilder = this.getTimestampDataBuilder();
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            timestampBytes = timestampDataBuilder.getContentTimestampData(timestampToken);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            timestampBytes = timestampDataBuilder.getSignatureTimestampData(timestampToken);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            timestampBytes = timestampDataBuilder.getTimestampX1Data(timestampToken);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            timestampBytes = timestampDataBuilder.getTimestampX2Data(timestampToken);
            timestampToken.matchData(timestampBytes);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            if (timestampToken.isProcessed()) continue;
            byte[] timestampData = timestampDataBuilder.getArchiveTimestampData(timestampToken);
            timestampToken.matchData(timestampData);
        }
    }

    protected abstract TimestampDataBuilder getTimestampDataBuilder();

    @Override
    public Map<String, List<CertificateToken>> getCertificateMapWithinTimestamps(boolean skipLastArchiveTimestamp) {
        if (this.certificateMap != null) {
            return this.certificateMap;
        }
        this.certificateMap = new HashMap<String, List<CertificateToken>>();
        int timestampCounter = 0;
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            this.certificateMap.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            this.certificateMap.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            this.certificateMap.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            this.certificateMap.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        List<TimestampToken> archiveTsps = this.getArchiveTimestamps();
        int archiveTimestampsSize = archiveTsps.size();
        if (skipLastArchiveTimestamp && archiveTimestampsSize > 0) {
            --archiveTimestampsSize;
        }
        for (int ii = 0; ii < archiveTimestampsSize; ++ii) {
            TimestampToken timestampToken = archiveTsps.get(ii);
            this.certificateMap.put(timestampToken.getTimeStampType().name() + timestampCounter++, timestampToken.getCertificates());
        }
        return this.certificateMap;
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return this.timestampCertificateSource.getCertificates();
    }

    protected void populateTimestampCertificateSource(TimestampToken timestamp) {
        this.populateTimestampCertificateSource(timestamp.getCertificates());
    }

    protected void populateTimestampCertificateSource(List<CertificateToken> certificates) {
        for (CertificateToken certificate : certificates) {
            this.timestampCertificateSource.addCertificate(certificate);
        }
    }

    private void processExternalTimestamp(TimestampToken externalTimestamp) {
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getSignatureSignedDataReferences());
        this.addReferencesForPreviousTimestamps(externalTimestamp.getTimestampedReferences(), this.getAllTimestamps());
        this.populateTimestampCertificateSource(externalTimestamp);
    }
}

