/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.BasicBuildingBlockDefinition;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.POEExistsAtOrBeforeControlTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.SatisfyingRevocationDataExistsCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ValidationTimeSliding
extends Chain<XmlVTS> {
    private final TokenProxy token;
    private final Date currentTime;
    private final Context context;
    private final POEExtraction poe;
    private final ValidationPolicy policy;
    private Date controlTime;

    public ValidationTimeSliding(TokenProxy token, Date currentTime, Context context, POEExtraction poe, ValidationPolicy policy) {
        super(new XmlVTS());
        ((XmlVTS)this.result).setTitle(BasicBuildingBlockDefinition.VALIDATION_TIME_SLIDING.getTitle());
        this.token = token;
        this.currentTime = currentTime;
        this.context = context;
        this.poe = poe;
        this.policy = policy;
    }

    @Override
    protected void initChain() {
        this.controlTime = this.currentTime;
        List<CertificateWrapper> certificateChain = this.token.getCertificateChain();
        if (Utils.isCollectionNotEmpty(certificateChain)) {
            certificateChain = this.reduceChainUntilFirstTrustAnchor(certificateChain);
            Collections.reverse(certificateChain);
            ChainItem<XmlVTS> item = null;
            for (CertificateWrapper certificate : certificateChain) {
                if (certificate.isTrusted()) continue;
                RevocationWrapper latestCompliantRevocation = null;
                List<CertificateRevocationWrapper> revocations = certificate.getCertificateRevocationData();
                for (CertificateRevocationWrapper revocation : revocations) {
                    if (latestCompliantRevocation != null && !revocation.getProductionDate().after(latestCompliantRevocation.getProductionDate()) || !this.isConsistant(certificate, revocation) || !this.isIssuanceBeforeControlTime(revocation)) continue;
                    latestCompliantRevocation = revocation;
                }
                if (item == null) {
                    this.firstItem = this.satisfyingRevocationDataExists(latestCompliantRevocation);
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(this.satisfyingRevocationDataExists(latestCompliantRevocation));
                }
                item = item.setNextItem(this.poeExistsAtOrBeforeControlTime(certificate, TimestampedObjectType.CERTIFICATE, this.controlTime));
                item = item.setNextItem(this.poeExistsAtOrBeforeControlTime(latestCompliantRevocation, TimestampedObjectType.REVOCATION, this.controlTime));
                if (latestCompliantRevocation != null) {
                    if (((CertificateRevocationWrapper)latestCompliantRevocation).isRevoked()) {
                        this.controlTime = ((CertificateRevocationWrapper)latestCompliantRevocation).getRevocationDate();
                    } else if (!this.isFresh(latestCompliantRevocation, this.controlTime)) {
                        this.controlTime = latestCompliantRevocation.getProductionDate();
                    }
                }
                item = item.setNextItem(this.cryptographicCheck(certificate, this.controlTime));
                item = item.setNextItem(this.cryptographicCheck(latestCompliantRevocation, this.controlTime));
            }
        }
    }

    private List<CertificateWrapper> reduceChainUntilFirstTrustAnchor(List<CertificateWrapper> originalCertificateChain) {
        ArrayList<CertificateWrapper> result = new ArrayList<CertificateWrapper>();
        for (CertificateWrapper cert : originalCertificateChain) {
            result.add(cert);
            if (!cert.isTrusted()) continue;
            break;
        }
        return result;
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlVTS)this.result).setControlTime(this.controlTime);
    }

    private boolean isFresh(RevocationWrapper revocationData, Date controlTime) {
        RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(revocationData, controlTime, this.context, SubContext.SIGNING_CERT, this.policy);
        XmlRFC execute = (XmlRFC)rfc.execute();
        return execute != null && execute.getConclusion() != null && Indication.PASSED.equals(execute.getConclusion().getIndication());
    }

    private ChainItem<XmlVTS> satisfyingRevocationDataExists(RevocationWrapper revocationData) {
        return new SatisfyingRevocationDataExistsCheck((XmlVTS)this.result, revocationData, this.getFailLevelConstraint());
    }

    private ChainItem<XmlVTS> poeExistsAtOrBeforeControlTime(TokenProxy token, TimestampedObjectType referenceCategory, Date controlTime) {
        return new POEExistsAtOrBeforeControlTimeCheck((XmlVTS)this.result, token, referenceCategory, controlTime, this.poe, this.getFailLevelConstraint());
    }

    private ChainItem<XmlVTS> cryptographicCheck(TokenProxy token, Date validationTime) {
        CryptographicConstraint constraint = this.policy.getCertificateCryptographicConstraint(this.context, SubContext.SIGNING_CERT);
        return new CryptographicCheck<XmlVTS>((XmlVTS)this.result, token, validationTime, constraint);
    }

    private boolean isConsistant(CertificateWrapper certificate, RevocationWrapper revocationData) {
        Date expiredCertsRevocationInfo;
        CertificateWrapper revocCert;
        Date archiveCutOff;
        Date thisUpdate;
        Date certNotBefore = certificate.getNotBefore();
        Date certNotAfter = certificate.getNotAfter();
        Date notAfterRevoc = thisUpdate = revocationData.getThisUpdate();
        Date expiredCertsOnCRL = revocationData.getExpiredCertsOnCRL();
        if (expiredCertsOnCRL != null) {
            notAfterRevoc = expiredCertsOnCRL;
        }
        if ((archiveCutOff = revocationData.getArchiveCutOff()) != null) {
            notAfterRevoc = archiveCutOff;
        }
        if (expiredCertsOnCRL != null && archiveCutOff != null && (revocCert = revocationData.getSigningCertificate()) != null && (expiredCertsRevocationInfo = revocCert.getCertificateTSPServiceExpiredCertsRevocationInfo()) != null) {
            notAfterRevoc = expiredCertsRevocationInfo;
        }
        boolean certHashOK = revocationData.isCertHashExtensionPresent() && revocationData.isCertHashExtensionMatch();
        return thisUpdate != null && certNotBefore.before(thisUpdate) && (certNotAfter.compareTo(notAfterRevoc) >= 0 || certHashOK);
    }

    private boolean isIssuanceBeforeControlTime(RevocationWrapper revocationData) {
        Date issuanceDate = revocationData.getProductionDate();
        return issuanceDate.before(this.controlTime);
    }
}

