/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.BasicBuildingBlockDefinition;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSignatureValidCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.pcv.checks.ValidationTimeSlidingCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.ValidationTimeSliding;
import java.util.Date;
import java.util.List;

public class PastCertificateValidation
extends Chain<XmlPCV> {
    private final TokenProxy token;
    private final DiagnosticData diagnosticData;
    private final XmlBasicBuildingBlocks bbb;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;
    private Date controlTime;

    public PastCertificateValidation(TokenProxy token, DiagnosticData diagnosticData, XmlBasicBuildingBlocks bbb, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context) {
        super(new XmlPCV());
        ((XmlPCV)this.result).setTitle(BasicBuildingBlockDefinition.PAST_CERTIFICATE_VALIDATION.getTitle());
        this.token = token;
        this.diagnosticData = diagnosticData;
        this.bbb = bbb;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected void initChain() {
        SubContext subContext;
        CertificateWrapper signingCertificate = this.token.getSigningCertificate();
        ChainItem<XmlPCV> item = this.firstItem = this.prospectiveCertificateChain();
        Date intervalNotBefore = null;
        Date intervalNotAfter = null;
        List<CertificateWrapper> certificateChain = this.token.getCertificateChain();
        for (CertificateWrapper certificate : certificateChain) {
            Date caRevocationDate;
            CertificateRevocationWrapper latestRevocation;
            if (certificate.isTrusted()) break;
            subContext = SubContext.CA_CERTIFICATE;
            if (Utils.areStringsEqual(signingCertificate.getId(), certificate.getId())) {
                subContext = SubContext.SIGNING_CERT;
            }
            if (intervalNotBefore == null || intervalNotBefore.before(certificate.getNotBefore())) {
                intervalNotBefore = certificate.getNotBefore();
            }
            if (intervalNotAfter == null || intervalNotAfter.after(certificate.getNotAfter())) {
                intervalNotAfter = certificate.getNotAfter();
            }
            if (SubContext.CA_CERTIFICATE.equals((Object)subContext) && (latestRevocation = this.diagnosticData.getLatestRevocationDataForCertificate(certificate)) != null && latestRevocation.isRevoked() && (caRevocationDate = latestRevocation.getRevocationDate()) != null && intervalNotAfter.after(caRevocationDate)) {
                intervalNotAfter = caRevocationDate;
            }
            item = item.setNextItem(this.certificateSignatureValid(certificate, subContext));
        }
        item = item.setNextItem(this.validationTimeSliding());
        if (this.controlTime != null) {
            certificateChain = this.token.getCertificateChain();
            for (CertificateWrapper certificate : certificateChain) {
                if (certificate.isTrusted()) break;
                subContext = SubContext.CA_CERTIFICATE;
                if (Utils.areStringsEqual(signingCertificate.getId(), certificate.getId())) {
                    subContext = SubContext.SIGNING_CERT;
                }
                item = item.setNextItem(this.cryptographicCheck((XmlPCV)this.result, certificate, this.controlTime, subContext));
            }
        }
    }

    private ChainItem<XmlPCV> prospectiveCertificateChain() {
        LevelConstraint constraint = this.policy.getProspectiveCertificateChainConstraint(this.context);
        return new ProspectiveCertificateChainCheck((XmlPCV)this.result, this.token, constraint);
    }

    private ChainItem<XmlPCV> certificateSignatureValid(CertificateWrapper certificate, SubContext subContext) {
        LevelConstraint constraint = this.policy.getCertificateSignatureConstraint(this.context, subContext);
        return new CertificateSignatureValidCheck<XmlPCV>((XmlPCV)this.result, certificate, constraint);
    }

    private ChainItem<XmlPCV> validationTimeSliding() {
        ValidationTimeSliding validationTimeSliding = new ValidationTimeSliding(this.token, this.currentTime, this.context, this.poe, this.policy);
        XmlVTS vts = (XmlVTS)validationTimeSliding.execute();
        this.bbb.setVTS(vts);
        this.controlTime = vts.getControlTime();
        return new ValidationTimeSlidingCheck((XmlPCV)this.result, vts, this.getFailLevelConstraint());
    }

    private ChainItem<XmlPCV> cryptographicCheck(XmlPCV result, CertificateWrapper certificate, Date validationTime, SubContext subContext) {
        CryptographicConstraint constraint = this.policy.getCertificateCryptographicConstraint(this.context, subContext);
        return new CryptographicCheck<XmlPCV>(result, certificate, validationTime, constraint);
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlPCV)this.result).setControlTime(this.controlTime);
    }
}

