/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessDefinition;
import eu.europa.esig.dss.validation.process.bbb.sav.DigestAlgorithmAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.MessageImprintDigestAlgorithmValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignatureAcceptanceValidationResultCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.TimestampComparator;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.LongTermValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.PastSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.PastTimestampValidation;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidation;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ValidationProcessForSignaturesWithArchivalData
extends Chain<XmlValidationProcessArchivalData> {
    private final XmlValidationProcessLongTermData validationProcessLongTermData;
    private final List<XmlValidationProcessTimestamps> validationProcessTimestamps;
    private final SignatureWrapper signature;
    private final DiagnosticData diagnosticData;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final ValidationPolicy policy;
    private final Date currentTime;
    private final POEExtraction poe = new POEExtraction();

    public ValidationProcessForSignaturesWithArchivalData(XmlSignature signatureAnalysis, SignatureWrapper signature, DiagnosticData diagnosticData, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentTime) {
        super(new XmlValidationProcessArchivalData());
        ((XmlValidationProcessArchivalData)this.result).setTitle(ValidationProcessDefinition.VPFSWATSP.getTitle());
        this.validationProcessLongTermData = signatureAnalysis.getValidationProcessLongTermData();
        this.validationProcessTimestamps = signatureAnalysis.getValidationProcessTimestamps();
        this.signature = signature;
        this.diagnosticData = diagnosticData;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentTime = currentTime;
    }

    @Override
    protected void initChain() {
        Context currentContext = Context.SIGNATURE;
        if (this.signature.isCounterSignature()) {
            currentContext = Context.COUNTER_SIGNATURE;
        }
        this.poe.init(this.diagnosticData, this.getCurrentTime());
        ChainItem<XmlValidationProcessArchivalData> item = this.firstItem = this.longTermValidation();
        ((XmlValidationProcessArchivalData)this.result).setProofOfExistence(this.validationProcessLongTermData.getProofOfExistence());
        if (this.isValid(this.validationProcessLongTermData)) {
            return;
        }
        this.poe.addSignaturePOE(this.signature, this.validationProcessLongTermData.getProofOfExistence());
        List<TimestampWrapper> timestampsList = this.signature.getTimestampList();
        if (Utils.isCollectionNotEmpty(timestampsList)) {
            XmlBasicBuildingBlocks bbbTsp;
            XmlConclusion latestConclusion = null;
            Collections.sort(timestampsList, new TimestampComparator());
            for (TimestampWrapper newestTimestamp : timestampsList) {
                bbbTsp = this.bbbs.get(newestTimestamp.getId());
                XmlConstraintsConclusion timestampValidation = this.getTimestampValidation(newestTimestamp);
                if (timestampValidation != null && bbbTsp != null) {
                    latestConclusion = timestampValidation.getConclusion();
                    DigestAlgorithmAcceptanceValidation dav = this.timestampDigestAlgorithmValidation(newestTimestamp);
                    XmlSAV savResult = (XmlSAV)dav.execute();
                    if (this.isValid(timestampValidation) && this.isValid(savResult)) {
                        this.poe.extractPOE(newestTimestamp);
                        continue;
                    }
                    if (!this.shouldPerformPastSignatureValidationProcess(latestConclusion)) continue;
                    PastSignatureValidation psv = new PastSignatureValidation(newestTimestamp, this.diagnosticData, bbbTsp, this.poe, this.currentTime, this.policy, Context.TIMESTAMP);
                    XmlPSV psvResult = (XmlPSV)psv.execute();
                    bbbTsp.setPSV(psvResult);
                    bbbTsp.setConclusion(psvResult.getConclusion());
                    if (!this.isValid(psvResult) || !this.isValid(savResult)) continue;
                    this.poe.extractPOE(newestTimestamp);
                    continue;
                }
                ((XmlValidationProcessArchivalData)this.result).setConclusion(latestConclusion);
                break;
            }
            Collections.reverse(timestampsList);
            for (TimestampWrapper timestamp : timestampsList) {
                bbbTsp = this.bbbs.get(timestamp.getId());
                if (bbbTsp.getPSV() == null) continue;
                item = item.setNextItem(this.pastTimestampValidation(timestamp, bbbTsp));
            }
        }
        item = item.setNextItem(this.pastSignatureValidation(currentContext));
        Date bestSignatureTime = this.poe.getLowestPOETime(this.signature.getId(), this.currentTime);
        item = item.setNextItem(this.signatureIsAcceptable(bestSignatureTime, currentContext));
    }

    private XmlProofOfExistence getCurrentTime() {
        XmlProofOfExistence xpoe = new XmlProofOfExistence();
        xpoe.setTime(this.currentTime);
        return xpoe;
    }

    private ChainItem<XmlValidationProcessArchivalData> pastTimestampValidation(TimestampWrapper timestamp, XmlBasicBuildingBlocks bbbTsp) {
        return new PastTimestampValidation((XmlValidationProcessArchivalData)this.result, bbbTsp.getPSV(), bbbTsp.getSAV(), timestamp, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationProcessArchivalData> pastSignatureValidation(Context currentContext) {
        XmlBasicBuildingBlocks bbbSig = this.bbbs.get(this.signature.getId());
        return new PastSignatureValidationCheck((XmlValidationProcessArchivalData)this.result, this.signature, this.diagnosticData, bbbSig, this.poe, this.currentTime, this.policy, currentContext, this.getFailLevelConstraint());
    }

    private XmlConstraintsConclusion getTimestampValidation(TimestampWrapper newestTimestamp) {
        for (XmlValidationProcessTimestamps tspValidation : this.validationProcessTimestamps) {
            if (!Utils.areStringsEqual(tspValidation.getId(), newestTimestamp.getId())) continue;
            return tspValidation;
        }
        return null;
    }

    private DigestAlgorithmAcceptanceValidation timestampDigestAlgorithmValidation(TimestampWrapper newestTimestamp) {
        return new MessageImprintDigestAlgorithmValidation(newestTimestamp.getProductionTime(), newestTimestamp, this.policy);
    }

    private ChainItem<XmlValidationProcessArchivalData> longTermValidation() {
        return new LongTermValidationCheck((XmlValidationProcessArchivalData)this.result, this.validationProcessLongTermData, this.getFailLevelConstraint());
    }

    private boolean isValid(XmlConstraintsConclusion xmlConstraintConclusion) {
        return xmlConstraintConclusion != null && xmlConstraintConclusion.getConclusion() != null && Indication.PASSED.equals(xmlConstraintConclusion.getConclusion().getIndication());
    }

    private boolean shouldPerformPastSignatureValidationProcess(XmlConclusion conclusion) {
        return Indication.INDETERMINATE.equals(conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication()));
    }

    private ChainItem<XmlValidationProcessArchivalData> signatureIsAcceptable(Date bestSignatureTime, Context context) {
        SignatureAcceptanceValidation sav = new SignatureAcceptanceValidation(this.diagnosticData, bestSignatureTime, this.signature, context, this.policy);
        XmlSAV savResult = (XmlSAV)sav.execute();
        return new SignatureAcceptanceValidationResultCheck<XmlValidationProcessArchivalData>((XmlValidationProcessArchivalData)this.result, savResult, this.getFailLevelConstraint());
    }
}

