/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RevocationDateAfterBestSignatureTimeCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final CertificateRevocationWrapper certificateRevocation;
    private final Date bestSignatureTime;
    private final SubContext subContext;

    public RevocationDateAfterBestSignatureTimeCheck(XmlValidationProcessLongTermData result, CertificateRevocationWrapper certificateRevocation, Date bestSignatureTime, LevelConstraint constraint, SubContext subContext) {
        super(result, constraint);
        this.certificateRevocation = certificateRevocation;
        this.bestSignatureTime = bestSignatureTime;
        this.subContext = subContext;
    }

    @Override
    protected boolean process() {
        Date revocationDate = this.certificateRevocation.getRevocationDate();
        return revocationDate != null && revocationDate.after(this.bestSignatureTime);
    }

    @Override
    protected String getAdditionalInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String bestSignatureTimeStr = this.bestSignatureTime == null ? " ? " : sdf.format(this.bestSignatureTime);
        return MessageFormat.format("Best signature time : {0}", bestSignatureTimeStr);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_IRTPTBST;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_IRTPTBST_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        if (SubContext.SIGNING_CERT.equals((Object)this.subContext)) {
            return SubIndication.REVOKED_NO_POE;
        }
        return SubIndication.REVOKED_CA_NO_POE;
    }
}

