/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessDefinition;
import eu.europa.esig.dss.validation.process.bbb.sav.SignatureAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.SignatureAcceptanceValidationResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationFreshnessCheckerResultCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.AcceptableBasicSignatureValidationCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.BestSignatureTimeNotBeforeCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationBasicBuildingBlocksCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.RevocationDateAfterBestSignatureTimeCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.SigningTimeAttributePresentCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampCoherenceOrderCheck;
import eu.europa.esig.dss.validation.process.vpfltvd.checks.TimestampDelayCheck;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationProcessForSignaturesWithLongTermValidationData
extends Chain<XmlValidationProcessLongTermData> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationProcessForSignaturesWithLongTermValidationData.class);
    private final XmlConstraintsConclusion basicSignatureValidation;
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper currentSignature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final ValidationPolicy policy;
    private final Date currentDate;

    public ValidationProcessForSignaturesWithLongTermValidationData(XmlSignature signatureAnalysis, DiagnosticData diagnosticData, SignatureWrapper currentSignature, Map<String, XmlBasicBuildingBlocks> bbbs, ValidationPolicy policy, Date currentDate) {
        super(new XmlValidationProcessLongTermData());
        ((XmlValidationProcessLongTermData)this.result).setTitle(ValidationProcessDefinition.VPFLTVD.getTitle());
        this.basicSignatureValidation = signatureAnalysis.getValidationProcessBasicSignatures();
        this.diagnosticData = diagnosticData;
        this.currentSignature = currentSignature;
        this.bbbs = bbbs;
        this.policy = policy;
        this.currentDate = currentDate;
    }

    @Override
    protected void initChain() {
        XmlConclusion xmlConclusion;
        Set<TimestampWrapper> allowedTimestamps;
        Context currentContext = Context.SIGNATURE;
        if (this.currentSignature.isCounterSignature()) {
            currentContext = Context.COUNTER_SIGNATURE;
        }
        XmlProofOfExistence bestSignatureTime = this.getCurrentTime();
        ChainItem<XmlValidationProcessLongTermData> item = this.firstItem = this.isAcceptableBasicSignatureValidation();
        Set<CertificateRevocationWrapper> certificateRevocationData = this.getLinkedCertificateRevocationData();
        if (Utils.isCollectionNotEmpty(certificateRevocationData)) {
            for (CertificateRevocationWrapper certificateRevocationWrapper : certificateRevocationData) {
                XmlBasicBuildingBlocks revocationBBB = this.bbbs.get(certificateRevocationWrapper.getId());
                if (revocationBBB != null) {
                    item = item.setNextItem(this.revocationBasicBuildingBlocksValid(revocationBBB));
                    continue;
                }
                LOG.warn("No BBB found for revocation : {}", (Object)certificateRevocationWrapper.getId());
            }
        }
        if (Utils.isCollectionNotEmpty(allowedTimestamps = this.filterValidSignatureTimestamps(this.currentSignature.getTimestampList()))) {
            for (TimestampWrapper timestampWrapper : allowedTimestamps) {
                Date productionTime = timestampWrapper.getProductionTime();
                if (!productionTime.before(bestSignatureTime.getTime())) continue;
                bestSignatureTime = this.getProofOfExistence(timestampWrapper);
            }
        }
        if (Indication.INDETERMINATE.equals((xmlConclusion = this.basicSignatureValidation.getConclusion()).getIndication()) && (SubIndication.REVOKED_NO_POE.equals(xmlConclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals(xmlConclusion.getSubIndication()))) {
            item = this.revocationDateAfterBestSignatureDateValidation(item, bestSignatureTime.getTime(), xmlConclusion.getSubIndication());
        }
        if (Indication.INDETERMINATE.equals(xmlConclusion.getIndication()) && SubIndication.OUT_OF_BOUNDS_NO_POE.equals(xmlConclusion.getSubIndication())) {
            item = item.setNextItem(this.bestSignatureTimeNotBeforeCertificateIssuance(bestSignatureTime.getTime()));
        }
        if (Indication.INDETERMINATE.equals(xmlConclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(xmlConclusion.getSubIndication())) {
            item = item.setNextItem(this.algorithmReliableAtBestSignatureTime(bestSignatureTime.getTime()));
            item = item.setNextItem(this.certificatesChainReliableAtBestSignatureTime(item, bestSignatureTime.getTime()));
        }
        if (Utils.isCollectionNotEmpty(allowedTimestamps)) {
            item = item.setNextItem(this.timestampCoherenceOrder(this.currentSignature.getTimestampList()));
            List<TimestampWrapper> signatureTimestamps = this.currentSignature.getTimestampListByType(TimestampType.SIGNATURE_TIMESTAMP);
            if (!signatureTimestamps.isEmpty() && this.policy.getTimestampDelayConstraint() != null) {
                item = item.setNextItem(this.signingTimeAttributePresent());
                item = item.setNextItem(this.timestampDelay(bestSignatureTime.getTime()));
            }
        }
        if (Indication.INDETERMINATE.equals(xmlConclusion.getIndication()) && SubIndication.TRY_LATER.equals(xmlConclusion.getSubIndication())) {
            item = item.setNextItem(this.revocationIsFresh(bestSignatureTime.getTime(), currentContext));
        }
        item = item.setNextItem(this.signatureIsAcceptable(bestSignatureTime.getTime(), currentContext));
        ((XmlValidationProcessLongTermData)this.result).setProofOfExistence(bestSignatureTime);
    }

    private Set<CertificateRevocationWrapper> getLinkedCertificateRevocationData() {
        HashSet<CertificateRevocationWrapper> result = new HashSet<CertificateRevocationWrapper>();
        this.extractRevocationDataFromCertificateChain(result, this.currentSignature.getCertificateChain());
        List<TimestampWrapper> timestampList = this.currentSignature.getTimestampList();
        for (TimestampWrapper timestamp : timestampList) {
            this.extractRevocationDataFromCertificateChain(result, timestamp.getCertificateChain());
        }
        return result;
    }

    private void extractRevocationDataFromCertificateChain(Set<CertificateRevocationWrapper> result, List<CertificateWrapper> certificateChain) {
        for (CertificateWrapper certificate : certificateChain) {
            if (certificate == null || !Utils.isCollectionNotEmpty(certificate.getCertificateRevocationData())) continue;
            result.addAll(certificate.getCertificateRevocationData());
        }
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationBasicBuildingBlocksValid(XmlBasicBuildingBlocks revocationBBB) {
        return new RevocationBasicBuildingBlocksCheck((XmlValidationProcessLongTermData)this.result, revocationBBB, this.getFailLevelConstraint());
    }

    private XmlProofOfExistence getCurrentTime() {
        XmlProofOfExistence xpoe = new XmlProofOfExistence();
        xpoe.setTime(this.currentDate);
        return xpoe;
    }

    private XmlProofOfExistence getProofOfExistence(TimestampWrapper timestampWrapper) {
        XmlProofOfExistence xpoe = new XmlProofOfExistence();
        xpoe.setTime(timestampWrapper.getProductionTime());
        xpoe.setTimestampId(timestampWrapper.getId());
        return xpoe;
    }

    private Set<TimestampWrapper> filterValidSignatureTimestamps(List<TimestampWrapper> allTimestamps) {
        HashSet<TimestampWrapper> result = new HashSet<TimestampWrapper>();
        for (TimestampWrapper timestampWrapper : allTimestamps) {
            if (!TimestampType.SIGNATURE_TIMESTAMP.equals((Object)timestampWrapper.getType())) break;
            XmlBasicBuildingBlocks bbbTST = this.bbbs.get(timestampWrapper.getId());
            if (bbbTST != null) {
                XmlCV cv = bbbTST.getCV();
                if (cv != null) {
                    XmlConclusion conclusion = cv.getConclusion();
                    if (!Indication.PASSED.equals(conclusion.getIndication())) continue;
                    result.add(timestampWrapper);
                    continue;
                }
                LOG.warn("Cryptographic validation (CV) for timestamp is required !");
                continue;
            }
            LOG.warn("Cannot find tsp validation info for tsp {}", (Object)timestampWrapper.getId());
        }
        return result;
    }

    private ChainItem<XmlValidationProcessLongTermData> isAcceptableBasicSignatureValidation() {
        return new AcceptableBasicSignatureValidationCheck((XmlValidationProcessLongTermData)this.result, this.basicSignatureValidation, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationIsFresh(Date bestSignatureTime, Context currentContext) {
        CertificateWrapper signingCertificate = this.currentSignature.getSigningCertificate();
        CertificateRevocationWrapper certificateRevocation = this.diagnosticData.getLatestRevocationDataForCertificate(signingCertificate);
        RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(certificateRevocation, bestSignatureTime, currentContext, SubContext.SIGNING_CERT, this.policy);
        return this.checkRevocationFreshnessCheckerResult((XmlRFC)rfc.execute(), currentContext, SubContext.SIGNING_CERT);
    }

    private ChainItem<XmlValidationProcessLongTermData> checkRevocationFreshnessCheckerResult(XmlRFC rfcResult, Context context, SubContext subContext) {
        LevelConstraint constraint = this.policy.getCertificateRevocationFreshnessConstraint(context, subContext);
        return new RevocationFreshnessCheckerResultCheck<XmlValidationProcessLongTermData>((XmlValidationProcessLongTermData)this.result, rfcResult, constraint){

            @Override
            protected Indication getFailedIndicationForConclusion() {
                return Indication.INDETERMINATE;
            }

            @Override
            protected SubIndication getFailedSubIndicationForConclusion() {
                return SubIndication.TRY_LATER;
            }
        };
    }

    private ChainItem<XmlValidationProcessLongTermData> revocationDateAfterBestSignatureDateValidation(ChainItem<XmlValidationProcessLongTermData> item, Date bestSignatureTime, SubIndication subIndication) {
        LevelConstraint constraint = this.policy.getRevocationTimeAgainstBestSignatureTime();
        List<CertificateWrapper> certificateChain = this.currentSignature.getCertificateChain();
        for (CertificateWrapper chainItem : certificateChain) {
            SubContext subContext = SubContext.CA_CERTIFICATE;
            if (chainItem.getId().equals(this.currentSignature.getSigningCertificate().getId())) {
                subContext = SubContext.SIGNING_CERT;
            }
            if ((!SubContext.SIGNING_CERT.equals((Object)subContext) || !SubIndication.REVOKED_NO_POE.equals(subIndication)) && (!SubContext.CA_CERTIFICATE.equals((Object)subContext) || !SubIndication.REVOKED_CA_NO_POE.equals(subIndication))) continue;
            CertificateRevocationWrapper certificateRevocation = this.diagnosticData.getLatestRevocationDataForCertificate(chainItem);
            item = item.setNextItem(new RevocationDateAfterBestSignatureTimeCheck((XmlValidationProcessLongTermData)this.result, certificateRevocation, bestSignatureTime, constraint, subContext));
        }
        return item;
    }

    private ChainItem<XmlValidationProcessLongTermData> bestSignatureTimeNotBeforeCertificateIssuance(Date bestSignatureTime) {
        CertificateWrapper signingCertificate = this.currentSignature.getSigningCertificate();
        return new BestSignatureTimeNotBeforeCertificateIssuanceCheck((XmlValidationProcessLongTermData)this.result, bestSignatureTime, signingCertificate, this.policy.getBestSignatureTimeBeforeIssuanceDateOfSigningCertificateConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampCoherenceOrder(List<TimestampWrapper> timestamps) {
        return new TimestampCoherenceOrderCheck((XmlValidationProcessLongTermData)this.result, timestamps, this.policy.getTimestampCoherenceConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> signingTimeAttributePresent() {
        return new SigningTimeAttributePresentCheck((XmlValidationProcessLongTermData)this.result, this.currentSignature, this.policy.getSigningTimeConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> timestampDelay(Date bestSignatureTime) {
        return new TimestampDelayCheck((XmlValidationProcessLongTermData)this.result, this.currentSignature, bestSignatureTime, this.policy.getTimestampDelayConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> algorithmReliableAtBestSignatureTime(Date bestSignatureTime) {
        return new CryptographicCheck<XmlValidationProcessLongTermData>((XmlValidationProcessLongTermData)this.result, this.currentSignature, bestSignatureTime, this.policy.getSignatureCryptographicConstraint(Context.SIGNATURE));
    }

    private ChainItem<XmlValidationProcessLongTermData> signatureIsAcceptable(Date bestSignatureTime, Context context) {
        SignatureAcceptanceValidation sav = new SignatureAcceptanceValidation(this.diagnosticData, bestSignatureTime, this.currentSignature, context, this.policy);
        return new SignatureAcceptanceValidationResultCheck<XmlValidationProcessLongTermData>((XmlValidationProcessLongTermData)this.result, (XmlSAV)sav.execute(), this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationProcessLongTermData> certificatesChainReliableAtBestSignatureTime(ChainItem<XmlValidationProcessLongTermData> item, Date bestSignatureTime) {
        List<CertificateWrapper> certificateChain = this.currentSignature.getCertificateChain();
        for (CertificateWrapper certificate : certificateChain) {
            CryptographicCheck<XmlValidationProcessLongTermData> cryptoCheck = null;
            cryptoCheck = certificate.getId().equals(this.currentSignature.getSigningCertificate().getId()) ? new CryptographicCheck<XmlValidationProcessLongTermData>((XmlValidationProcessLongTermData)this.result, certificate, bestSignatureTime, this.policy.getCertificateCryptographicConstraint(Context.SIGNATURE, SubContext.SIGNING_CERT)) : new CryptographicCheck<XmlValidationProcessLongTermData>((XmlValidationProcessLongTermData)this.result, certificate, bestSignatureTime, this.policy.getCertificateCryptographicConstraint(Context.SIGNATURE, SubContext.CA_CERTIFICATE));
            item = item.setNextItem(cryptoCheck);
        }
        return item;
    }
}

