/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfbs.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlISC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicSignatures;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SignatureBasicBuildingBlocksCheck
extends ChainItem<XmlValidationProcessBasicSignatures> {
    private final DiagnosticData diagnosticData;
    private final XmlBasicBuildingBlocks signatureBBB;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private Indication indication;
    private SubIndication subIndication;
    private List<XmlName> errors = new ArrayList<XmlName>();

    public SignatureBasicBuildingBlocksCheck(XmlValidationProcessBasicSignatures result, DiagnosticData diagnosticData, XmlBasicBuildingBlocks signatureBBB, Map<String, XmlBasicBuildingBlocks> bbbs, LevelConstraint constraint) {
        super(result, constraint, signatureBBB.getId());
        this.diagnosticData = diagnosticData;
        this.signatureBBB = signatureBBB;
        this.bbbs = bbbs;
        result.setProofOfExistence(this.getCurrentTime());
    }

    private XmlProofOfExistence getCurrentTime() {
        XmlProofOfExistence proofOfExistence = new XmlProofOfExistence();
        proofOfExistence.setTime(this.diagnosticData.getValidationDate());
        return proofOfExistence;
    }

    @Override
    protected boolean process() {
        XmlCV cv;
        XmlConclusion cvConclusion;
        XmlConclusion vciConclusion;
        XmlConclusion fcConclusion;
        XmlFC fc = this.signatureBBB.getFC();
        if (fc != null && !Indication.PASSED.equals((fcConclusion = fc.getConclusion()).getIndication())) {
            this.indication = Indication.FAILED;
            this.subIndication = SubIndication.FORMAT_FAILURE;
            this.errors.addAll(fcConclusion.getErrors());
            return false;
        }
        XmlISC isc = this.signatureBBB.getISC();
        XmlConclusion iscConclusion = isc.getConclusion();
        if (Indication.INDETERMINATE.equals(iscConclusion.getIndication()) && SubIndication.NO_SIGNING_CERTIFICATE_FOUND.equals(iscConclusion.getSubIndication())) {
            this.indication = iscConclusion.getIndication();
            this.subIndication = iscConclusion.getSubIndication();
            this.errors.addAll(iscConclusion.getErrors());
            return false;
        }
        XmlVCI vci = this.signatureBBB.getVCI();
        if (vci != null && Indication.INDETERMINATE.equals((vciConclusion = vci.getConclusion()).getIndication())) {
            this.indication = vciConclusion.getIndication();
            this.subIndication = vciConclusion.getSubIndication();
            this.errors.addAll(vciConclusion.getErrors());
            return false;
        }
        XmlXCV xcv = this.signatureBBB.getXCV();
        XmlConclusion x509ValidationStatus = null;
        if (xcv != null) {
            Date tspProductionTime;
            boolean failed;
            List<TimestampWrapper> contentTimestamps;
            SignatureWrapper currentSignature;
            x509ValidationStatus = xcv.getConclusion();
            XmlConclusion xcvConclusion = x509ValidationStatus;
            if (Indication.INDETERMINATE.equals(xcvConclusion.getIndication()) && SubIndication.REVOKED_NO_POE.equals(xcvConclusion.getSubIndication())) {
                currentSignature = this.diagnosticData.getSignatureById(this.signatureBBB.getId());
                contentTimestamps = currentSignature.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP);
                if (Utils.isCollectionNotEmpty(contentTimestamps)) {
                    failed = false;
                    Date revocationDate = this.getRevocationDateForSigningCertificate(currentSignature);
                    for (TimestampWrapper timestamp : contentTimestamps) {
                        if (!this.isValidTimestamp(timestamp) || !(tspProductionTime = timestamp.getProductionTime()).after(revocationDate)) continue;
                        failed = true;
                        break;
                    }
                    if (failed) {
                        x509ValidationStatus.setIndication(Indication.FAILED);
                        x509ValidationStatus.setSubIndication(SubIndication.REVOKED);
                        this.errors.addAll(xcvConclusion.getErrors());
                    }
                }
                x509ValidationStatus.setIndication(Indication.INDETERMINATE);
                x509ValidationStatus.setSubIndication(SubIndication.REVOKED_NO_POE);
                this.errors.addAll(xcvConclusion.getErrors());
            } else if (Indication.INDETERMINATE.equals(xcvConclusion.getIndication()) && SubIndication.OUT_OF_BOUNDS_NO_POE.equals(xcvConclusion.getSubIndication())) {
                currentSignature = this.diagnosticData.getSignatureById(this.signatureBBB.getId());
                contentTimestamps = currentSignature.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP);
                if (Utils.isCollectionNotEmpty(contentTimestamps)) {
                    failed = false;
                    Date expirationDate = this.getExpirationDateForSigningCertificate(currentSignature);
                    for (TimestampWrapper timestamp : contentTimestamps) {
                        if (!this.isValidTimestamp(timestamp) || !(tspProductionTime = timestamp.getProductionTime()).after(expirationDate)) continue;
                        failed = true;
                        break;
                    }
                    if (failed) {
                        x509ValidationStatus.setIndication(Indication.INDETERMINATE);
                        x509ValidationStatus.setSubIndication(SubIndication.EXPIRED);
                        this.errors.addAll(xcvConclusion.getErrors());
                    }
                }
                x509ValidationStatus.setIndication(Indication.INDETERMINATE);
                x509ValidationStatus.setSubIndication(SubIndication.OUT_OF_BOUNDS_NO_POE);
                this.errors.addAll(xcvConclusion.getErrors());
            } else if (!Indication.PASSED.equals(xcvConclusion.getIndication())) {
                this.indication = xcvConclusion.getIndication();
                this.subIndication = xcvConclusion.getSubIndication();
                this.errors.addAll(xcvConclusion.getErrors());
                return false;
            }
        }
        if (Indication.PASSED.equals((cvConclusion = (cv = this.signatureBBB.getCV()).getConclusion()).getIndication())) {
            if (x509ValidationStatus != null && !Indication.PASSED.equals(x509ValidationStatus.getIndication())) {
                this.indication = x509ValidationStatus.getIndication();
                this.subIndication = x509ValidationStatus.getSubIndication();
                return false;
            }
        } else {
            this.indication = cvConclusion.getIndication();
            this.subIndication = cvConclusion.getSubIndication();
            this.errors.addAll(cvConclusion.getErrors());
            return false;
        }
        XmlSAV sav = this.signatureBBB.getSAV();
        XmlConclusion savConclusion = sav.getConclusion();
        if (Indication.INDETERMINATE.equals(savConclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(savConclusion.getSubIndication())) {
            SignatureWrapper currentSignature = this.diagnosticData.getSignatureById(this.signatureBBB.getId());
            List<TimestampWrapper> contentTimestamps = currentSignature.getTimestampListByType(TimestampType.CONTENT_TIMESTAMP);
            if (Utils.isCollectionNotEmpty(contentTimestamps)) {
                boolean failed = false;
                for (TimestampWrapper timestamp : contentTimestamps) {
                    if (!this.isValidTimestamp(timestamp)) continue;
                    failed = true;
                    break;
                }
                if (failed) {
                    this.indication = Indication.INDETERMINATE;
                    this.subIndication = SubIndication.CRYPTO_CONSTRAINTS_FAILURE;
                    return false;
                }
            }
            this.indication = Indication.INDETERMINATE;
            this.subIndication = SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE;
            this.errors.addAll(savConclusion.getErrors());
            return false;
        }
        if (!Indication.PASSED.equals(savConclusion.getIndication())) {
            this.indication = savConclusion.getIndication();
            this.subIndication = savConclusion.getSubIndication();
            this.errors.addAll(savConclusion.getErrors());
            return false;
        }
        return true;
    }

    private boolean isValidTimestamp(TimestampWrapper timestamp) {
        XmlBasicBuildingBlocks timestampBasicBuildingBlocks = this.bbbs.get(timestamp.getId());
        return timestampBasicBuildingBlocks != null && timestampBasicBuildingBlocks.getConclusion() != null && Indication.PASSED.equals(timestampBasicBuildingBlocks.getConclusion().getIndication());
    }

    private Date getRevocationDateForSigningCertificate(SignatureWrapper currentSignature) {
        CertificateWrapper signingCertificate = currentSignature.getSigningCertificate();
        if (signingCertificate != null && Utils.isCollectionNotEmpty(signingCertificate.getCertificateRevocationData())) {
            return this.diagnosticData.getLatestRevocationDataForCertificate(signingCertificate).getRevocationDate();
        }
        return null;
    }

    private Date getExpirationDateForSigningCertificate(SignatureWrapper currentSignature) {
        CertificateWrapper signingCertificate = currentSignature.getSigningCertificate();
        if (signingCertificate != null) {
            return signingCertificate.getNotAfter();
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_ROBVPIIC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_ROBVPIIC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.indication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.errors;
    }
}

