/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.certificate.QSCDStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.Type;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueServiceFilter
implements TrustedServiceFilter {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueServiceFilter.class);
    private final CertificateWrapper endEntityCert;

    public UniqueServiceFilter(CertificateWrapper endEntityCert) {
        this.endEntityCert = endEntityCert;
    }

    @Override
    public List<TrustedServiceWrapper> filter(List<TrustedServiceWrapper> trustServices) {
        TrustedServiceWrapper selectedTrustedService = null;
        if (Utils.collectionSize(trustServices) == 1) {
            selectedTrustedService = trustServices.get(0);
        } else if (Utils.isCollectionNotEmpty(trustServices)) {
            LOG.info("More than one selected trust services");
            EnumMap<CertificateQualification, String> qualificationResults = new EnumMap<CertificateQualification, String>(CertificateQualification.class);
            for (TrustedServiceWrapper trustService : trustServices) {
                QSCDStrategy qscdStrategy;
                QSCDStatus qscdStatus;
                TypeStrategy typeStrategy;
                Type type;
                QualificationStrategy qcStrategy = QualificationStrategyFactory.createQualificationFromCertAndTL(this.endEntityCert, trustService);
                QualifiedStatus qualifiedStatus = qcStrategy.getQualifiedStatus();
                CertificateQualification certQualification = CertQualificationMatrix.getCertQualification(qualifiedStatus, type = (typeStrategy = TypeStrategyFactory.createTypeFromCertAndTL(this.endEntityCert, trustService, qualifiedStatus)).getType(), qscdStatus = (qscdStrategy = QSCDStrategyFactory.createQSCDFromCertAndTL(this.endEntityCert, trustService, qualifiedStatus)).getQSCDStatus());
                if (qualificationResults.containsKey((Object)certQualification)) continue;
                qualificationResults.put(certQualification, trustService.getServiceName());
            }
            if (qualificationResults.size() > 1) {
                LOG.warn("Unable to select the trust service ! Several possible conclusions {}", (Object)qualificationResults);
            } else {
                LOG.info("All trust services conclude with the same result");
                selectedTrustedService = trustServices.get(0);
            }
        }
        if (selectedTrustedService != null) {
            return Collections.singletonList(selectedTrustedService);
        }
        return Collections.emptyList();
    }
}

