/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.ValueConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLVersionCheck
extends ChainItem<XmlTLAnalysis> {
    private static final Logger LOG = LoggerFactory.getLogger(TLVersionCheck.class);
    private final XmlTrustedList currentTL;
    private final Date currentTime;
    private final ValueConstraint constraint;

    public TLVersionCheck(XmlTLAnalysis result, XmlTrustedList currentTl, Date currentTime, ValueConstraint constraint) {
        super(result, constraint);
        this.currentTL = currentTl;
        this.currentTime = currentTime;
        this.constraint = constraint;
    }

    @Override
    protected boolean process() {
        if (!EIDASUtils.isPostGracePeriod(this.currentTime)) {
            return true;
        }
        String expectedVersionString = this.constraint.getValue();
        int version = 5;
        try {
            version = Integer.parseInt(expectedVersionString);
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to parse TLVersion constraint : '{}'", (Object)expectedVersionString);
        }
        Integer tlVersion = this.currentTL.getVersion();
        return tlVersion != null && tlVersion == version;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_TL_VERSION;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QUAL_TL_VERSION_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

