/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.Date;

public class TLNotExpiredCheck
extends ChainItem<XmlTLAnalysis> {
    private final XmlTrustedList currentTL;
    private final Date currentTime;

    public TLNotExpiredCheck(XmlTLAnalysis result, XmlTrustedList currentTL, Date currentTime, LevelConstraint constraint) {
        super(result, constraint);
        this.currentTL = currentTL;
        this.currentTime = currentTime;
    }

    @Override
    protected boolean process() {
        Date nextUpdate = this.currentTL.getNextUpdate();
        return nextUpdate != null && nextUpdate.after(this.currentTime);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_TL_EXP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QUAL_TL_EXP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

