/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.signature;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusionWithProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessDefinition;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationAtTimeBlock;
import eu.europa.esig.dss.validation.process.qualification.signature.SigQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AdESAcceptableCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.CertificatePathTrustedCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.ForeSignatureAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.QSCDCertificateAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.QualifiedCertificateAtCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.QualifiedCertificateAtSigningTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SignatureQualificationBlock
extends Chain<XmlValidationSignatureQualification> {
    private final XmlConclusion etsi319102Conclusion;
    private final Date bestSignatureTime;
    private final CertificateWrapper signingCertificate;
    private final List<XmlTLAnalysis> tlAnalysis;
    private final String lotlCountryCode;
    private CertificateQualification qualificationAtSigningTime;

    public SignatureQualificationBlock(String signatureId, XmlConstraintsConclusionWithProofOfExistence etsi319102validation, CertificateWrapper signingCertificate, List<XmlTLAnalysis> tlAnalysis, String lotlCountryCode) {
        super(new XmlValidationSignatureQualification());
        ((XmlValidationSignatureQualification)this.result).setTitle(ValidationProcessDefinition.SIG_QUALIFICATION.getTitle());
        ((XmlValidationSignatureQualification)this.result).setId(signatureId);
        this.etsi319102Conclusion = etsi319102validation.getConclusion();
        this.bestSignatureTime = etsi319102validation.getProofOfExistence().getTime();
        this.signingCertificate = signingCertificate;
        this.tlAnalysis = tlAnalysis;
        this.lotlCountryCode = lotlCountryCode;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlValidationSignatureQualification> item = this.firstItem = this.isAdES(this.etsi319102Conclusion);
        item = item.setNextItem(this.certificatePathTrusted(this.signingCertificate));
        if (this.signingCertificate != null && this.signingCertificate.hasTrustedServices()) {
            XmlTLAnalysis lotlAnalysis = this.getTlAnalysis(this.lotlCountryCode);
            if (lotlAnalysis != null) {
                item = item.setNextItem(this.isAcceptableTL(lotlAnalysis));
            }
            HashSet<String> acceptableCountries = new HashSet<String>();
            List<TrustedServiceWrapper> originalTSPs = this.signingCertificate.getTrustedServices();
            Set<String> countryCodes = this.getCountryCodes(originalTSPs);
            for (String countryCode : countryCodes) {
                XmlTLAnalysis currentTL = this.getTlAnalysis(countryCode);
                if (currentTL == null) continue;
                AcceptableTrustedListCheck<XmlValidationSignatureQualification> acceptableTL = this.isAcceptableTL(currentTL);
                item = item.setNextItem(acceptableTL);
                if (!acceptableTL.process()) continue;
                acceptableCountries.add(countryCode);
            }
            TrustedServiceFilter filter = TrustedServicesFilterFactory.createFilterByCountries(acceptableCountries);
            List<TrustedServiceWrapper> acceptableServices = filter.filter(originalTSPs);
            filter = TrustedServicesFilterFactory.createFilterByCaQc();
            List<TrustedServiceWrapper> caqcServices = filter.filter(acceptableServices);
            CertQualificationAtTimeBlock certQualAtIssuanceBlock = new CertQualificationAtTimeBlock(ValidationTime.CERTIFICATE_ISSUANCE_TIME, this.signingCertificate, caqcServices);
            XmlValidationCertificateQualification certQualAtIssuanceResult = (XmlValidationCertificateQualification)certQualAtIssuanceBlock.execute();
            ((XmlValidationSignatureQualification)this.result).getValidationCertificateQualification().add(certQualAtIssuanceResult);
            CertificateQualification qualificationAtIssuance = certQualAtIssuanceResult.getCertificateQualification();
            CertQualificationAtTimeBlock certQualAtSigningTimeBlock = new CertQualificationAtTimeBlock(ValidationTime.BEST_SIGNATURE_TIME, this.bestSignatureTime, this.signingCertificate, caqcServices);
            XmlValidationCertificateQualification certQualAtSigningTimeResult = (XmlValidationCertificateQualification)certQualAtSigningTimeBlock.execute();
            ((XmlValidationSignatureQualification)this.result).getValidationCertificateQualification().add(certQualAtSigningTimeResult);
            this.qualificationAtSigningTime = certQualAtSigningTimeResult.getCertificateQualification();
            item = item.setNextItem(this.qualifiedCertificateAtSigningTime(this.qualificationAtSigningTime));
            item = item.setNextItem(this.foreSignatureAtSigningTime(this.qualificationAtSigningTime));
            item = item.setNextItem(this.qualifiedCertificateAtIssuance(qualificationAtIssuance));
            item = item.setNextItem(this.qscdAtSigningTime(this.qualificationAtSigningTime));
        }
    }

    private XmlTLAnalysis getTlAnalysis(String countryCode) {
        for (XmlTLAnalysis xmlTLAnalysis : this.tlAnalysis) {
            if (!Utils.areStringsEqual(countryCode, xmlTLAnalysis.getCountryCode())) continue;
            return xmlTLAnalysis;
        }
        return null;
    }

    private Set<String> getCountryCodes(List<TrustedServiceWrapper> trustServices) {
        HashSet<String> countryCodes = new HashSet<String>();
        for (TrustedServiceWrapper trustedServiceWrapper : trustServices) {
            countryCodes.add(trustedServiceWrapper.getCountryCode());
        }
        return countryCodes;
    }

    @Override
    protected void addAdditionalInfo() {
        this.collectErrorsWarnsInfos();
        this.setIndication();
        this.determineFinalQualification();
    }

    private void determineFinalQualification() {
        SignatureQualification sigQualif = SignatureQualification.NA;
        if (this.etsi319102Conclusion != null && this.qualificationAtSigningTime != null) {
            sigQualif = SigQualificationMatrix.getSignatureQualification(this.etsi319102Conclusion.getIndication(), this.qualificationAtSigningTime);
        }
        ((XmlValidationSignatureQualification)this.result).setSignatureQualification(sigQualif);
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlValidationSignatureQualification)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty(conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty(conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private ChainItem<XmlValidationSignatureQualification> certificatePathTrusted(CertificateWrapper signingCertificate) {
        return new CertificatePathTrustedCheck((XmlValidationSignatureQualification)this.result, signingCertificate, this.getFailLevelConstraint());
    }

    private AcceptableTrustedListCheck<XmlValidationSignatureQualification> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck<XmlValidationSignatureQualification>((XmlValidationSignatureQualification)this.result, xmlTLAnalysis, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> isAdES(XmlConclusion etsi319102Conclusion) {
        return new AdESAcceptableCheck((XmlValidationSignatureQualification)this.result, etsi319102Conclusion, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qualifiedCertificateAtSigningTime(CertificateQualification qualificationAtSigningTime) {
        return new QualifiedCertificateAtSigningTimeCheck((XmlValidationSignatureQualification)this.result, qualificationAtSigningTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> foreSignatureAtSigningTime(CertificateQualification qualificationAtSigningTime) {
        return new ForeSignatureAtSigningTimeCheck((XmlValidationSignatureQualification)this.result, qualificationAtSigningTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qualifiedCertificateAtIssuance(CertificateQualification qualificationAtIssuance) {
        return new QualifiedCertificateAtCertificateIssuanceCheck((XmlValidationSignatureQualification)this.result, qualificationAtIssuance, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationSignatureQualification> qscdAtSigningTime(CertificateQualification qualificationAtSigningTime) {
        return new QSCDCertificateAtSigningTimeCheck((XmlValidationSignatureQualification)this.result, qualificationAtSigningTime, this.getWarnLevelConstraint());
    }
}

