/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessDefinition;
import eu.europa.esig.dss.validation.process.qualification.certificate.AcceptableBuildingBlockConclusionCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationAtTimeBlock;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertificateQualificationBlock
extends Chain<XmlCertificate> {
    private final XmlConclusion buildingBlocksConclusion;
    private final Date validationTime;
    private final CertificateWrapper signingCertificate;
    private final List<XmlTLAnalysis> tlAnalysis;
    private final String lotlCountryCode;

    public CertificateQualificationBlock(XmlConclusion buildingBlocksConclusion, Date validationTime, CertificateWrapper signingCertificate, List<XmlTLAnalysis> tlAnalysis, String lotlCountryCode) {
        super(new XmlCertificate());
        ((XmlCertificate)this.result).setTitle(ValidationProcessDefinition.CERT_QUALIFICATION.getTitle());
        this.buildingBlocksConclusion = buildingBlocksConclusion;
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.tlAnalysis = tlAnalysis;
        this.lotlCountryCode = lotlCountryCode;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCertificate> item = this.firstItem = this.isAcceptableBuildingBlockConclusion(this.buildingBlocksConclusion);
        if (this.signingCertificate != null && this.signingCertificate.hasTrustedServices()) {
            XmlTLAnalysis lotlAnalysis = this.getTlAnalysis(this.lotlCountryCode);
            if (lotlAnalysis != null) {
                item = item.setNextItem(this.isAcceptableTL(lotlAnalysis));
            }
            HashSet<String> acceptableCountries = new HashSet<String>();
            List<TrustedServiceWrapper> originalTSPs = this.signingCertificate.getTrustedServices();
            Set<String> countryCodes = this.getCountryCodes(originalTSPs);
            for (String countryCode : countryCodes) {
                XmlTLAnalysis currentTL = this.getTlAnalysis(countryCode);
                if (currentTL == null) continue;
                AcceptableTrustedListCheck<XmlCertificate> acceptableTL = this.isAcceptableTL(currentTL);
                item = item.setNextItem(acceptableTL);
                if (!acceptableTL.process()) continue;
                acceptableCountries.add(countryCode);
            }
            TrustedServiceFilter filter = TrustedServicesFilterFactory.createFilterByCountries(acceptableCountries);
            List<TrustedServiceWrapper> acceptableServices = filter.filter(originalTSPs);
            filter = TrustedServicesFilterFactory.createFilterByCaQc();
            List<TrustedServiceWrapper> caqcServices = filter.filter(acceptableServices);
            CertQualificationAtTimeBlock certQualAtIssuanceBlock = new CertQualificationAtTimeBlock(ValidationTime.CERTIFICATE_ISSUANCE_TIME, this.signingCertificate, caqcServices);
            ((XmlCertificate)this.result).getValidationCertificateQualification().add((XmlValidationCertificateQualification)certQualAtIssuanceBlock.execute());
            CertQualificationAtTimeBlock certQualAtSigningTimeBlock = new CertQualificationAtTimeBlock(ValidationTime.VALIDATION_TIME, this.validationTime, this.signingCertificate, caqcServices);
            ((XmlCertificate)this.result).getValidationCertificateQualification().add((XmlValidationCertificateQualification)certQualAtSigningTimeBlock.execute());
        }
    }

    private XmlTLAnalysis getTlAnalysis(String countryCode) {
        for (XmlTLAnalysis xmlTLAnalysis : this.tlAnalysis) {
            if (!Utils.areStringsEqual(countryCode, xmlTLAnalysis.getCountryCode())) continue;
            return xmlTLAnalysis;
        }
        return null;
    }

    private Set<String> getCountryCodes(List<TrustedServiceWrapper> caqcServices) {
        HashSet<String> countryCodes = new HashSet<String>();
        for (TrustedServiceWrapper trustedServiceWrapper : caqcServices) {
            countryCodes.add(trustedServiceWrapper.getCountryCode());
        }
        return countryCodes;
    }

    @Override
    protected void addAdditionalInfo() {
        this.collectErrorsWarnsInfos();
        this.setIndication();
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlCertificate)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty(conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty(conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private AcceptableTrustedListCheck<XmlCertificate> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck<XmlCertificate>((XmlCertificate)this.result, xmlTLAnalysis, this.getFailLevelConstraint());
    }

    private ChainItem<XmlCertificate> isAcceptableBuildingBlockConclusion(XmlConclusion buildingBlocksConclusion) {
        return new AcceptableBuildingBlockConclusionCheck((XmlCertificate)this.result, buildingBlocksConclusion, this.getWarnLevelConstraint());
    }
}

