/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessDefinition;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.certificate.QSCDStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;
import eu.europa.esig.dss.validation.process.qualification.certificate.Type;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CaQcCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateIssuedByConsistentTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateTypeCoverageCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ForEsigCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.GrantedStatusCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsAbleToSelectOneTrustService;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QSCDCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QualifiedCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ServiceConsistencyCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustedCertificateMatchTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CertQualificationAtTimeBlock
extends Chain<XmlValidationCertificateQualification> {
    private final ValidationTime validationTime;
    private final Date date;
    private final CertificateWrapper signingCertificate;
    private final List<TrustedServiceWrapper> caqcServices;
    private CertificateQualification certificateQualification = CertificateQualification.NA;

    public CertQualificationAtTimeBlock(ValidationTime validationTime, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices) {
        this(validationTime, null, signingCertificate, caqcServices);
    }

    public CertQualificationAtTimeBlock(ValidationTime validationTime, Date date, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> caqcServices) {
        super(new XmlValidationCertificateQualification());
        ((XmlValidationCertificateQualification)this.result).setTitle(ValidationProcessDefinition.CERT_QUALIFICATION.getTitle() + " @ " + (Object)((Object)validationTime));
        ((XmlValidationCertificateQualification)this.result).setId(signingCertificate.getId());
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.caqcServices = new ArrayList<TrustedServiceWrapper>(caqcServices);
        switch (validationTime) {
            case CERTIFICATE_ISSUANCE_TIME: {
                this.date = signingCertificate.getNotBefore();
                break;
            }
            case VALIDATION_TIME: 
            case BEST_SIGNATURE_TIME: {
                this.date = date;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown qualification time : " + (Object)((Object)validationTime));
            }
        }
    }

    @Override
    protected void initChain() {
        ChainItem<XmlValidationCertificateQualification> item;
        TrustedServiceFilter filterByDate = TrustedServicesFilterFactory.createFilterByDate(this.date);
        List<TrustedServiceWrapper> caqcServicesAtTime = filterByDate.filter(this.caqcServices);
        this.firstItem = item = this.hasCaQc(caqcServicesAtTime);
        TrustedServiceFilter filterByGranted = TrustedServicesFilterFactory.createFilterByGranted();
        caqcServicesAtTime = filterByGranted.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasGrantedStatus(caqcServicesAtTime));
        for (TrustedServiceWrapper trustedService : caqcServicesAtTime) {
            item = item.setNextItem(this.serviceConsistency(trustedService));
        }
        TrustedServiceFilter filterConsistent = TrustedServicesFilterFactory.createConsistentServiceFilter();
        caqcServicesAtTime = filterConsistent.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasConsistentTrustService(caqcServicesAtTime));
        TrustedServiceFilter filterByCertificateType = TrustedServicesFilterFactory.createFilterByCertificateType(this.signingCertificate);
        caqcServicesAtTime = filterByCertificateType.filter(caqcServicesAtTime);
        item = item.setNextItem(this.hasCertificateTypeCoverage(caqcServicesAtTime));
        if (Utils.collectionSize(caqcServicesAtTime) > 1) {
            TrustedServiceFilter filterUnique = TrustedServicesFilterFactory.createUniqueServiceFilter(this.signingCertificate);
            caqcServicesAtTime = filterUnique.filter(caqcServicesAtTime);
            item = item.setNextItem(this.isAbleToSelectOneTrustService(caqcServicesAtTime));
        }
        TrustedServiceWrapper selectedTrustService = !caqcServicesAtTime.isEmpty() ? caqcServicesAtTime.get(0) : null;
        item = item.setNextItem(this.isTrustedCertificateMatchTrustService(selectedTrustService));
        QualificationStrategy qcStrategy = QualificationStrategyFactory.createQualificationFromCertAndTL(this.signingCertificate, selectedTrustService);
        QualifiedStatus qualifiedStatus = qcStrategy.getQualifiedStatus();
        item = item.setNextItem(this.isQualified(qualifiedStatus));
        TypeStrategy typeStrategy = TypeStrategyFactory.createTypeFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        Type type = typeStrategy.getType();
        item = item.setNextItem(this.isForEsig(type));
        QSCDStrategy qscdStrategy = QSCDStrategyFactory.createQSCDFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        QSCDStatus qscdStatus = qscdStrategy.getQSCDStatus();
        item = item.setNextItem(this.isQscd(qscdStatus));
        this.certificateQualification = CertQualificationMatrix.getCertQualification(qualifiedStatus, type, qscdStatus);
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlValidationCertificateQualification)this.result).setCertificateQualification(this.certificateQualification);
        ((XmlValidationCertificateQualification)this.result).setValidationTime(this.validationTime);
        ((XmlValidationCertificateQualification)this.result).setDateTime(this.date);
    }

    private ChainItem<XmlValidationCertificateQualification> hasCaQc(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CaQcCheck((XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasGrantedStatus(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new GrantedStatusCheck((XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasCertificateTypeCoverage(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CertificateTypeCoverageCheck((XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasConsistentTrustService(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new CertificateIssuedByConsistentTrustServiceCheck((XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isAbleToSelectOneTrustService(List<TrustedServiceWrapper> caqcServicesAtTime) {
        return new IsAbleToSelectOneTrustService((XmlValidationCertificateQualification)this.result, caqcServicesAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> serviceConsistency(TrustedServiceWrapper selectedTrustService) {
        return new ServiceConsistencyCheck((XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isTrustedCertificateMatchTrustService(TrustedServiceWrapper selectedTrustService) {
        return new TrustedCertificateMatchTrustServiceCheck((XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isQualified(QualifiedStatus qualifiedStatus) {
        return new QualifiedCheck((XmlValidationCertificateQualification)this.result, qualifiedStatus, this.validationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isForEsig(Type type) {
        return new ForEsigCheck((XmlValidationCertificateQualification)this.result, type, this.validationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isQscd(QSCDStatus qscdStatus) {
        return new QSCDCheck((XmlValidationCertificateQualification)this.result, qscdStatus, this.validationTime, this.getWarnLevelConstraint());
    }
}

