/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KeyUsageCheck
extends AbstractMultiValuesCheckItem<XmlSubXCV> {
    private final CertificateWrapper certificate;

    public KeyUsageCheck(XmlSubXCV result, CertificateWrapper certificate, MultiValuesConstraint constraint) {
        super(result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        List<KeyUsageBit> keyUsages = this.certificate.getKeyUsages();
        List<String> kubStrings = this.toString(keyUsages);
        return this.processValuesCheck(kubStrings);
    }

    private List<String> toString(List<KeyUsageBit> keyUsages) {
        ArrayList<String> result = new ArrayList<String>();
        for (KeyUsageBit keyUsageBit : keyUsages) {
            result.add(keyUsageBit.getValue());
        }
        return result;
    }

    @Override
    protected String getAdditionalInfo() {
        return MessageFormat.format("Key usage : {0}", Arrays.toString(this.certificate.getKeyUsages().toArray()));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ISCGKU;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ISCGKU_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

