/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CertificateOnHoldCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateRevocationWrapper certificateRevocation;
    private final Date currentTime;

    public CertificateOnHoldCheck(XmlSubXCV result, CertificateRevocationWrapper certificateRevocation, Date currentTime, LevelConstraint constraint) {
        super(result, constraint);
        this.certificateRevocation = certificateRevocation;
        this.currentTime = currentTime;
    }

    @Override
    protected boolean process() {
        boolean isOnHold;
        boolean bl = isOnHold = this.certificateRevocation != null && !this.certificateRevocation.isStatus() && RevocationReason.CERTIFICATE_HOLD.equals(this.certificateRevocation.getReason());
        if (isOnHold) {
            isOnHold = this.certificateRevocation.getRevocationDate() != null && this.currentTime.after(this.certificateRevocation.getRevocationDate());
        }
        return !isOnHold;
    }

    @Override
    protected String getAdditionalInfo() {
        if (this.certificateRevocation != null && this.certificateRevocation.getRevocationDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String revocationDateStr = sdf.format(this.certificateRevocation.getRevocationDate());
            Object[] params = new Object[]{this.certificateRevocation.getReason(), revocationDateStr};
            return MessageFormat.format("Revocation reason : {0} (date : {1})", params);
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ISCOH;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ISCOH_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }
}

