/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class AbstractRevocationFreshCheck
extends ChainItem<XmlRFC> {
    protected final RevocationWrapper revocationData;
    private final Date validationDate;

    protected AbstractRevocationFreshCheck(XmlRFC result, RevocationWrapper revocationData, Date validationDate, LevelConstraint constraint) {
        super(result, constraint);
        this.revocationData = revocationData;
        this.validationDate = validationDate;
    }

    protected boolean isProductionDateNotBeforeValidationTime() {
        long maxFreshness = this.getMaxFreshness();
        long validationDateTime = this.validationDate.getTime();
        long limit = validationDateTime - maxFreshness;
        Date productionDate = this.revocationData.getProductionDate();
        return productionDate != null && productionDate.after(new Date(limit));
    }

    protected abstract long getMaxFreshness();

    @Override
    protected String getAdditionalInfo() {
        String productionTimeString = "not defined";
        String nextUpdateString = "not defined";
        if (this.revocationData != null) {
            if (this.revocationData.getProductionDate() != null) {
                productionTimeString = this.convertDate(this.revocationData.getProductionDate());
            }
            if (this.revocationData.getNextUpdate() != null) {
                nextUpdateString = this.convertDate(this.revocationData.getNextUpdate());
            }
        }
        Object[] params = new Object[]{this.convertDate(this.validationDate), productionTimeString, nextUpdateString};
        return MessageFormat.format("Validation time : {0}; Production time : {1}; NextUpdate time : {2}", params);
    }

    private String convertDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_RFC_IRIF;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_RFC_IRIF_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }
}

