/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.vci;

import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SignaturePolicyType;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.validation.process.BasicBuildingBlockDefinition;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.vci.checks.SignaturePolicyHashValidCheck;
import eu.europa.esig.dss.validation.process.bbb.vci.checks.SignaturePolicyIdentifiedCheck;
import eu.europa.esig.dss.validation.process.bbb.vci.checks.SignaturePolicyIdentifierCheck;

public class ValidationContextInitialization
extends Chain<XmlVCI> {
    private final SignatureWrapper signature;
    private final Context context;
    private final ValidationPolicy validationPolicy;

    public ValidationContextInitialization(SignatureWrapper signature, Context context, ValidationPolicy validationPolicy) {
        super(new XmlVCI());
        ((XmlVCI)this.result).setTitle(BasicBuildingBlockDefinition.VALIDATION_CONTEXT_INITIALIZATION.getTitle());
        this.signature = signature;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected void initChain() {
        MultiValuesConstraint signaturePolicyConstraint = this.validationPolicy.getSignaturePolicyConstraint(this.context);
        ChainItem<XmlVCI> item = this.firstItem = this.signaturePolicyIdentifier(signaturePolicyConstraint);
        if (this.signature.isPolicyPresent() && !SignaturePolicyType.IMPLICIT_POLICY.name().equals(this.signature.getPolicyId())) {
            item = item.setNextItem(this.signaturePolicyIdentified());
            if (!this.signature.isZeroHashPolicy()) {
                item = item.setNextItem(this.signaturePolicyHashValid());
            }
        }
    }

    private ChainItem<XmlVCI> signaturePolicyIdentifier(MultiValuesConstraint signaturePolicyConstraint) {
        return new SignaturePolicyIdentifierCheck((XmlVCI)this.result, this.signature, signaturePolicyConstraint);
    }

    private ChainItem<XmlVCI> signaturePolicyIdentified() {
        LevelConstraint constraint = this.validationPolicy.getSignaturePolicyIdentifiedConstraint(this.context);
        return new SignaturePolicyIdentifiedCheck((XmlVCI)this.result, this.signature, constraint);
    }

    private ChainItem<XmlVCI> signaturePolicyHashValid() {
        LevelConstraint constraint = this.validationPolicy.getSignaturePolicyPolicyHashValid(this.context);
        return new SignaturePolicyHashValidCheck((XmlVCI)this.result, this.signature, constraint);
    }
}

