/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import java.text.MessageFormat;
import java.util.List;

public class CryptographicRevocationsCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final List<CryptographicCheck<XmlPSV>> revocationCryptographicChecks;
    private final String certificateId;

    public CryptographicRevocationsCheck(T result, List<CryptographicCheck<XmlPSV>> revocationCryptographicChecks, String certificateId) {
        super(result, null);
        this.revocationCryptographicChecks = revocationCryptographicChecks;
        this.certificateId = certificateId;
    }

    @Override
    protected boolean process() {
        for (CryptographicCheck<XmlPSV> cryptographicCheck : this.revocationCryptographicChecks) {
            if (!cryptographicCheck.process()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getAdditionalInfo() {
        String addInfo = "Revocation data for certificate with id [{0}] is not reliable";
        Object[] params = new Object[]{this.certificateId};
        return MessageFormat.format(addInfo, params);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ACCCRM;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ACCCRM_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE;
    }
}

