/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.AbstractCryptographicCheck;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CryptographicCheck<T extends XmlConstraintsConclusion>
extends AbstractCryptographicCheck<T> {
    private final TokenProxy token;
    private final CryptographicConstraint constraint;

    public CryptographicCheck(T result, TokenProxy token, Date currentTime, CryptographicConstraint constraint) {
        super(result, currentTime, constraint);
        this.constraint = constraint;
        this.token = token;
    }

    @Override
    protected boolean process() {
        boolean expirationCheckRequired = this.isExpirationDateAvailable(this.constraint);
        if (!this.encryptionAlgorithmIsReliable(this.token.getEncryptionAlgorithm())) {
            return false;
        }
        if (!this.digestAlgorithmIsReliable(this.token.getDigestAlgorithm())) {
            return false;
        }
        if (expirationCheckRequired && !this.digestAlgorithmIsValidOnValidationDate(this.token.getDigestAlgorithm())) {
            return false;
        }
        if (!this.isPublicKeySizeKnown(this.token.getKeyLengthUsedToSignThisToken())) {
            return false;
        }
        if (!this.publicKeySizeIsAcceptable(this.token.getEncryptionAlgorithm(), this.token.getKeyLengthUsedToSignThisToken())) {
            return false;
        }
        return !expirationCheckRequired || this.encryptionAlgorithmIsValidOnValidationDate(this.token.getEncryptionAlgorithm(), this.token.getKeyLengthUsedToSignThisToken());
    }

    @Override
    protected MessageTag getMessageTag() {
        if (this.token instanceof CertificateWrapper) {
            return MessageTag.ACCCM;
        }
        if (this.token instanceof RevocationWrapper) {
            return MessageTag.ARCCM;
        }
        if (this.token instanceof TimestampWrapper) {
            return MessageTag.ATCCM;
        }
        return super.getMessageTag();
    }

    @Override
    protected String getAdditionalInfo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String addInfo = null;
        Object[] params = null;
        String dateTime = sdf.format(this.validationDate);
        if (Utils.isStringNotEmpty(this.failedAlgorithm)) {
            addInfo = "Algorithm [{0}] is not reliable at the validation time : {1} for token with ID [{2}]";
            params = new Object[]{this.failedAlgorithm, dateTime, this.token.getId()};
        } else {
            addInfo = "Validation time : {0} for token with ID : [{1}]";
            params = new Object[]{dateTime, this.token.getId()};
        }
        return MessageFormat.format(addInfo, params);
    }
}

