/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.List;

public class CounterSignatureCheck
extends ChainItem<XmlSAV> {
    private final DiagnosticData diagnosticData;
    private final SignatureWrapper signature;

    public CounterSignatureCheck(XmlSAV result, DiagnosticData diagnosticData, SignatureWrapper signature, LevelConstraint constraint) {
        super(result, constraint);
        this.diagnosticData = diagnosticData;
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        boolean foundCountersignature = false;
        String currentSignatureId = this.signature.getId();
        List<SignatureWrapper> signatures = this.diagnosticData.getSignatures();
        for (SignatureWrapper signatureWrapper : signatures) {
            if (!signatureWrapper.isCounterSignature() || !currentSignatureId.equals(signatureWrapper.getParent().getId())) continue;
            foundCountersignature = true;
            break;
        }
        return foundCountersignature;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_IUQPCSP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_IUQPCSP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

