/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;
import java.util.List;

public class CommitmentTypeIndicationsCheck
extends ChainItem<XmlSAV> {
    private final SignatureWrapper signature;
    private final MultiValuesConstraint constraint;

    public CommitmentTypeIndicationsCheck(XmlSAV result, SignatureWrapper signature, MultiValuesConstraint constraint) {
        super(result, constraint);
        this.signature = signature;
        this.constraint = constraint;
    }

    @Override
    protected boolean process() {
        List<String> commitmentTypeIdentifiers = this.signature.getCommitmentTypeIdentifiers();
        List<String> expectedValues = this.constraint.getId();
        if (Utils.isCollectionEmpty(commitmentTypeIdentifiers)) {
            return false;
        }
        if (Utils.isCollectionNotEmpty(expectedValues)) {
            return expectedValues.containsAll(commitmentTypeIdentifiers);
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ISQPXTIP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ISQPXTIP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

