/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.validation.process.MessageTag;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import java.util.List;

public class ClaimedRolesCheck
extends AbstractMultiValuesCheckItem<XmlSAV> {
    private final SignatureWrapper signature;

    public ClaimedRolesCheck(XmlSAV result, SignatureWrapper signature, MultiValuesConstraint constraint) {
        super(result, constraint);
        this.signature = signature;
    }

    @Override
    protected boolean process() {
        List<String> claimedRoles = this.signature.getSignerRoleDetails(this.signature.getClaimedRoles());
        return this.processValuesCheck(claimedRoles);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_SAV_ICRM;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_SAV_ICRM_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.SIG_CONSTRAINTS_FAILURE;
    }
}

