/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCryptographicInformation;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicCheck;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.CryptographicConstraintWrapper;
import java.util.Date;
import java.util.Map;

public abstract class AbstractAcceptanceValidation<T extends AbstractTokenProxy>
extends Chain<XmlSAV> {
    protected final T token;
    protected final Date currentTime;
    protected final Context context;
    protected final ValidationPolicy validationPolicy;

    public AbstractAcceptanceValidation(T token, Date currentTime, Context context, ValidationPolicy validationPolicy) {
        super(new XmlSAV());
        this.token = token;
        this.currentTime = currentTime;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    protected ChainItem<XmlSAV> cryptographic() {
        CryptographicConstraint constraint = this.validationPolicy.getSignatureCryptographicConstraint(this.context);
        return new CryptographicCheck<XmlSAV>((XmlSAV)this.result, (TokenProxy)this.token, this.currentTime, constraint);
    }

    @Override
    protected void addAdditionalInfo() {
        super.addAdditionalInfo();
        ((XmlSAV)this.result).setValidationTime(this.currentTime);
        XmlCryptographicInformation cryptoInfo = new XmlCryptographicInformation();
        this.fillAlgorithmURI(cryptoInfo, (AbstractTokenProxy)this.token);
        cryptoInfo.setKeyLength(((AbstractTokenProxy)this.token).getKeyLengthUsedToSignThisToken());
        XmlConclusion conclusion = ((XmlSAV)this.result).getConclusion();
        if (Indication.INDETERMINATE.equals(conclusion.getIndication()) && SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication())) {
            cryptoInfo.setSecure(false);
        } else {
            cryptoInfo.setSecure(true);
        }
        CryptographicConstraint cryptographicConstraint = this.validationPolicy.getSignatureCryptographicConstraint(this.context);
        if (cryptographicConstraint != null) {
            Date notAfter = null;
            CryptographicConstraintWrapper wrapper = new CryptographicConstraintWrapper(cryptographicConstraint);
            Map<String, Date> expirationDates = wrapper.getExpirationTimes();
            String digestAlgoToFind = ((AbstractTokenProxy)this.token).getDigestAlgorithm() == null ? "" : ((AbstractTokenProxy)this.token).getDigestAlgorithm().getName();
            notAfter = expirationDates.get(digestAlgoToFind);
            String encryptionAlgoToFind = ((AbstractTokenProxy)this.token).getEncryptionAlgorithm() == null ? "" : ((AbstractTokenProxy)this.token).getEncryptionAlgorithm().name();
            Date expirationEncryption = expirationDates.get(encryptionAlgoToFind + ((AbstractTokenProxy)this.token).getKeyLengthUsedToSignThisToken());
            if (notAfter == null || expirationEncryption != null && notAfter.after(expirationEncryption)) {
                notAfter = expirationEncryption;
            }
            cryptoInfo.setNotAfter(notAfter);
        }
        ((XmlSAV)this.result).setCryptographicInfo(cryptoInfo);
    }

    private void fillAlgorithmURI(XmlCryptographicInformation cryptoInfo, AbstractTokenProxy token) {
        try {
            EncryptionAlgorithm encryptionAlgorithm = token.getEncryptionAlgorithm();
            MaskGenerationFunction maskGenerationFunction = token.getMaskGenerationFunction();
            DigestAlgorithm digestAlgorithm = token.getDigestAlgorithm();
            SignatureAlgorithm sigAlgo = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm, maskGenerationFunction);
            String uri = sigAlgo.getUri();
            if (uri == null) {
                uri = sigAlgo.getURIBasedOnOID();
            }
            cryptoInfo.setAlgorithm(uri);
        }
        catch (Exception e) {
            cryptoInfo.setAlgorithm("???");
        }
    }
}

