/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.MessageTag;

public class ManifestFilePresentCheck
extends ChainItem<XmlFC> {
    private final XmlContainerInfo containerInfo;
    private MessageTag message;
    private MessageTag error;

    public ManifestFilePresentCheck(XmlFC result, XmlContainerInfo containerInfo, LevelConstraint constraint) {
        super(result, constraint);
        this.containerInfo = containerInfo;
    }

    @Override
    protected boolean process() {
        if ("ASiC-S".equals(this.containerInfo.getContainerType())) {
            this.message = MessageTag.BBB_FC_IMFP_ASICS;
            this.error = MessageTag.BBB_FC_IMFP_ASICS_ANS;
            return Utils.isCollectionEmpty(this.containerInfo.getManifestFiles());
        }
        this.message = MessageTag.BBB_FC_IMFP_ASICE;
        this.error = MessageTag.BBB_FC_IMFP_ASICE_ANS;
        return Utils.isCollectionNotEmpty(this.containerInfo.getManifestFiles());
    }

    @Override
    protected MessageTag getMessageTag() {
        return this.message;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.error;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

