/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public abstract class Chain<T extends XmlConstraintsConclusion> {
    protected final T result;
    protected ChainItem<T> firstItem;

    protected Chain(T newInstance) {
        this.result = newInstance;
    }

    public T execute() {
        this.initChain();
        if (this.firstItem != null) {
            this.firstItem.execute();
        }
        if (((XmlConstraintsConclusion)this.result).getConclusion() == null) {
            XmlConclusion conclusion = new XmlConclusion();
            conclusion.setIndication(Indication.PASSED);
            ((XmlConstraintsConclusion)this.result).setConclusion(conclusion);
        }
        this.addAdditionalInfo();
        return this.result;
    }

    protected void addAdditionalInfo() {
    }

    protected abstract void initChain();

    protected LevelConstraint getFailLevelConstraint() {
        LevelConstraint constraint = new LevelConstraint();
        constraint.setLevel(Level.FAIL);
        return constraint;
    }

    protected LevelConstraint getWarnLevelConstraint() {
        LevelConstraint constraint = new LevelConstraint();
        constraint.setLevel(Level.WARN);
        return constraint;
    }

    protected LevelConstraint getInfoLevelConstraint() {
        LevelConstraint constraint = new LevelConstraint();
        constraint.setLevel(Level.INFORM);
        return constraint;
    }

    protected void collectErrorsWarnsInfos() {
        XmlConclusion conclusion = ((XmlConstraintsConclusion)this.result).getConclusion();
        List<XmlConstraint> constraints = ((XmlConstraintsConclusion)this.result).getConstraint();
        for (XmlConstraint xmlConstraint : constraints) {
            XmlName info;
            XmlName warning;
            XmlName error = xmlConstraint.getError();
            if (error != null) {
                conclusion.getErrors().add(error);
            }
            if ((warning = xmlConstraint.getWarning()) != null) {
                conclusion.getWarnings().add(warning);
            }
            if ((info = xmlConstraint.getInfo()) == null) continue;
            conclusion.getInfos().add(info);
        }
    }
}

