/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.executor.AbstractDetailedReportBuilder;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationBlock;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;

public class DetailedReportForCertificateBuilder
extends AbstractDetailedReportBuilder {
    private final String certificateId;

    public DetailedReportForCertificateBuilder(DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, String certificateId) {
        super(diagnosticData, policy, currentTime);
        this.certificateId = certificateId;
    }

    XmlDetailedReport build() {
        XmlDetailedReport detailedReport = this.init();
        CertificateWrapper certificate = this.diagnosticData.getUsedCertificateById(this.certificateId);
        HashMap<String, XmlBasicBuildingBlocks> bbbs = new HashMap<String, XmlBasicBuildingBlocks>();
        this.process(Collections.singleton(certificate), Context.CERTIFICATE, bbbs);
        detailedReport.getBasicBuildingBlocks().addAll(bbbs.values());
        XmlBasicBuildingBlocks basicBuildingBlocks = (XmlBasicBuildingBlocks)bbbs.get(certificate.getId());
        CertificateQualificationBlock cqb = new CertificateQualificationBlock(basicBuildingBlocks.getConclusion(), this.currentTime, certificate, detailedReport.getTLAnalysis(), this.diagnosticData.getLOTLCountryCode());
        detailedReport.setCertificate((XmlCertificate)cqb.execute());
        return detailedReport;
    }
}

