/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.simplecertificatereport.jaxb.XmlSimpleCertificateReport;
import eu.europa.esig.dss.validation.executor.CertificateProcessExecutor;
import eu.europa.esig.dss.validation.executor.DetailedReportForCertificateBuilder;
import eu.europa.esig.dss.validation.executor.SimpleReportForCertificateBuilder;
import eu.europa.esig.dss.validation.reports.CertificateReports;
import java.util.Date;
import java.util.Objects;

public class DefaultCertificateProcessExecutor
implements CertificateProcessExecutor {
    private Date currentTime;
    private ValidationPolicy policy;
    private XmlDiagnosticData jaxbDiagnosticData;
    private String certificateId;

    @Override
    public void setCurrentTime(Date currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public void setDiagnosticData(XmlDiagnosticData diagnosticData) {
        this.jaxbDiagnosticData = diagnosticData;
    }

    @Override
    public void setValidationPolicy(ValidationPolicy validationPolicy) {
        this.policy = validationPolicy;
    }

    @Override
    public ValidationPolicy getValidationPolicy() {
        return this.policy;
    }

    @Override
    public void setCertificateId(String certificateId) {
        this.certificateId = certificateId;
    }

    @Override
    public CertificateReports execute() {
        Objects.requireNonNull(this.jaxbDiagnosticData, "The diagnostic data is missing");
        Objects.requireNonNull(this.policy, "The validation policy is missing");
        Objects.requireNonNull(this.currentTime, "The current time is missing");
        Objects.requireNonNull(this.certificateId, "The certificate id is missing");
        DiagnosticData diagnosticData = new DiagnosticData(this.jaxbDiagnosticData);
        DetailedReportForCertificateBuilder detailedReportBuilder = new DetailedReportForCertificateBuilder(diagnosticData, this.policy, this.currentTime, this.certificateId);
        XmlDetailedReport detailedReport = detailedReportBuilder.build();
        SimpleReportForCertificateBuilder simpleReportBuilder = new SimpleReportForCertificateBuilder(diagnosticData, new DetailedReport(detailedReport), this.currentTime, this.certificateId);
        XmlSimpleCertificateReport simpleReport = simpleReportBuilder.build();
        return new CertificateReports(this.jaxbDiagnosticData, detailedReport, simpleReport);
    }
}

