/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.BasicBuildingBlocks;
import eu.europa.esig.dss.validation.process.qualification.trust.TLValidationBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractDetailedReportBuilder {
    protected final DiagnosticData diagnosticData;
    protected final ValidationPolicy policy;
    protected final Date currentTime;

    protected AbstractDetailedReportBuilder(DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime) {
        this.diagnosticData = diagnosticData;
        this.policy = policy;
        this.currentTime = currentTime;
    }

    protected XmlDetailedReport init() {
        XmlDetailedReport detailedReport = new XmlDetailedReport();
        if (this.policy.isEIDASConstraintPresent()) {
            detailedReport.getTLAnalysis().addAll(this.executeAllTlAnalysis(this.diagnosticData, this.policy, this.currentTime));
        }
        return detailedReport;
    }

    protected List<XmlTLAnalysis> executeAllTlAnalysis(DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime) {
        List<XmlTrustedList> trustedLists;
        ArrayList<XmlTLAnalysis> result = new ArrayList<XmlTLAnalysis>();
        XmlTrustedList listOfTrustedLists = diagnosticData.getListOfTrustedLists();
        if (listOfTrustedLists != null) {
            TLValidationBlock tlValidation = new TLValidationBlock(listOfTrustedLists, currentTime, policy);
            result.add((XmlTLAnalysis)tlValidation.execute());
        }
        if (Utils.isCollectionNotEmpty(trustedLists = diagnosticData.getTrustedLists())) {
            for (XmlTrustedList xmlTrustedList : trustedLists) {
                TLValidationBlock tlValidation = new TLValidationBlock(xmlTrustedList, currentTime, policy);
                result.add((XmlTLAnalysis)tlValidation.execute());
            }
        }
        return result;
    }

    protected void process(Collection<? extends AbstractTokenProxy> tokensToProcess, Context context, Map<String, XmlBasicBuildingBlocks> bbbs) {
        for (AbstractTokenProxy abstractTokenProxy : tokensToProcess) {
            BasicBuildingBlocks bbb = new BasicBuildingBlocks(this.diagnosticData, abstractTokenProxy, this.currentTime, this.policy, context);
            XmlBasicBuildingBlocks result = bbb.execute();
            bbbs.put(abstractTokenProxy.getId(), result);
        }
    }
}

