/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.policy.EtsiValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.policy.jaxb.ConstraintsParameters;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.DocumentValidatorFactory;
import eu.europa.esig.dss.validation.ListCRLSource;
import eu.europa.esig.dss.validation.ListOCSPSource;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ProcessExecutorProvider;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureValidationContext;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.executor.DefaultSignatureProcessExecutor;
import eu.europa.esig.dss.validation.executor.SignatureProcessExecutor;
import eu.europa.esig.dss.validation.executor.ValidationLevel;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignedDocumentValidator
implements DocumentValidator,
ProcessExecutorProvider<SignatureProcessExecutor> {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDocumentValidator.class);
    protected SignatureProcessExecutor processExecutor = null;
    protected CertificatePool validationCertPool = null;
    protected DSSDocument document;
    protected List<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
    protected List<DSSDocument> containerContents;
    protected List<ManifestFile> manifestFiles;
    protected CertificateToken providedSigningCertificateToken = null;
    protected CertificateVerifier certificateVerifier;
    protected final SignatureScopeFinder signatureScopeFinder;
    protected SignaturePolicyProvider signaturePolicyProvider;
    private ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    private boolean enableEtsiValidationReport = true;

    protected SignedDocumentValidator(SignatureScopeFinder signatureScopeFinder) {
        this.signatureScopeFinder = signatureScopeFinder;
    }

    private void setSignedScopeFinderDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        if (this.signatureScopeFinder != null) {
            this.signatureScopeFinder.setDefaultDigestAlgorithm(digestAlgorithm);
        }
    }

    public static SignedDocumentValidator fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<DocumentValidatorFactory> serviceLoaders = ServiceLoader.load(DocumentValidatorFactory.class);
        for (DocumentValidatorFactory factory : serviceLoaders) {
            try {
                if (!factory.isSupported(dssDocument)) continue;
                return factory.create(dssDocument);
            }
            catch (Exception e) {
                LOG.error(String.format("Unable to create a DocumentValidator with the factory '%s'", factory.getClass().getSimpleName()), e);
            }
        }
        throw new DSSException("Document format not recognized/handled");
    }

    public abstract boolean isSupported(DSSDocument var1);

    @Override
    public void defineSigningCertificate(CertificateToken token) {
        if (token == null) {
            throw new NullPointerException("Token is not defined");
        }
        if (this.validationCertPool == null) {
            throw new NullPointerException("Certificate pool is not instantiated");
        }
        this.providedSigningCertificateToken = this.validationCertPool.getInstance(token, CertificateSourceType.OTHER);
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
        if (this.validationCertPool == null) {
            this.validationCertPool = certificateVerifier.createValidationPool();
        }
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.detachedContents = detachedContents;
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.containerContents = containerContents;
    }

    @Override
    public void setManifestFiles(List<ManifestFile> manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public void setEnableEtsiValidationReport(boolean enableEtsiValidationReport) {
        this.enableEtsiValidationReport = enableEtsiValidationReport;
    }

    @Override
    public Reports validateDocument() {
        return this.validateDocument((InputStream)null);
    }

    @Override
    public Reports validateDocument(URL validationPolicyURL) {
        if (validationPolicyURL == null) {
            return this.validateDocument((InputStream)null);
        }
        try {
            return this.validateDocument(validationPolicyURL.openStream());
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    @Override
    public Reports validateDocument(String policyResourcePath) {
        if (policyResourcePath == null) {
            return this.validateDocument((InputStream)null);
        }
        return this.validateDocument(this.getClass().getResourceAsStream(policyResourcePath));
    }

    @Override
    public Reports validateDocument(File policyFile) {
        if (policyFile == null || !policyFile.exists()) {
            return this.validateDocument((InputStream)null);
        }
        InputStream inputStream = DSSUtils.toByteArrayInputStream(policyFile);
        return this.validateDocument(inputStream);
    }

    @Override
    public Reports validateDocument(InputStream policyDataStream) {
        ValidationPolicy validationPolicy = null;
        try {
            validationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(policyDataStream);
        }
        catch (Exception e) {
            throw new DSSException("Unable to load the policy", e);
        }
        return this.validateDocument(validationPolicy);
    }

    @Override
    public Reports validateDocument(ConstraintsParameters validationPolicyJaxb) {
        EtsiValidationPolicy validationPolicy = new EtsiValidationPolicy(validationPolicyJaxb);
        return this.validateDocument(validationPolicy);
    }

    @Override
    public Reports validateDocument(ValidationPolicy validationPolicy) {
        LOG.info("Document validation...");
        Objects.requireNonNull(this.certificateVerifier, "CertificateVerifier is not defined");
        Objects.requireNonNull(this.document, "Document is not provided to the validator");
        this.ensureSignaturePolicyDetectorInitialized();
        boolean structuralValidation = this.isRequireStructuralValidation(validationPolicy);
        SignatureValidationContext validationContext = new SignatureValidationContext(this.validationCertPool);
        List<AdvancedSignature> allSignatureList = this.prepareSignatureValidationContext(validationContext);
        allSignatureList = this.processSignaturesValidation(validationContext, allSignatureList, structuralValidation);
        XmlDiagnosticData diagnosticData = new DiagnosticDataBuilder().document(this.document).containerInfo(this.getContainerInfo()).foundSignatures(allSignatureList).usedCertificates(validationContext.getProcessedCertificates()).usedRevocations(validationContext.getProcessedRevocations()).setDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm()).includeRawCertificateTokens(this.certificateVerifier.isIncludeCertificateTokenValues()).includeRawRevocationData(this.certificateVerifier.isIncludeCertificateRevocationValues()).includeRawTimestampTokens(this.certificateVerifier.isIncludeTimestampTokenValues()).certificateSourceTypes(validationContext.getCertificateSourceTypes()).trustedCertificateSource(this.certificateVerifier.getTrustedCertSource()).validationDate(validationContext.getCurrentTime()).build();
        return this.processValidationPolicy(diagnosticData, validationPolicy);
    }

    @Override
    public List<AdvancedSignature> prepareSignatureValidationContext(ValidationContext validationContext) {
        List<AdvancedSignature> allSignatureList = this.getAllSignatures();
        this.setSignedScopeFinderDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
        for (AdvancedSignature signature : allSignatureList) {
            if (this.signatureScopeFinder == null) continue;
            signature.findSignatureScope(this.signatureScopeFinder);
        }
        this.prepareCertificatesAndTimestamps(allSignatureList, validationContext);
        return allSignatureList;
    }

    @Override
    public List<AdvancedSignature> processSignaturesValidation(ValidationContext validationContext, List<AdvancedSignature> allSignatureList, boolean structuralValidation) {
        ListCRLSource signatureCRLSource = this.getSignatureCrlSource(allSignatureList);
        this.certificateVerifier.setSignatureCRLSource(signatureCRLSource);
        ListOCSPSource signatureOCSPSource = this.getSignatureOcspSource(allSignatureList);
        this.certificateVerifier.setSignatureOCSPSource(signatureOCSPSource);
        validationContext.setCurrentTime(this.provideProcessExecutorInstance().getCurrentTime());
        validationContext.initialize(this.certificateVerifier);
        validationContext.validate();
        for (AdvancedSignature signature : allSignatureList) {
            signature.checkSigningCertificate();
            signature.checkSignatureIntegrity();
            if (structuralValidation) {
                signature.validateStructure();
            }
            signature.checkSignaturePolicy(this.signaturePolicyProvider);
            signature.populateCRLTokenLists(signatureCRLSource);
            signature.populateOCSPTokenLists(signatureOCSPSource);
        }
        return allSignatureList;
    }

    protected ContainerInfo getContainerInfo() {
        return null;
    }

    protected Reports processValidationPolicy(XmlDiagnosticData diagnosticData, ValidationPolicy validationPolicy) {
        SignatureProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setValidationPolicy(validationPolicy);
        executor.setValidationLevel(this.validationLevel);
        executor.setDiagnosticData(diagnosticData);
        executor.setEnableEtsiValidationReport(this.enableEtsiValidationReport);
        Reports reports = (Reports)executor.execute();
        return reports;
    }

    @Override
    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.signaturePolicyProvider = signaturePolicyProvider;
    }

    protected void ensureSignaturePolicyDetectorInitialized() {
        if (this.signaturePolicyProvider == null) {
            this.signaturePolicyProvider = new SignaturePolicyProvider();
            this.signaturePolicyProvider.setDataLoader(this.certificateVerifier.getDataLoader());
        }
    }

    @Override
    public void setProcessExecutor(SignatureProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public SignatureProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = new DefaultSignatureProcessExecutor();
        }
        return this.processExecutor;
    }

    private List<AdvancedSignature> getAllSignatures() {
        ArrayList<AdvancedSignature> allSignatureList = new ArrayList<AdvancedSignature>();
        List<AdvancedSignature> signatureList = this.getSignatures();
        for (AdvancedSignature signature : signatureList) {
            allSignatureList.add(signature);
            allSignatureList.addAll(signature.getCounterSignatures());
        }
        return allSignatureList;
    }

    private ListCRLSource getSignatureCrlSource(List<AdvancedSignature> allSignatureList) {
        ListCRLSource signatureCrlSource = new ListCRLSource();
        for (AdvancedSignature signature : allSignatureList) {
            signatureCrlSource.addAll(signature.getCompleteCRLSource());
        }
        return signatureCrlSource;
    }

    private ListOCSPSource getSignatureOcspSource(List<AdvancedSignature> allSignatureList) {
        ListOCSPSource signatureOcspSource = new ListOCSPSource();
        for (AdvancedSignature signature : allSignatureList) {
            signatureOcspSource.addAll(signature.getCompleteOCSPSource());
        }
        return signatureOcspSource;
    }

    private void prepareCertificatesAndTimestamps(List<AdvancedSignature> allSignatureList, ValidationContext validationContext) {
        if (this.providedSigningCertificateToken != null) {
            validationContext.addCertificateTokenForVerification(this.providedSigningCertificateToken);
        }
        for (AdvancedSignature signature : allSignatureList) {
            List<CertificateToken> candidates = signature.getCertificates();
            for (CertificateToken certificateToken : candidates) {
                validationContext.addCertificateTokenForVerification(certificateToken);
            }
            signature.prepareTimestamps(validationContext);
        }
    }

    private boolean isRequireStructuralValidation(ValidationPolicy validationPolicy) {
        return validationPolicy != null && validationPolicy.getStructuralValidationConstraint(Context.SIGNATURE) != null;
    }

    static {
        Security.addProvider(DSSSecurityProvider.getSecurityProvider());
    }
}

