/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.CertificateReorderer;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.x509.AlternateUrlsSourceAdapter;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSourceAlternateUrlsSupport;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.OCSPAndCRLCertificateVerifier;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureValidationContext
implements ValidationContext {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureValidationContext.class);
    private final Set<CertificateToken> processedCertificates = new HashSet<CertificateToken>();
    private final Set<RevocationToken> processedRevocations = new HashSet<RevocationToken>();
    private final Set<TimestampToken> processedTimestamps = new HashSet<TimestampToken>();
    private DataLoader dataLoader;
    protected CertificatePool validationCertificatePool;
    private final Map<Token, Boolean> tokensToProcess = new HashMap<Token, Boolean>();
    private final Map<CertificateToken, Date> lastUsageDates = new HashMap<CertificateToken, Date>();
    private Map<CertificateToken, List<CertificateToken>> orderedCertificateChains;
    private OCSPSource ocspSource;
    private CRLSource crlSource;
    private CRLSource signatureCRLSource;
    private OCSPSource signatureOCSPSource;
    private CertificateSource trustedCertSource;
    private boolean checkRevocationForUntrustedChains;
    protected Date currentTime = new Date();

    public SignatureValidationContext() {
    }

    public SignatureValidationContext(CertificatePool validationCertificatePool) {
        Objects.requireNonNull(validationCertificatePool);
        this.validationCertificatePool = validationCertificatePool;
    }

    @Override
    public void initialize(CertificateVerifier certificateVerifier) {
        Objects.requireNonNull(certificateVerifier);
        if (this.validationCertificatePool == null) {
            this.validationCertificatePool = new CertificatePool();
        }
        if (certificateVerifier.getTrustedCertSource() != null) {
            this.validationCertificatePool.importCerts(certificateVerifier.getTrustedCertSource());
        }
        if (certificateVerifier.getAdjunctCertSource() != null) {
            this.validationCertificatePool.importCerts(certificateVerifier.getAdjunctCertSource());
        }
        this.crlSource = certificateVerifier.getCrlSource();
        this.ocspSource = certificateVerifier.getOcspSource();
        this.dataLoader = certificateVerifier.getDataLoader();
        this.signatureCRLSource = certificateVerifier.getSignatureCRLSource();
        this.signatureOCSPSource = certificateVerifier.getSignatureOCSPSource();
        this.trustedCertSource = certificateVerifier.getTrustedCertSource();
        this.checkRevocationForUntrustedChains = certificateVerifier.isCheckRevocationForUntrustedChains();
    }

    @Override
    public Date getCurrentTime() {
        return this.currentTime;
    }

    @Override
    public void setCurrentTime(Date currentTime) {
        Objects.requireNonNull(currentTime);
        this.currentTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getNotYetVerifiedToken() {
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            for (Map.Entry<Token, Boolean> entry : this.tokensToProcess.entrySet()) {
                if (entry.getValue() != null) continue;
                entry.setValue(true);
                return entry.getKey();
            }
            return null;
        }
    }

    private Map<CertificateToken, List<CertificateToken>> getOrderedCertificateChains() {
        if (this.orderedCertificateChains == null) {
            CertificateReorderer order = new CertificateReorderer(this.processedCertificates);
            this.orderedCertificateChains = order.getOrderedCertificateChains();
        }
        return this.orderedCertificateChains;
    }

    private List<Token> getCertChain(Token token) throws DSSException {
        LinkedList<Token> chain = new LinkedList<Token>();
        Token issuerCertificateToken = token;
        do {
            chain.add(issuerCertificateToken);
            issuerCertificateToken = this.validationCertificatePool.getIssuer(issuerCertificateToken);
            if (issuerCertificateToken == null && token instanceof CertificateToken) {
                issuerCertificateToken = this.getIssuerFromAIA((CertificateToken)token);
            }
            if (issuerCertificateToken == null && token instanceof TimestampToken) {
                issuerCertificateToken = this.getTSACertificate((TimestampToken)token);
            }
            if (!(issuerCertificateToken instanceof CertificateToken)) continue;
            this.addCertificateTokenForVerification((CertificateToken)issuerCertificateToken);
        } while (issuerCertificateToken != null && !chain.contains(issuerCertificateToken));
        return chain;
    }

    private CertificateToken getTSACertificate(TimestampToken timestamp) {
        List<CertificateToken> candidates = timestamp.getCertificates();
        for (CertificateToken candidate : candidates) {
            if (!timestamp.isSignedBy(candidate)) continue;
            return candidate;
        }
        LOG.info("TSA certificate not found in the token");
        candidates = this.validationCertificatePool.getBySignerId(timestamp.getSignerId());
        for (CertificateToken candidate : candidates) {
            if (!timestamp.isSignedBy(candidate)) continue;
            return candidate;
        }
        LOG.warn("TSA certificate not found in the certificate pool");
        return null;
    }

    private CertificateToken getIssuerFromAIA(CertificateToken token) {
        LOG.info("Retrieving {} certificate's issuer using AIA.", (Object)token.getAbbreviation());
        Collection<CertificateToken> candidates = DSSUtils.loadPotentialIssuerCertificates(token, this.dataLoader);
        if (Utils.isCollectionNotEmpty(candidates)) {
            CertificateToken bridgedIssuer = this.findBestBridgeCertificate(token, candidates);
            if (bridgedIssuer != null) {
                this.addCertificateTokenForVerification(this.validationCertificatePool.getInstance(bridgedIssuer, CertificateSourceType.AIA));
                return bridgedIssuer;
            }
            for (CertificateToken candidate : candidates) {
                this.addCertificateTokenForVerification(this.validationCertificatePool.getInstance(candidate, CertificateSourceType.AIA));
            }
            for (CertificateToken candidate : candidates) {
                if (!token.isSignedBy(candidate)) continue;
                if (!token.getIssuerX500Principal().equals(candidate.getSubjectX500Principal())) {
                    LOG.info("There is AIA extension, but the issuer subject name and subject name does not match.");
                    LOG.info("CERT ISSUER    : {}", (Object)token.getIssuerX500Principal());
                    LOG.info("ISSUER SUBJECT : {}", (Object)candidate.getSubjectX500Principal());
                }
                return candidate;
            }
            LOG.warn("The retrieved certificate(s) using AIA does not sign the certificate {}.", (Object)token.getAbbreviation());
        }
        return null;
    }

    private CertificateToken findBestBridgeCertificate(CertificateToken token, Collection<CertificateToken> candidates) {
        if (Utils.isCollectionEmpty(candidates) || candidates.size() == 1) {
            return null;
        }
        PublicKey commonPublicKey = null;
        CertificateToken bestMatch = null;
        block0: for (CertificateToken candidate : candidates) {
            PublicKey candidatePublicKey = candidate.getPublicKey();
            if (commonPublicKey == null) {
                if (!token.isSignedBy(candidate)) {
                    return null;
                }
                commonPublicKey = candidatePublicKey;
                bestMatch = candidate;
            } else {
                if (!candidatePublicKey.equals(commonPublicKey)) {
                    return null;
                }
                if (this.isTrusted(bestMatch)) continue;
            }
            Set<CertificateToken> tokensSet = this.validationCertificatePool.get(candidate.getSubjectX500Principal());
            for (CertificateToken pooledToken : tokensSet) {
                if (!pooledToken.getPublicKey().equals(commonPublicKey) || !this.isTrusted(pooledToken)) continue;
                bestMatch = pooledToken;
                token.isSignedBy(pooledToken);
                continue block0;
            }
        }
        return bestMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addTokenForVerification(Token token) {
        if (token == null) {
            return false;
        }
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("addTokenForVerification: trying to acquire synchronized block");
        }
        Map<Token, Boolean> map = this.tokensToProcess;
        synchronized (map) {
            try {
                if (this.tokensToProcess.containsKey(token)) {
                    if (traceEnabled) {
                        LOG.trace("Token was already in the list {}:{}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                    }
                    boolean bl2 = false;
                    return bl2;
                }
                this.tokensToProcess.put(token, null);
                if (traceEnabled) {
                    LOG.trace("+ New {} to check: {}", (Object)token.getClass().getSimpleName(), (Object)token.getAbbreviation());
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (traceEnabled) {
                    LOG.trace("addTokenForVerification: almost left synchronized block");
                }
            }
        }
    }

    @Override
    public void addRevocationTokensForVerification(List<RevocationToken> revocationTokens) {
        for (RevocationToken revocationToken : revocationTokens) {
            if (!this.addTokenForVerification(revocationToken)) continue;
            boolean added = this.processedRevocations.add(revocationToken);
            if (!LOG.isTraceEnabled()) continue;
            if (added) {
                LOG.trace("RevocationToken added to processedRevocations: {} ", (Object)revocationToken);
                continue;
            }
            LOG.trace("RevocationToken already present processedRevocations: {} ", (Object)revocationToken);
        }
    }

    @Override
    public void addCertificateTokenForVerification(CertificateToken certificateToken) {
        if (this.addTokenForVerification(certificateToken)) {
            boolean added = this.processedCertificates.add(certificateToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("CertificateToken added to processedCertificates: {} ", (Object)certificateToken);
                } else {
                    LOG.trace("CertificateToken already present processedCertificates: {} ", (Object)certificateToken);
                }
            }
        }
    }

    @Override
    public void addTimestampTokenForVerification(TimestampToken timestampToken) {
        if (this.addTokenForVerification(timestampToken)) {
            boolean added = this.processedTimestamps.add(timestampToken);
            if (LOG.isTraceEnabled()) {
                if (added) {
                    LOG.trace("TimestampToken added to processedTimestamps: {} ", (Object)this.processedTimestamps);
                } else {
                    LOG.trace("TimestampToken already present processedTimestamps: {} ", (Object)this.processedTimestamps);
                }
            }
        }
    }

    private void registerUsageDate(TimestampToken timestampToken) {
        CertificateToken tsaCertificate = this.getTSACertificate(timestampToken);
        if (tsaCertificate == null) {
            LOG.warn("No Timestamp Certificate found. Chain is skipped.");
            return;
        }
        Map<CertificateToken, List<CertificateToken>> certificateChains = this.getOrderedCertificateChains();
        List<CertificateToken> tsaCertificateChain = certificateChains.get(tsaCertificate);
        if (tsaCertificateChain == null) {
            tsaCertificateChain = this.toCertificateTokenChain(this.getCertChain(tsaCertificate));
            certificateChains.put(tsaCertificate, tsaCertificateChain);
        }
        Date usageDate = timestampToken.getCreationDate();
        for (CertificateToken cert : tsaCertificateChain) {
            if (this.isSelfSignedOrTrusted(cert)) {
                return;
            }
            Date lastUsage = this.lastUsageDates.get(cert);
            if (lastUsage != null && !lastUsage.before(usageDate)) continue;
            this.lastUsageDates.put(cert, usageDate);
        }
    }

    private List<CertificateToken> toCertificateTokenChain(List<Token> tokens) {
        LinkedList<CertificateToken> chain = new LinkedList<CertificateToken>();
        for (Token token : tokens) {
            if (!(token instanceof CertificateToken)) continue;
            chain.add((CertificateToken)token);
        }
        return chain;
    }

    @Override
    public void validate() throws DSSException {
        Token token = this.getNotYetVerifiedToken();
        while (token != null) {
            List<Token> certChain = this.getCertChain(token);
            if (token instanceof CertificateToken) {
                List<RevocationToken> revocationTokens = this.getRevocationData((CertificateToken)token, certChain);
                this.addRevocationTokensForVerification(revocationTokens);
            } else if (token instanceof TimestampToken) {
                this.registerUsageDate((TimestampToken)token);
            }
            token = this.getNotYetVerifiedToken();
        }
    }

    private List<RevocationToken> getRevocationData(CertificateToken certToken, List<Token> certChain) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Checking revocation data for : {}", (Object)certToken.getDSSIdAsString());
        }
        if (this.isRevocationDataNotRequired(certToken)) {
            return Collections.emptyList();
        }
        ArrayList<RevocationToken> revocations = new ArrayList<RevocationToken>();
        if (this.signatureCRLSource != null || this.signatureOCSPSource != null) {
            RevocationToken crlToken;
            OCSPAndCRLCertificateVerifier offlineVerifier = new OCSPAndCRLCertificateVerifier(this.signatureCRLSource, this.signatureOCSPSource, this.validationCertificatePool);
            RevocationToken ocspToken = offlineVerifier.checkOCSP(certToken);
            if (ocspToken != null) {
                revocations.add(ocspToken);
            }
            if ((crlToken = offlineVerifier.checkCRL(certToken)) != null) {
                revocations.add(crlToken);
            }
        }
        if (revocations.isEmpty() || this.isRevocationDataRefreshNeeded(certToken, revocations)) {
            if (this.checkRevocationForUntrustedChains || this.containsTrustAnchor(certChain)) {
                CertificateToken trustAnchor = (CertificateToken)this.getFirstTrustAnchor(certChain);
                OCSPAndCRLCertificateVerifier onlineVerifier = null;
                onlineVerifier = this.trustedCertSource instanceof CommonTrustedCertificateSource && trustAnchor != null ? this.instantiateWithTrustServices((CommonTrustedCertificateSource)this.trustedCertSource, trustAnchor) : new OCSPAndCRLCertificateVerifier(this.crlSource, this.ocspSource, this.validationCertificatePool);
                RevocationToken onlineRevocationToken = onlineVerifier.check(certToken);
                if (onlineRevocationToken != null && !revocations.contains(onlineRevocationToken)) {
                    revocations.add(onlineRevocationToken);
                }
            } else {
                LOG.warn("External revocation check is skipped for untrusted certificate : {}", (Object)certToken.getDSSIdAsString());
            }
        }
        if (revocations.isEmpty()) {
            LOG.warn("No revocation found for certificate {}", (Object)certToken.getDSSIdAsString());
        }
        return revocations;
    }

    private boolean containsTrustAnchor(List<Token> certChain) {
        return this.getFirstTrustAnchor(certChain) != null;
    }

    private Token getFirstTrustAnchor(List<Token> certChain) {
        for (Token token : certChain) {
            if (!this.isTrusted(token)) continue;
            return token;
        }
        return null;
    }

    private OCSPAndCRLCertificateVerifier instantiateWithTrustServices(CommonTrustedCertificateSource trustedCertSource, CertificateToken trustAnchor) {
        RevocationSource<OCSPToken> currentOCSPSource = null;
        List<String> alternativeOCSPUrls = trustedCertSource.getAlternativeOCSPUrls(trustAnchor);
        currentOCSPSource = Utils.isCollectionNotEmpty(alternativeOCSPUrls) && this.ocspSource instanceof RevocationSourceAlternateUrlsSupport ? new AlternateUrlsSourceAdapter((RevocationSourceAlternateUrlsSupport)((Object)this.ocspSource), alternativeOCSPUrls) : this.ocspSource;
        RevocationSource<CRLToken> currentCRLSource = null;
        List<String> alternativeCRLUrls = trustedCertSource.getAlternativeCRLUrls(trustAnchor);
        currentCRLSource = Utils.isCollectionNotEmpty(alternativeCRLUrls) && this.crlSource instanceof RevocationSourceAlternateUrlsSupport ? new AlternateUrlsSourceAdapter((RevocationSourceAlternateUrlsSupport)((Object)this.crlSource), alternativeCRLUrls) : this.crlSource;
        return new OCSPAndCRLCertificateVerifier(currentCRLSource, currentOCSPSource, this.validationCertificatePool);
    }

    @Override
    public boolean isAllRequiredRevocationDataPresent() {
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (List<CertificateToken> orderedCertChain : orderedCertificateChains.values()) {
            if (this.checkRevocationPresentForCertificateChain(orderedCertChain)) continue;
            return false;
        }
        return true;
    }

    private boolean checkRevocationPresentForCertificateChain(List<CertificateToken> certificates) {
        return this.checkRevocationForCertificateChainAgainstBestSignatureTime(certificates, null);
    }

    private boolean checkRevocationForCertificateChainAgainstBestSignatureTime(List<CertificateToken> certificates, Date bestSignatureTime) {
        for (CertificateToken certificateToken : certificates) {
            if (this.isSelfSignedOrTrusted(certificateToken)) break;
            if (this.isOCSPNoCheckExtension(certificateToken)) continue;
            boolean found = false;
            Date earliestNextUpdate = null;
            for (RevocationToken revocationToken : this.processedRevocations) {
                if (!Utils.areStringsEqual(certificateToken.getDSSIdAsString(), revocationToken.getRelatedCertificateID())) continue;
                if (bestSignatureTime == null || revocationToken.getThisUpdate().after(bestSignatureTime)) {
                    found = true;
                    break;
                }
                if (revocationToken.getNextUpdate() == null || earliestNextUpdate != null && !revocationToken.getNextUpdate().before(earliestNextUpdate)) continue;
                earliestNextUpdate = revocationToken.getNextUpdate();
            }
            if (found) continue;
            if (bestSignatureTime == null) {
                LOG.debug("No revocation data found for certificate : {}", (Object)certificateToken.getDSSIdAsString());
            } else if (earliestNextUpdate != null) {
                LOG.warn("No revocation data found after the best signature time [{}] for the certificate : {}. \nThe nextUpdate available after : [{}]", bestSignatureTime, certificateToken.getDSSIdAsString(), earliestNextUpdate);
            } else {
                LOG.warn("No revocation data found after the best signature time [{}] for the certificate : {}", (Object)bestSignatureTime, (Object)certificateToken.getDSSIdAsString());
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllPOECoveredByRevocationData() {
        for (Map.Entry<CertificateToken, Date> entry : this.lastUsageDates.entrySet()) {
            Date lastUsage = entry.getValue();
            CertificateToken token = entry.getKey();
            if (this.isRevocationDataNotRequired(token)) continue;
            boolean foundValidRevocationDataAfterLastUsage = false;
            Date nextUpdate = null;
            for (RevocationToken revocationToken : this.processedRevocations) {
                if (!Utils.areStringsEqual(token.getDSSIdAsString(), revocationToken.getRelatedCertificateID())) continue;
                Date productionDate = revocationToken.getProductionDate();
                if (productionDate.after(lastUsage)) {
                    foundValidRevocationDataAfterLastUsage = true;
                    break;
                }
                Date currentNextUpdate = revocationToken.getNextUpdate();
                if (nextUpdate != null && (currentNextUpdate == null || !nextUpdate.before(currentNextUpdate))) continue;
                nextUpdate = currentNextUpdate;
            }
            if (foundValidRevocationDataAfterLastUsage) continue;
            LOG.debug("POE {} not covered by a valid revocation data (nextUpdate : {})", (Object)token.getDSSIdAsString(), (Object)nextUpdate);
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllTimestampValid() {
        for (TimestampToken timestampToken : this.processedTimestamps) {
            if (timestampToken.isSignatureValid() && timestampToken.isMessageImprintDataFound().booleanValue() && timestampToken.isMessageImprintDataIntact().booleanValue()) continue;
            LOG.warn("Invalid timestamp detected : {}", (Object)timestampToken.getDSSIdAsString());
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllCertificateValid() {
        for (CertificateToken certificateToken : this.processedCertificates) {
            if (this.isRevocationDataNotRequired(certificateToken)) continue;
            for (RevocationToken revocationToken : this.processedRevocations) {
                if (!Utils.areStringsEqual(certificateToken.getDSSIdAsString(), revocationToken.getRelatedCertificateID()) || Utils.isTrue(revocationToken.getStatus())) continue;
                LOG.debug("Certificate {} is revoked", (Object)certificateToken.getDSSIdAsString());
                return false;
            }
        }
        return true;
    }

    private boolean isRevocationDataNotRequired(CertificateToken certToken) {
        return this.isSelfSignedOrTrusted(certToken) || this.isOCSPNoCheckExtension(certToken);
    }

    private boolean isSelfSignedOrTrusted(CertificateToken certToken) {
        return certToken.isSelfSigned() || this.isTrusted(certToken);
    }

    private boolean isOCSPNoCheckExtension(CertificateToken certToken) {
        return DSSASN1Utils.hasIdPkixOcspNoCheckExtension(certToken);
    }

    private boolean isRevocationDataRefreshNeeded(CertificateToken certToken, List<RevocationToken> revocations) {
        Date lastUsageDate = this.lastUsageDates.get(certToken);
        if (lastUsageDate != null) {
            boolean foundUpdatedRevocationData = false;
            for (RevocationToken revocationToken : revocations) {
                if (lastUsageDate.compareTo(revocationToken.getProductionDate()) >= 0 || RevocationReason.CERTIFICATE_HOLD == revocationToken.getReason()) continue;
                foundUpdatedRevocationData = true;
                break;
            }
            if (!foundUpdatedRevocationData) {
                LOG.debug("Revocation data refresh is needed");
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAtLeastOneRevocationDataPresentAfterBestSignatureTime(CertificateToken signingCertificate) {
        Map<CertificateToken, List<CertificateToken>> orderedCertificateChains = this.getOrderedCertificateChains();
        for (Map.Entry<CertificateToken, List<CertificateToken>> entry : orderedCertificateChains.entrySet()) {
            Date bestSignatureTime;
            CertificateToken firstChainCertificate = entry.getKey();
            Date date = bestSignatureTime = firstChainCertificate.equals(signingCertificate) ? this.getEarliestTimestampTime() : this.lastUsageDates.get(firstChainCertificate);
            if (this.checkRevocationForCertificateChainAgainstBestSignatureTime(entry.getValue(), bestSignatureTime)) continue;
            return false;
        }
        return true;
    }

    private Date getEarliestTimestampTime() {
        Date earliestDate = null;
        for (TimestampToken timestamp : this.getProcessedTimestamps()) {
            if (!timestamp.getTimeStampType().coversSignature()) continue;
            Date timestampTime = timestamp.getCreationDate();
            if (earliestDate != null && !timestampTime.before(earliestDate)) continue;
            earliestDate = timestampTime;
        }
        return earliestDate;
    }

    @Override
    public Set<CertificateToken> getProcessedCertificates() {
        return Collections.unmodifiableSet(this.processedCertificates);
    }

    @Override
    public Map<CertificateToken, Set<CertificateSourceType>> getCertificateSourceTypes() {
        Set<CertificateToken> certs = this.getProcessedCertificates();
        HashMap<CertificateToken, Set<CertificateSourceType>> result = new HashMap<CertificateToken, Set<CertificateSourceType>>();
        for (CertificateToken certificateToken : certs) {
            result.put(certificateToken, this.validationCertificatePool.getSources(certificateToken));
        }
        return result;
    }

    @Override
    public Set<RevocationToken> getProcessedRevocations() {
        return Collections.unmodifiableSet(this.processedRevocations);
    }

    @Override
    public Set<TimestampToken> getProcessedTimestamps() {
        return Collections.unmodifiableSet(this.processedTimestamps);
    }

    private boolean isTrusted(Token token) {
        return token instanceof CertificateToken && this.validationCertificatePool.isTrusted((CertificateToken)token);
    }
}

