/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.SignatureRevocationSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SignatureOCSPSource
extends OfflineOCSPSource
implements SignatureRevocationSource<OCSPToken> {
    private Map<OCSPResponseBinary, OCSPToken> ocspTokenMap = new HashMap<OCSPResponseBinary, OCSPToken>();
    private final List<OCSPToken> revocationValuesOCSPs = new ArrayList<OCSPToken>();
    private final List<OCSPToken> attributeRevocationValuesOCSPs = new ArrayList<OCSPToken>();
    private final List<OCSPToken> timestampValidationDataOCSPs = new ArrayList<OCSPToken>();
    private final List<OCSPToken> dssDictionaryOCSPs = new ArrayList<OCSPToken>();
    private final List<OCSPToken> vriDictionaryOCSPs = new ArrayList<OCSPToken>();
    private final List<OCSPToken> timestampRevocationValuesOCSPs = new ArrayList<OCSPToken>();
    private List<OCSPRef> ocspRefs = new ArrayList<OCSPRef>();
    private transient List<OCSPRef> orphanRevocationRefsOCSPs;
    private Map<OCSPToken, Set<OCSPRef>> revocationRefsMap;

    @Override
    public List<OCSPToken> getRevocationValuesTokens() {
        return this.revocationValuesOCSPs;
    }

    @Override
    public List<OCSPToken> getAttributeRevocationValuesTokens() {
        return this.attributeRevocationValuesOCSPs;
    }

    @Override
    public List<OCSPToken> getTimestampValidationDataTokens() {
        return this.timestampValidationDataOCSPs;
    }

    @Override
    public List<OCSPToken> getDSSDictionaryTokens() {
        return this.dssDictionaryOCSPs;
    }

    @Override
    public List<OCSPToken> getVRIDictionaryTokens() {
        return this.vriDictionaryOCSPs;
    }

    @Override
    public List<OCSPToken> getTimestampRevocationValuesTokens() {
        return this.timestampRevocationValuesOCSPs;
    }

    public List<OCSPRef> getCompleteRevocationRefs() {
        return this.getOCSPRefsByOrigin(RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
    }

    public List<OCSPRef> getAttributeRevocationRefs() {
        return this.getOCSPRefsByOrigin(RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
    }

    public List<OCSPRef> getTimestampRevocationRefs() {
        return this.getOCSPRefsByOrigin(RevocationRefOrigin.TIMESTAMP_REVOCATION_REFS);
    }

    private List<OCSPRef> getOCSPRefsByOrigin(RevocationRefOrigin origin) {
        ArrayList<OCSPRef> revocationRefsOCSPs = new ArrayList<OCSPRef>();
        for (OCSPRef ocspRef : this.ocspRefs) {
            if (!ocspRef.getOrigins().contains((Object)origin)) continue;
            revocationRefsOCSPs.add(ocspRef);
        }
        return revocationRefsOCSPs;
    }

    public List<OCSPToken> getAllOCSPTokens() {
        ArrayList<OCSPToken> ocspTokens = new ArrayList<OCSPToken>();
        ocspTokens.addAll(this.getRevocationValuesTokens());
        ocspTokens.addAll(this.getAttributeRevocationValuesTokens());
        ocspTokens.addAll(this.getTimestampValidationDataTokens());
        ocspTokens.addAll(this.getDSSDictionaryTokens());
        ocspTokens.addAll(this.getVRIDictionaryTokens());
        ocspTokens.addAll(this.getTimestampRevocationValuesTokens());
        return ocspTokens;
    }

    public List<OCSPRef> getAllOCSPReferences() {
        return this.ocspRefs;
    }

    public Map<OCSPResponseBinary, OCSPToken> getOCSPTokenMap() {
        return this.ocspTokenMap;
    }

    public void populateOCSPRevocationTokenLists(SignatureOCSPSource signatureOCSPSource) {
        for (Map.Entry<OCSPResponseBinary, OCSPToken> entry : signatureOCSPSource.getOCSPTokenMap().entrySet()) {
            this.storeOCSPToken(entry);
        }
    }

    private void storeOCSPToken(Map.Entry<OCSPResponseBinary, OCSPToken> responseTokenEntry) {
        this.storeOCSPToken(responseTokenEntry.getKey(), responseTokenEntry.getValue());
    }

    @Override
    protected void storeOCSPToken(OCSPResponseBinary ocspResponse, OCSPToken ocspToken) {
        if (this.getOCSPResponsesList().contains(ocspResponse) && !this.ocspTokenMap.containsKey(ocspResponse)) {
            this.ocspTokenMap.put(ocspResponse, ocspToken);
            block8: for (RevocationOrigin origin : this.getRevocationOrigins(ocspResponse)) {
                switch (origin) {
                    case REVOCATION_VALUES: {
                        this.revocationValuesOCSPs.add(ocspToken);
                        continue block8;
                    }
                    case ATTRIBUTE_REVOCATION_VALUES: {
                        this.attributeRevocationValuesOCSPs.add(ocspToken);
                        continue block8;
                    }
                    case TIMESTAMP_VALIDATION_DATA: {
                        this.timestampValidationDataOCSPs.add(ocspToken);
                        continue block8;
                    }
                    case DSS_DICTIONARY: {
                        this.dssDictionaryOCSPs.add(ocspToken);
                        continue block8;
                    }
                    case VRI_DICTIONARY: {
                        this.vriDictionaryOCSPs.add(ocspToken);
                        continue block8;
                    }
                    case TIMESTAMP_REVOCATION_VALUES: {
                        this.timestampRevocationValuesOCSPs.add(ocspToken);
                        continue block8;
                    }
                }
                throw new DSSException(String.format("The given RevocationOrigin [%s] is not supported for OCSPToken object in the SignatureOCSPSource", new Object[]{origin}));
            }
        }
    }

    protected void addReference(OCSPRef ocspRef) {
        for (RevocationRefOrigin origin : ocspRef.getOrigins()) {
            this.addReference(ocspRef, origin);
        }
    }

    protected void addReference(OCSPRef ocspRef, RevocationRefOrigin origin) {
        int index = this.ocspRefs.indexOf(ocspRef);
        if (index == -1) {
            this.ocspRefs.add(ocspRef);
        } else {
            OCSPRef storedOCSPRef = this.ocspRefs.get(index);
            storedOCSPRef.addOrigin(origin);
        }
    }

    public List<OCSPRef> getReferencesForOCSPIdentifier(OCSPResponseBinary ocspResponse) {
        ArrayList<OCSPRef> relatedRefs = new ArrayList<OCSPRef>();
        for (OCSPRef ocspRef : this.getAllOCSPReferences()) {
            byte[] digestValue = ocspResponse.getDigestValue(ocspRef.getDigest().getAlgorithm());
            if (!Arrays.equals(ocspRef.getDigest().getValue(), digestValue)) continue;
            relatedRefs.add(ocspRef);
        }
        return relatedRefs;
    }

    public OCSPRef getOCSPRefByDigest(Digest digest) {
        for (OCSPRef ocspRef : this.getAllOCSPReferences()) {
            if (!digest.equals(ocspRef.getDigest())) continue;
            return ocspRef;
        }
        return null;
    }

    public List<OCSPRef> getOrphanOCSPRefs() {
        if (this.orphanRevocationRefsOCSPs == null) {
            this.orphanRevocationRefsOCSPs = new ArrayList<OCSPRef>();
            for (OCSPRef ocspRef : this.getAllOCSPReferences()) {
                if (this.getIdentifier(ocspRef) != null) continue;
                this.orphanRevocationRefsOCSPs.add(ocspRef);
            }
        }
        return this.orphanRevocationRefsOCSPs;
    }

    public List<OCSPToken> findTokensFromRefs(List<OCSPRef> revocationRefs) {
        if (Utils.isMapEmpty(this.revocationRefsMap)) {
            this.collectRevocationRefsMap();
        }
        ArrayList<OCSPToken> tokensFromRefs = new ArrayList<OCSPToken>();
        block0: for (Map.Entry<OCSPToken, Set<OCSPRef>> revocationMapEntry : this.revocationRefsMap.entrySet()) {
            for (OCSPRef tokenRevocationRef : revocationMapEntry.getValue()) {
                if (!revocationRefs.contains(tokenRevocationRef)) continue;
                tokensFromRefs.add(revocationMapEntry.getKey());
                continue block0;
            }
        }
        return tokensFromRefs;
    }

    public Set<OCSPRef> findRefsForRevocationToken(OCSPToken revocationToken) {
        Set<OCSPRef> revocationRefs;
        if (Utils.isMapEmpty(this.revocationRefsMap)) {
            this.collectRevocationRefsMap();
        }
        if ((revocationRefs = this.revocationRefsMap.get(revocationToken)) != null) {
            return revocationRefs;
        }
        return Collections.emptySet();
    }

    private void collectRevocationRefsMap() {
        this.revocationRefsMap = new HashMap<OCSPToken, Set<OCSPRef>>();
        for (OCSPToken revocationToken : this.getAllOCSPTokens()) {
            for (OCSPRef ocspRef : this.getAllOCSPReferences()) {
                if (ocspRef.getDigest() != null) {
                    if (!Arrays.equals(ocspRef.getDigest().getValue(), revocationToken.getDigest(ocspRef.getDigest().getAlgorithm()))) continue;
                    this.addReferenceToMap(revocationToken, ocspRef);
                    continue;
                }
                if (!ocspRef.getProducedAt().equals(revocationToken.getProductionDate())) continue;
                if (ocspRef.getResponderId().getName() != null && ocspRef.getResponderId().getName().equals(revocationToken.getIssuerX500Principal().getName())) {
                    this.addReferenceToMap(revocationToken, ocspRef);
                    continue;
                }
                if (ocspRef.getResponderId().getKey() == null || !Arrays.equals(ocspRef.getResponderId().getKey(), DSSASN1Utils.computeSkiFromCertPublicKey(revocationToken.getPublicKeyOfTheSigner()))) continue;
                this.addReferenceToMap(revocationToken, ocspRef);
            }
        }
    }

    private void addReferenceToMap(OCSPToken revocationToken, OCSPRef reference) {
        Set<OCSPRef> ocspRefs = this.revocationRefsMap.get(revocationToken);
        if (ocspRefs == null) {
            ocspRefs = new HashSet<OCSPRef>();
            this.revocationRefsMap.put(revocationToken, ocspRefs);
        }
        ocspRefs.add(reference);
    }
}

