/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class SignatureIdentifier
extends Identifier {
    private static final long serialVersionUID = -6700888325973167656L;

    public static SignatureIdentifier buildSignatureIdentifier(Date signingTime, TokenIdentifier tokenIdentifier) {
        return SignatureIdentifier.buildSignatureIdentifier(signingTime, tokenIdentifier, null);
    }

    public static SignatureIdentifier buildSignatureIdentifier(Date signingTime, TokenIdentifier tokenIdentifier, String customIdentifier) {
        return SignatureIdentifier.buildSignatureIdentifier(signingTime, tokenIdentifier, null, customIdentifier);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static SignatureIdentifier buildSignatureIdentifier(Date signingTime, TokenIdentifier tokenIdentifier, Integer customInteger, String ... stringIdentifiers) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            SignatureIdentifier signatureIdentifier;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                if (signingTime != null) {
                    dos.writeLong(signingTime.getTime());
                }
                if (tokenIdentifier != null) {
                    dos.writeChars(tokenIdentifier.asXmlId());
                }
                if (customInteger != null) {
                    dos.writeInt(customInteger);
                }
                if (stringIdentifiers != null) {
                    for (String str : stringIdentifiers) {
                        if (str == null) continue;
                        dos.writeChars(str);
                    }
                }
                dos.flush();
                signatureIdentifier = new SignatureIdentifier(baos.toByteArray());
            }
            return signatureIdentifier;
        }
        catch (IOException e) {
            throw new DSSException(e);
        }
    }

    SignatureIdentifier(byte[] bytes) {
        super(bytes);
    }
}

