/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPTokenUtils;
import eu.europa.esig.dss.validation.CertificateStatusVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPCertificateVerifier
implements CertificateStatusVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPCertificateVerifier.class);
    private final RevocationSource<OCSPToken> ocspSource;
    private final CertificatePool validationCertPool;

    public OCSPCertificateVerifier(RevocationSource<OCSPToken> ocspSource, CertificatePool validationCertPool) {
        this.ocspSource = ocspSource;
        this.validationCertPool = validationCertPool;
    }

    @Override
    public RevocationToken check(CertificateToken toCheckToken) {
        if (this.ocspSource == null) {
            LOG.debug("OCSPSource null");
            return null;
        }
        CertificateToken issuerToken = this.validationCertPool.getIssuer(toCheckToken);
        if (issuerToken == null) {
            LOG.debug("Issuer is null");
            return null;
        }
        try {
            OCSPToken ocspToken = this.ocspSource.getRevocationToken(toCheckToken, issuerToken);
            if (ocspToken == null) {
                LOG.debug("{} : No matching OCSP response found for {}", (Object)this.ocspSource.getClass().getSimpleName(), (Object)toCheckToken.getDSSIdAsString());
            } else {
                OCSPTokenUtils.checkTokenValidity(ocspToken, this.validationCertPool);
            }
            return ocspToken;
        }
        catch (DSSException e) {
            LOG.error("OCSP DSS Exception: " + e.getMessage(), e);
            return null;
        }
    }
}

