/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.validation.ManifestEntry;
import java.util.ArrayList;
import java.util.List;

public class ManifestFile {
    private DSSDocument document;
    private String signatureFilename;
    private List<ManifestEntry> entries;
    private boolean archiveManifest;

    public void setDocument(DSSDocument document) {
        this.document = document;
    }

    public String getFilename() {
        return this.document.getName();
    }

    public String getSignatureFilename() {
        return this.signatureFilename;
    }

    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    public String getDigestBase64String(DigestAlgorithm digestAlgorithm) {
        return this.document.getDigest(digestAlgorithm);
    }

    public List<ManifestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<ManifestEntry>();
        }
        return this.entries;
    }

    public void setEntries(List<ManifestEntry> entries) {
        this.entries = entries;
    }

    public boolean isArchiveManifest() {
        return this.archiveManifest;
    }

    public void setArchiveManifest(boolean archiveManifest) {
        this.archiveManifest = archiveManifest;
    }
}

