/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.validation.SignatureOCSPSource;

public class ListOCSPSource
extends SignatureOCSPSource {
    public ListOCSPSource() {
    }

    public ListOCSPSource(OfflineOCSPSource ocspSource) {
        this.addAll(ocspSource);
    }

    @Override
    public void appendContainedOCSPResponses() {
    }

    public void addAll(OfflineOCSPSource offlineOCSPSource) {
        for (OCSPResponseBinary ocspResponse : offlineOCSPSource.getOCSPResponsesList()) {
            for (RevocationOrigin origin : offlineOCSPSource.getRevocationOrigins(ocspResponse)) {
                this.addOCSPResponse(ocspResponse, origin);
            }
        }
        if (offlineOCSPSource instanceof SignatureOCSPSource) {
            SignatureOCSPSource signatureOCSPSource = (SignatureOCSPSource)offlineOCSPSource;
            for (OCSPRef ocspRef : signatureOCSPSource.getAllOCSPReferences()) {
                this.addReference(ocspRef);
            }
        }
    }
}

