/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDistinguishedName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundCertificates;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundRevocations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlManifestFile;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPDFSignatureDictionary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlPolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocationRef;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureDigestReference;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureProductionPlace;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerDocumentRepresentations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlStructuralValidation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedServiceProvider;
import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.OrphanTokenType;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.tsl.Condition;
import eu.europa.esig.dss.spi.tsl.ServiceInfo;
import eu.europa.esig.dss.spi.tsl.ServiceInfoStatus;
import eu.europa.esig.dss.spi.tsl.TLInfo;
import eu.europa.esig.dss.spi.tsl.TrustedListsCertificateSource;
import eu.europa.esig.dss.spi.x509.CertificatePolicy;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DSSPKUtils;
import eu.europa.esig.dss.validation.IssuerSerialInfo;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.OidRepository;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.validation.policy.BasicASNSignaturePolicyValidator;
import eu.europa.esig.dss.validation.policy.SignaturePolicyValidator;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticDataBuilder.class);
    private DSSDocument signedDocument;
    private ContainerInfo containerInfo;
    private List<AdvancedSignature> signatures;
    private Set<CertificateToken> usedCertificates;
    private Map<CertificateToken, Set<CertificateSourceType>> certificateSourceTypes;
    private Set<RevocationToken> usedRevocations;
    private CommonTrustedCertificateSource trustedCertSource;
    private Date validationDate;
    private boolean includeRawCertificateTokens = false;
    private boolean includeRawRevocationData = false;
    private boolean includeRawTimestampTokens = false;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private Map<String, XmlCertificate> xmlCerts = new HashMap<String, XmlCertificate>();
    private Map<String, XmlRevocation> xmlRevocations = new HashMap<String, XmlRevocation>();
    private Map<String, XmlSignature> xmlSignatures = new HashMap<String, XmlSignature>();
    private Map<String, XmlTimestamp> xmlTimestamps = new HashMap<String, XmlTimestamp>();
    private Map<String, XmlSignerData> xmlSignedData = new HashMap<String, XmlSignerData>();
    private Map<String, XmlOrphanToken> xmlOrphanTokens = new HashMap<String, XmlOrphanToken>();
    private Map<String, List<CertificateRef>> certificateRefsMap = new HashMap<String, List<CertificateRef>>();
    private Map<String, List<RevocationRef>> revocationRefsMap = new HashMap<String, List<RevocationRef>>();

    public DiagnosticDataBuilder document(DSSDocument signedDocument) {
        this.signedDocument = signedDocument;
        return this;
    }

    public DiagnosticDataBuilder containerInfo(ContainerInfo containerInfo) {
        this.containerInfo = containerInfo;
        return this;
    }

    public DiagnosticDataBuilder foundSignatures(List<AdvancedSignature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public DiagnosticDataBuilder usedCertificates(Set<CertificateToken> usedCertificates) {
        this.usedCertificates = usedCertificates;
        return this;
    }

    public DiagnosticDataBuilder certificateSourceTypes(Map<CertificateToken, Set<CertificateSourceType>> certificateSourceTypes) {
        this.certificateSourceTypes = certificateSourceTypes;
        return this;
    }

    public DiagnosticDataBuilder usedRevocations(Set<RevocationToken> usedRevocations) {
        this.usedRevocations = usedRevocations;
        return this;
    }

    public DiagnosticDataBuilder includeRawCertificateTokens(boolean includeRawCertificateTokens) {
        this.includeRawCertificateTokens = includeRawCertificateTokens;
        return this;
    }

    public DiagnosticDataBuilder includeRawRevocationData(boolean includeRawRevocationData) {
        this.includeRawRevocationData = includeRawRevocationData;
        return this;
    }

    public DiagnosticDataBuilder includeRawTimestampTokens(boolean includeRawTimestampTokens) {
        this.includeRawTimestampTokens = includeRawTimestampTokens;
        return this;
    }

    public DiagnosticDataBuilder setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.defaultDigestAlgorithm = digestAlgorithm;
        return this;
    }

    public DiagnosticDataBuilder trustedCertificateSource(CertificateSource trustedCertSource) {
        if (trustedCertSource instanceof CommonTrustedCertificateSource) {
            this.trustedCertSource = (CommonTrustedCertificateSource)trustedCertSource;
        }
        return this;
    }

    public DiagnosticDataBuilder validationDate(Date validationDate) {
        this.validationDate = validationDate;
        return this;
    }

    public XmlDiagnosticData build() {
        XmlDiagnosticData diagnosticData = new XmlDiagnosticData();
        if (this.signedDocument != null) {
            diagnosticData.setDocumentName(this.removeSpecialCharsForXml(this.signedDocument.getName()));
        }
        diagnosticData.setValidationDate(this.validationDate);
        diagnosticData.setContainerInfo(this.getXmlContainerInfo());
        Collection<XmlCertificate> xmlCertificates = this.buildXmlCertificates();
        diagnosticData.getUsedCertificates().addAll(xmlCertificates);
        Collection<XmlRevocation> xmlRevocations = this.buildXmlRevocations();
        diagnosticData.getUsedRevocations().addAll(xmlRevocations);
        if (Utils.isCollectionNotEmpty(this.signatures)) {
            Collection<XmlSignerData> xmlSignerData = this.buildXmlSignerData(this.signatures);
            diagnosticData.getOriginalDocuments().addAll(xmlSignerData);
            Collection<XmlSignature> xmlSignatures = this.buildXmlSignatures(this.signatures);
            diagnosticData.getSignatures().addAll(xmlSignatures);
            Collection<XmlTimestamp> XmlTimestamps = this.buildXmlTimestamps(this.signatures);
            diagnosticData.getUsedTimestamps().addAll(XmlTimestamps);
        }
        if (Utils.isMapNotEmpty(this.xmlOrphanTokens)) {
            diagnosticData.getOrphanTokens().addAll(this.xmlOrphanTokens.values());
        }
        if (this.trustedCertSource instanceof TrustedListsCertificateSource) {
            TrustedListsCertificateSource tlCS = (TrustedListsCertificateSource)this.trustedCertSource;
            Collection<XmlTrustedList> xmlTrustedLists = this.buildXmlTrustedLists(tlCS);
            diagnosticData.getTrustedLists().addAll(xmlTrustedLists);
            TLInfo lotlInfo = tlCS.getLotlInfo();
            if (Utils.isCollectionNotEmpty(xmlTrustedLists) && lotlInfo != null) {
                diagnosticData.setListOfTrustedLists(this.getXmlTrustedList("LOTL", lotlInfo));
            }
            for (XmlCertificate xmlCert : diagnosticData.getUsedCertificates()) {
                xmlCert.setTrustedServiceProviders(this.getXmlTrustedServiceProviders(this.getCertificateToken(xmlCert.getId())));
            }
        }
        return diagnosticData;
    }

    private Collection<XmlCertificate> buildXmlCertificates() {
        if (Utils.isCollectionNotEmpty(this.usedCertificates)) {
            for (CertificateToken certificateToken : this.usedCertificates) {
                XmlCertificate currentXmlCet = this.buildDetachedXmlCertificate(certificateToken);
                this.xmlCerts.put(certificateToken.getDSSIdAsString(), currentXmlCet);
            }
            for (CertificateToken certificateToken : this.usedCertificates) {
                XmlCertificate xmlCertificate = this.xmlCerts.get(certificateToken.getDSSIdAsString());
                xmlCertificate.setSigningCertificate(this.getXmlSigningCertificate(certificateToken.getPublicKeyOfTheSigner()));
                xmlCertificate.setCertificateChain(this.getXmlForCertificateChain(certificateToken.getPublicKeyOfTheSigner()));
            }
        }
        return this.xmlCerts.values();
    }

    private Collection<XmlRevocation> buildXmlRevocations() {
        if (Utils.isCollectionNotEmpty(this.usedRevocations)) {
            for (RevocationToken revocationToken : this.usedRevocations) {
                if (this.xmlRevocations.containsKey(revocationToken.getDSSIdAsString())) continue;
                XmlRevocation currentXmlRevocation = this.buildDetachedXmlRevocation(revocationToken);
                currentXmlRevocation.setSigningCertificate(this.getXmlSigningCertificate(revocationToken.getPublicKeyOfTheSigner()));
                currentXmlRevocation.setCertificateChain(this.getXmlForCertificateChain(revocationToken.getPublicKeyOfTheSigner()));
                this.xmlRevocations.put(revocationToken.getDSSIdAsString(), currentXmlRevocation);
            }
            for (CertificateToken certificateToken : this.usedCertificates) {
                XmlCertificate xmlCertificate = this.xmlCerts.get(certificateToken.getDSSIdAsString());
                Set<RevocationToken> revocationsForCert = this.getRevocationsForCert(certificateToken);
                for (RevocationToken revocationToken : revocationsForCert) {
                    XmlRevocation xmlRevocation = this.xmlRevocations.get(revocationToken.getDSSIdAsString());
                    XmlCertificateRevocation xmlCertificateRevocation = new XmlCertificateRevocation();
                    xmlCertificateRevocation.setRevocation(xmlRevocation);
                    Boolean revocationTokenStatus = revocationToken.getStatus();
                    xmlCertificateRevocation.setStatus(revocationTokenStatus == null ? false : revocationTokenStatus);
                    xmlCertificateRevocation.setRevocationDate(revocationToken.getRevocationDate());
                    xmlCertificateRevocation.setReason(revocationToken.getReason());
                    xmlCertificate.getRevocations().add(xmlCertificateRevocation);
                }
            }
        }
        return this.xmlRevocations.values();
    }

    private Collection<XmlSignerData> buildXmlSignerData(List<AdvancedSignature> signatures) {
        ArrayList<String> originalDocumentIds = new ArrayList<String>();
        for (AdvancedSignature advancedSignature : signatures) {
            for (SignatureScope signatureScope : advancedSignature.getSignatureScopes()) {
                if (originalDocumentIds.contains(signatureScope.getDSSIdAsString())) continue;
                XmlSignerData signedData = this.getXmlSignerData(signatureScope);
                this.xmlSignedData.put(signatureScope.getDSSIdAsString(), signedData);
                originalDocumentIds.add(signatureScope.getDSSIdAsString());
            }
        }
        return this.xmlSignedData.values();
    }

    private Collection<XmlSignature> buildXmlSignatures(List<AdvancedSignature> signatures) {
        ArrayList<XmlSignature> builtSignatures = new ArrayList<XmlSignature>();
        for (AdvancedSignature advancedSignature : signatures) {
            XmlSignature currentXmlSignature = this.buildDetachedXmlSignature(advancedSignature);
            this.xmlSignatures.put(advancedSignature.getId(), currentXmlSignature);
            builtSignatures.add(currentXmlSignature);
        }
        return builtSignatures;
    }

    private Collection<XmlTimestamp> buildXmlTimestamps(List<AdvancedSignature> signatures) {
        ArrayList<XmlTimestamp> builtTimestamps = new ArrayList<XmlTimestamp>();
        for (AdvancedSignature advancedSignature : signatures) {
            XmlSignature currentSignature = this.xmlSignatures.get(advancedSignature.getId());
            for (XmlTimestamp xmlTimestamp : this.getXmlTimestamps(advancedSignature)) {
                this.addXmlTimestampToList(builtTimestamps, xmlTimestamp);
            }
            currentSignature.setFoundTimestamps(this.getXmlFoundTimestamps(advancedSignature));
            AdvancedSignature masterSignature = advancedSignature.getMasterSignature();
            if (masterSignature == null) continue;
            XmlSignature xmlMasterSignature = this.xmlSignatures.get(masterSignature.getId());
            currentSignature.setCounterSignature(true);
            currentSignature.setParent(xmlMasterSignature);
        }
        return builtTimestamps;
    }

    private Collection<XmlTrustedList> buildXmlTrustedLists(TrustedListsCertificateSource tlCS) {
        ArrayList<XmlTrustedList> trustedLists = new ArrayList<XmlTrustedList>();
        HashSet<String> countryCodes = new HashSet<String>();
        for (CertificateToken certificateToken : this.usedCertificates) {
            Set<ServiceInfo> associatedTSPS = this.trustedCertSource.getTrustServices(certificateToken);
            if (!Utils.isCollectionNotEmpty(associatedTSPS)) continue;
            for (ServiceInfo serviceInfo : associatedTSPS) {
                countryCodes.add(serviceInfo.getTlCountryCode());
            }
        }
        for (String countryCode : countryCodes) {
            TLInfo tlInfo = tlCS.getTlInfo(countryCode);
            if (tlInfo == null) continue;
            trustedLists.add(this.getXmlTrustedList(countryCode, tlInfo));
        }
        return trustedLists;
    }

    private XmlTrustedList getXmlTrustedList(String countryCode, TLInfo tlInfo) {
        if (tlInfo != null) {
            XmlTrustedList result = new XmlTrustedList();
            result.setCountryCode(tlInfo.getCountryCode());
            result.setUrl(tlInfo.getUrl());
            result.setIssueDate(tlInfo.getIssueDate());
            result.setNextUpdate(tlInfo.getNextUpdate());
            result.setLastLoading(tlInfo.getLastLoading());
            result.setSequenceNumber(tlInfo.getSequenceNumber());
            result.setVersion(tlInfo.getVersion());
            result.setWellSigned(tlInfo.isWellSigned());
            return result;
        }
        LOG.warn("Not info found for country {}", (Object)countryCode);
        return null;
    }

    private XmlContainerInfo getXmlContainerInfo() {
        if (this.containerInfo != null) {
            XmlContainerInfo xmlContainerInfo = new XmlContainerInfo();
            xmlContainerInfo.setContainerType(this.containerInfo.getContainerType().getReadable());
            String zipComment = this.containerInfo.getZipComment();
            if (Utils.isStringNotBlank(zipComment)) {
                xmlContainerInfo.setZipComment(zipComment);
            }
            xmlContainerInfo.setMimeTypeFilePresent(this.containerInfo.isMimeTypeFilePresent());
            xmlContainerInfo.setMimeTypeContent(this.containerInfo.getMimeTypeContent());
            xmlContainerInfo.setContentFiles(this.containerInfo.getSignedDocumentFilenames());
            xmlContainerInfo.setManifestFiles(this.getXmlManifests(this.containerInfo.getManifestFiles()));
            return xmlContainerInfo;
        }
        return null;
    }

    private List<XmlManifestFile> getXmlManifests(List<ManifestFile> manifestFiles) {
        if (Utils.isCollectionNotEmpty(manifestFiles)) {
            ArrayList<XmlManifestFile> xmlManifests = new ArrayList<XmlManifestFile>();
            for (ManifestFile manifestFile : manifestFiles) {
                XmlManifestFile xmlManifest = new XmlManifestFile();
                xmlManifest.setFilename(manifestFile.getFilename());
                xmlManifest.setSignatureFilename(manifestFile.getSignatureFilename());
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    xmlManifest.getEntries().add(entry.getFileName());
                }
                xmlManifests.add(xmlManifest);
            }
            return xmlManifests;
        }
        return null;
    }

    private XmlSignature buildDetachedXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = new XmlSignature();
        xmlSignature.setSignatureFilename(this.removeSpecialCharsForXml(signature.getSignatureFilename()));
        xmlSignature.setId(signature.getId());
        xmlSignature.setDAIdentifier(signature.getDAIdentifier());
        xmlSignature.setDateTime(signature.getSigningTime());
        xmlSignature.setStructuralValidation(this.getXmlStructuralValidation(signature));
        xmlSignature.setSignatureFormat(signature.getDataFoundUpToLevel());
        xmlSignature.setSignatureProductionPlace(this.getXmlSignatureProductionPlace(signature.getSignatureProductionPlace()));
        xmlSignature.setCommitmentTypeIndication(this.getXmlCommitmentTypeIndication(signature.getCommitmentTypeIndication()));
        xmlSignature.getSignerRole().addAll(this.getXmlSignerRoles(signature.getSignerRoles()));
        xmlSignature.setContentType(signature.getContentType());
        xmlSignature.setMimeType(signature.getMimeType());
        xmlSignature.setContentIdentifier(signature.getContentIdentifier());
        xmlSignature.setContentHints(signature.getContentHints());
        CandidatesForSigningCertificate candidatesForSigningCertificate = signature.getCandidatesForSigningCertificate();
        CertificateValidity theCertificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        PublicKey signingCertificatePublicKey = null;
        if (theCertificateValidity != null) {
            xmlSignature.setSigningCertificate(this.getXmlSigningCertificate(theCertificateValidity));
            signingCertificatePublicKey = theCertificateValidity.getPublicKey();
            xmlSignature.setCertificateChain(this.getXmlForCertificateChain(signingCertificatePublicKey));
        }
        xmlSignature.setBasicSignature(this.getXmlBasicSignature(signature, signingCertificatePublicKey));
        xmlSignature.setDigestMatchers(this.getXmlDigestMatchers(signature));
        xmlSignature.setPolicy(this.getXmlPolicy(signature));
        xmlSignature.setPDFSignatureDictionary(this.getXmlPDFSignatureDictionary(signature));
        xmlSignature.setSignatureDigestReference(this.getXmlSignatureDigestReference(signature));
        xmlSignature.setSignerDocumentRepresentations(this.getXmlSignerDocumentRepresentations(signature));
        xmlSignature.setFoundRevocations(this.getXmlFoundRevocations(signature));
        xmlSignature.setFoundCertificates(this.getXmlFoundCertificates(signature));
        xmlSignature.setSignatureScopes(this.getXmlSignatureScopes(signature.getSignatureScopes()));
        xmlSignature.setSignatureValue(signature.getSignatureValue());
        return xmlSignature;
    }

    private XmlPDFSignatureDictionary getXmlPDFSignatureDictionary(AdvancedSignature signature) {
        SignatureForm signatureForm = signature.getSignatureForm();
        if (SignatureForm.PAdES == signatureForm || SignatureForm.PKCS7 == signatureForm) {
            XmlPDFSignatureDictionary pdfSignatureDictionary = new XmlPDFSignatureDictionary();
            pdfSignatureDictionary.setSignatureFieldName(this.emptyToNull(signature.getSignatureFieldName()));
            pdfSignatureDictionary.setSignerName(this.emptyToNull(signature.getSignerName()));
            pdfSignatureDictionary.setFilter(this.emptyToNull(signature.getFilter()));
            pdfSignatureDictionary.setSubFilter(this.emptyToNull(signature.getSubFilter()));
            pdfSignatureDictionary.setContactInfo(this.emptyToNull(signature.getContactInfo()));
            pdfSignatureDictionary.setReason(this.emptyToNull(signature.getReason()));
            pdfSignatureDictionary.getSignatureByteRange().addAll(this.intArrayToBigIntegerList(signature.getSignatureByteRange()));
            return pdfSignatureDictionary;
        }
        return null;
    }

    public List<BigInteger> intArrayToBigIntegerList(int[] v) {
        ArrayList<BigInteger> bi = new ArrayList<BigInteger>();
        for (int i : v) {
            bi.add(BigInteger.valueOf(i));
        }
        return bi;
    }

    private XmlSignatureDigestReference getXmlSignatureDigestReference(AdvancedSignature signature) {
        SignatureDigestReference signatureDigestReference = signature.getSignatureDigestReference(this.defaultDigestAlgorithm);
        if (signatureDigestReference != null) {
            XmlSignatureDigestReference xmlDigestReference = new XmlSignatureDigestReference();
            xmlDigestReference.setCanonicalizationMethod(signatureDigestReference.getCanonicalizationMethod());
            xmlDigestReference.setDigestMethod(signatureDigestReference.getDigestAlgorithm());
            xmlDigestReference.setDigestValue(signatureDigestReference.getDigestValue());
            return xmlDigestReference;
        }
        return null;
    }

    private XmlSignerDocumentRepresentations getXmlSignerDocumentRepresentations(AdvancedSignature signature) {
        if (signature.getDetachedContents() == null) {
            return null;
        }
        XmlSignerDocumentRepresentations signerDocumentRepresentation = new XmlSignerDocumentRepresentations();
        signerDocumentRepresentation.setDocHashOnly(signature.isDocHashOnlyValidation());
        signerDocumentRepresentation.setHashOnly(signature.isHashOnlyValidation());
        return signerDocumentRepresentation;
    }

    private XmlSignerData getXmlSignerData(SignatureScope signatureScope) {
        XmlSignerData xmlSignedData = new XmlSignerData();
        xmlSignedData.setId(signatureScope.getDSSIdAsString());
        xmlSignedData.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(signatureScope.getDigest().getAlgorithm(), signatureScope.getDigest().getValue()));
        xmlSignedData.setReferencedName(signatureScope.getName());
        return xmlSignedData;
    }

    private XmlStructuralValidation getXmlStructuralValidation(AdvancedSignature signature) {
        String structureValidationResult = signature.getStructureValidationResult();
        XmlStructuralValidation xmlStructuralValidation = new XmlStructuralValidation();
        xmlStructuralValidation.setValid(Utils.isStringEmpty(structureValidationResult));
        if (Utils.isStringNotEmpty(structureValidationResult)) {
            xmlStructuralValidation.setMessage(structureValidationResult);
        }
        return xmlStructuralValidation;
    }

    private String removeSpecialCharsForXml(String text) {
        if (Utils.isStringNotEmpty(text)) {
            return text.replaceAll("&", "");
        }
        return "";
    }

    private void addXmlTimestampToList(List<XmlTimestamp> timestampList, XmlTimestamp timestampToAdd) {
        boolean contains = false;
        for (XmlTimestamp timestamp : timestampList) {
            if (!timestamp.getId().equals(timestampToAdd.getId())) continue;
            List<XmlTimestampedObject> timestampedObjects = timestampToAdd.getTimestampedObjects();
            for (XmlTimestampedObject timestampedObject : timestampedObjects) {
                if (this.isTimestampContainsReference(timestamp, timestampedObject)) continue;
                timestamp.getTimestampedObjects().add(timestampedObject);
            }
            contains = true;
        }
        if (!contains) {
            timestampList.add(timestampToAdd);
        }
    }

    private boolean isTimestampContainsReference(XmlTimestamp timestamp, XmlTimestampedObject timestampedObject) {
        for (XmlTimestampedObject oldObject : timestamp.getTimestampedObjects()) {
            if (!timestampedObject.getToken().getId().equals(oldObject.getToken().getId())) continue;
            return true;
        }
        return false;
    }

    private XmlRevocation buildDetachedXmlRevocation(RevocationToken revocationToken) {
        XmlRevocation xmlRevocation = new XmlRevocation();
        xmlRevocation.setId(revocationToken.getDSSIdAsString());
        if (this.isInternalOrigin(revocationToken)) {
            xmlRevocation.setOrigin(RevocationOrigin.SIGNATURE);
        } else {
            xmlRevocation.setOrigin(revocationToken.getFirstOrigin());
        }
        xmlRevocation.setType(revocationToken.getRevocationType());
        xmlRevocation.setProductionDate(revocationToken.getProductionDate());
        xmlRevocation.setThisUpdate(revocationToken.getThisUpdate());
        xmlRevocation.setNextUpdate(revocationToken.getNextUpdate());
        xmlRevocation.setExpiredCertsOnCRL(revocationToken.getExpiredCertsOnCRL());
        xmlRevocation.setArchiveCutOff(revocationToken.getArchiveCutOff());
        String sourceURL = revocationToken.getSourceURL();
        if (Utils.isStringNotEmpty(sourceURL)) {
            xmlRevocation.setSourceAddress(sourceURL);
        }
        xmlRevocation.setBasicSignature(this.getXmlBasicSignature(revocationToken));
        xmlRevocation.setSigningCertificate(this.getXmlSigningCertificate(revocationToken.getPublicKeyOfTheSigner()));
        xmlRevocation.setCertificateChain(this.getXmlForCertificateChain(revocationToken.getPublicKeyOfTheSigner()));
        xmlRevocation.setCertHashExtensionPresent(revocationToken.isCertHashPresent());
        xmlRevocation.setCertHashExtensionMatch(revocationToken.isCertHashMatch());
        if (this.includeRawRevocationData) {
            xmlRevocation.setBase64Encoded(revocationToken.getEncoded());
        } else {
            byte[] revocationDigest = revocationToken.getDigest(this.defaultDigestAlgorithm);
            xmlRevocation.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, revocationDigest));
        }
        return xmlRevocation;
    }

    private boolean isInternalOrigin(RevocationToken revocationToken) {
        for (RevocationOrigin origin : revocationToken.getOrigins()) {
            if (!origin.isInternalOrigin()) continue;
            return true;
        }
        return false;
    }

    private List<XmlChainItem> getXmlForCertificateChain(PublicKey certPubKey) {
        if (certPubKey != null) {
            ArrayList<XmlChainItem> certChainTokens = new ArrayList<XmlChainItem>();
            HashSet<CertificateToken> processedTokens = new HashSet<CertificateToken>();
            CertificateToken issuerToken = this.getCertificateByPubKey(certPubKey);
            while (issuerToken != null) {
                certChainTokens.add(this.getXmlChainItem(issuerToken));
                if (issuerToken.isSelfSigned() || processedTokens.contains(issuerToken)) break;
                processedTokens.add(issuerToken);
                issuerToken = this.getCertificateByPubKey(issuerToken.getPublicKeyOfTheSigner());
            }
            return certChainTokens;
        }
        return null;
    }

    private boolean isTrusted(CertificateToken cert) {
        return this.trustedCertSource != null && this.trustedCertSource.isTrusted(cert);
    }

    private XmlChainItem getXmlChainItem(CertificateToken token) {
        XmlChainItem chainItem = new XmlChainItem();
        chainItem.setCertificate(this.xmlCerts.get(token.getDSSIdAsString()));
        return chainItem;
    }

    private XmlSigningCertificate getXmlSigningCertificate(PublicKey certPubKey) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken certificateByPubKey = this.getCertificateByPubKey(certPubKey);
        if (certificateByPubKey != null) {
            xmlSignCertType.setCertificate(this.xmlCerts.get(certificateByPubKey.getDSSIdAsString()));
        } else if (certPubKey != null) {
            xmlSignCertType.setPublicKey(certPubKey.getEncoded());
        } else {
            return null;
        }
        return xmlSignCertType;
    }

    private CertificateToken getCertificateByPubKey(PublicKey certPubKey) {
        if (certPubKey == null) {
            return null;
        }
        ArrayList<CertificateToken> founds = new ArrayList<CertificateToken>();
        for (CertificateToken cert : this.usedCertificates) {
            if (!certPubKey.equals(cert.getPublicKey())) continue;
            founds.add(cert);
            if (!this.isTrusted(cert)) continue;
            return cert;
        }
        if (Utils.isCollectionNotEmpty(founds)) {
            return (CertificateToken)founds.iterator().next();
        }
        return null;
    }

    private XmlSigningCertificate getXmlSigningCertificate(CertificateValidity certificateValidity) {
        XmlSigningCertificate xmlSignCertType = new XmlSigningCertificate();
        CertificateToken signingCertificateToken = certificateValidity.getCertificateToken();
        if (signingCertificateToken != null) {
            xmlSignCertType.setCertificate(this.xmlCerts.get(signingCertificateToken.getDSSIdAsString()));
        } else if (certificateValidity.getPublicKey() != null) {
            xmlSignCertType = this.getXmlSigningCertificate(certificateValidity.getPublicKey());
        }
        xmlSignCertType.setAttributePresent(certificateValidity.isAttributePresent());
        xmlSignCertType.setDigestValuePresent(certificateValidity.isDigestPresent());
        xmlSignCertType.setDigestValueMatch(certificateValidity.isDigestEqual());
        boolean issuerSerialMatch = certificateValidity.isSerialNumberEqual() && certificateValidity.isDistinguishedNameEqual();
        xmlSignCertType.setIssuerSerialMatch(issuerSerialMatch);
        return xmlSignCertType;
    }

    private XmlSignatureProductionPlace getXmlSignatureProductionPlace(SignatureProductionPlace signatureProductionPlace) {
        if (signatureProductionPlace != null) {
            XmlSignatureProductionPlace xmlSignatureProductionPlace = new XmlSignatureProductionPlace();
            xmlSignatureProductionPlace.setCountryName(this.emptyToNull(signatureProductionPlace.getCountryName()));
            xmlSignatureProductionPlace.setStateOrProvince(this.emptyToNull(signatureProductionPlace.getStateOrProvince()));
            xmlSignatureProductionPlace.setPostalCode(this.emptyToNull(signatureProductionPlace.getPostalCode()));
            xmlSignatureProductionPlace.setAddress(this.emptyToNull(signatureProductionPlace.getStreetAddress()));
            xmlSignatureProductionPlace.setCity(this.emptyToNull(signatureProductionPlace.getCity()));
            return xmlSignatureProductionPlace;
        }
        return null;
    }

    private List<XmlSignerRole> getXmlSignerRoles(Collection<SignerRole> signerRoles) {
        ArrayList<XmlSignerRole> xmlSignerRoles = new ArrayList<XmlSignerRole>();
        if (Utils.isCollectionNotEmpty(signerRoles)) {
            for (SignerRole signerRole : signerRoles) {
                XmlSignerRole xmlSignerRole = new XmlSignerRole();
                xmlSignerRole.setRole(signerRole.getRole());
                xmlSignerRole.setCategory(signerRole.getCategory());
                xmlSignerRole.setNotBefore(signerRole.getNotBefore());
                xmlSignerRole.setNotAfter(signerRole.getNotAfter());
                xmlSignerRoles.add(xmlSignerRole);
            }
        }
        return xmlSignerRoles;
    }

    private List<String> getXmlCommitmentTypeIndication(CommitmentType commitmentTypeIndication) {
        if (commitmentTypeIndication != null) {
            return commitmentTypeIndication.getIdentifiers();
        }
        return Collections.emptyList();
    }

    private XmlDistinguishedName getXmlDistinguishedName(String x500PrincipalFormat, X500Principal X500PrincipalName) {
        XmlDistinguishedName xmlDistinguishedName = new XmlDistinguishedName();
        xmlDistinguishedName.setFormat(x500PrincipalFormat);
        xmlDistinguishedName.setValue(X500PrincipalName.getName(x500PrincipalFormat));
        return xmlDistinguishedName;
    }

    private XmlFoundCertificates getXmlFoundCertificates(AdvancedSignature signature) {
        XmlFoundCertificates xmlFoundCertificates = new XmlFoundCertificates();
        xmlFoundCertificates.getRelatedCertificates().addAll(this.getXmlRelatedCertificates(signature));
        xmlFoundCertificates.getRelatedCertificates().addAll(this.getXmlRelatedCertificateForOrphanReferences(signature));
        xmlFoundCertificates.getOrphanCertificates().addAll(this.getOrphanCertificates(signature));
        return xmlFoundCertificates;
    }

    private List<XmlRelatedCertificate> getXmlRelatedCertificates(AdvancedSignature signature) {
        HashMap<String, XmlRelatedCertificate> relatedCertificatesMap = new HashMap<String, XmlRelatedCertificate>();
        SignatureCertificateSource certificateSource = signature.getCertificateSource();
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.KEY_INFO, certificateSource.getKeyInfoCertificates(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.CERTIFICATE_VALUES, certificateSource.getCertificateValues(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.ATTR_AUTORITIES_CERT_VALUES, certificateSource.getAttrAuthoritiesCertValues(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.TIMESTAMP_VALIDATION_DATA, certificateSource.getTimeStampValidationDataCertValues(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.DSS_DICTIONARY, certificateSource.getDSSDictionaryCertValues(), certificateSource);
        this.populateCertificateOriginMap(relatedCertificatesMap, CertificateOrigin.VRI_DICTIONARY, certificateSource.getVRIDictionaryCertValues(), certificateSource);
        return new ArrayList<XmlRelatedCertificate>(relatedCertificatesMap.values());
    }

    private void populateCertificateOriginMap(Map<String, XmlRelatedCertificate> relatedCertificatesMap, CertificateOrigin origin, List<CertificateToken> certificateTokens, SignatureCertificateSource certificateSource) {
        for (CertificateToken certificateToken : certificateTokens) {
            if (!relatedCertificatesMap.containsKey(certificateToken.getDSSIdAsString())) {
                XmlRelatedCertificate xmlFoundCertificate = this.getXmlRelatedCertificate(origin, certificateToken, certificateSource);
                relatedCertificatesMap.put(certificateToken.getDSSIdAsString(), xmlFoundCertificate);
                continue;
            }
            XmlRelatedCertificate storedFoundCertificate = relatedCertificatesMap.get(certificateToken.getDSSIdAsString());
            if (storedFoundCertificate.getOrigins().contains((Object)origin)) continue;
            storedFoundCertificate.getOrigins().add(origin);
        }
    }

    private XmlRelatedCertificate getXmlRelatedCertificate(CertificateOrigin origin, CertificateToken cert, SignatureCertificateSource certificateSource) {
        XmlRelatedCertificate xrc = new XmlRelatedCertificate();
        xrc.getOrigins().add(origin);
        xrc.setCertificate(this.xmlCerts.get(cert.getDSSIdAsString()));
        List<CertificateRef> referencesForCertificateToken = certificateSource.getReferencesForCertificateToken(cert);
        for (CertificateRef certificateRef : referencesForCertificateToken) {
            xrc.getCertificateRefs().add(this.getXmlCertificateRef(certificateRef));
        }
        this.certificateRefsMap.put(cert.getDSSIdAsString(), referencesForCertificateToken);
        return xrc;
    }

    private XmlCertificateRef getXmlCertificateRef(CertificateRef ref) {
        Digest refDigest;
        XmlCertificateRef certificateRef = new XmlCertificateRef();
        IssuerSerialInfo serialInfo = ref.getIssuerInfo();
        if (serialInfo != null && serialInfo.getIssuerName() != null && serialInfo.getSerialNumber() != null) {
            IssuerSerial issuerSerial = DSSASN1Utils.getIssuerSerial(serialInfo.getIssuerName(), serialInfo.getSerialNumber());
            certificateRef.setIssuerSerial(DSSASN1Utils.getDEREncoded(issuerSerial));
        }
        if ((refDigest = ref.getCertDigest()) != null) {
            certificateRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(refDigest.getAlgorithm(), refDigest.getValue()));
        }
        certificateRef.setOrigin(ref.getOrigin());
        return certificateRef;
    }

    private List<XmlRelatedCertificate> getXmlRelatedCertificateForOrphanReferences(AdvancedSignature signature) {
        ArrayList<XmlRelatedCertificate> relatedCertificates = new ArrayList<XmlRelatedCertificate>();
        for (CertificateRef certificateRef : signature.getOrphanCertificateRefs()) {
            Digest certRefDigest = certificateRef.getCertDigest();
            for (CertificateToken certificateToken : this.usedCertificates) {
                if (!Arrays.equals(certRefDigest.getValue(), certificateToken.getDigest(certRefDigest.getAlgorithm()))) continue;
                relatedCertificates.add(this.getXmlRelatedCertificate(certificateToken, certificateRef));
            }
        }
        return relatedCertificates;
    }

    private XmlRelatedCertificate getXmlRelatedCertificate(CertificateToken cert, CertificateRef certificateRef) {
        XmlRelatedCertificate xrc = new XmlRelatedCertificate();
        xrc.setCertificate(this.xmlCerts.get(cert.getDSSIdAsString()));
        if (this.getXmlCertificateSources(cert).contains((Object)CertificateSourceType.TIMESTAMP)) {
            xrc.getOrigins().add(CertificateOrigin.TIMESTAMP_CERTIFICATE_VALUES);
        }
        xrc.getCertificateRefs().add(this.getXmlCertificateRef(certificateRef));
        this.certificateRefsMap.put(cert.getDSSIdAsString(), Arrays.asList(certificateRef));
        return xrc;
    }

    private List<XmlOrphanCertificate> getOrphanCertificates(AdvancedSignature signature) {
        ArrayList<XmlOrphanCertificate> orphanCertificates = new ArrayList<XmlOrphanCertificate>();
        for (CertificateToken certificateToken : signature.getCertificates()) {
            if (this.usedCertificates.contains(certificateToken)) continue;
            orphanCertificates.add(this.createXmlOrphanCertificate(certificateToken, false));
        }
        for (CertificateToken certificateToken : signature.getTimestampSource().getCertificates()) {
            if (this.usedCertificates.contains(certificateToken)) continue;
            orphanCertificates.add(this.createXmlOrphanCertificate(certificateToken, true));
        }
        List<CertificateRef> orphanCertificateRefs = signature.getOrphanCertificateRefs();
        for (List<CertificateRef> assignedCertificateRefs : this.certificateRefsMap.values()) {
            orphanCertificateRefs.removeAll(assignedCertificateRefs);
        }
        for (CertificateRef orphanCertificateRef : orphanCertificateRefs) {
            orphanCertificates.add(this.createXmlOrphanCertificate(orphanCertificateRef));
        }
        return orphanCertificates;
    }

    private XmlOrphanCertificate createXmlOrphanCertificate(CertificateToken certificateToken, boolean foundInTimestamp) {
        XmlOrphanCertificate orphanCertificate = new XmlOrphanCertificate();
        if (foundInTimestamp || this.getXmlCertificateSources(certificateToken).contains((Object)CertificateSourceType.TIMESTAMP)) {
            orphanCertificate.getOrigins().add(CertificateOrigin.TIMESTAMP_CERTIFICATE_VALUES);
        }
        orphanCertificate.setToken(this.createXmlOrphanCertificateToken(certificateToken));
        return orphanCertificate;
    }

    private XmlOrphanCertificate createXmlOrphanCertificate(CertificateRef orphanCertificateRef) {
        XmlOrphanCertificate orphanCertificate = new XmlOrphanCertificate();
        orphanCertificate.setToken(this.createXmlOrphanCertificateToken(orphanCertificateRef));
        orphanCertificate.getCertificateRefs().add(this.getXmlCertificateRef(orphanCertificateRef));
        return orphanCertificate;
    }

    private XmlOrphanToken createXmlOrphanCertificateToken(CertificateToken certificateToken) {
        XmlOrphanToken orphanToken = new XmlOrphanToken();
        orphanToken.setId(certificateToken.getDSSIdAsString());
        orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certificateToken.getDigest(this.defaultDigestAlgorithm)));
        orphanToken.setType(OrphanTokenType.CERTIFICATE);
        this.xmlOrphanTokens.put(certificateToken.getDSSIdAsString(), orphanToken);
        return orphanToken;
    }

    private XmlOrphanToken createXmlOrphanCertificateToken(CertificateRef orphanCertificateRef) {
        XmlOrphanToken orphanToken = new XmlOrphanToken();
        orphanToken.setId(orphanCertificateRef.getDSSIdAsString());
        orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(orphanCertificateRef.getCertDigest()));
        orphanToken.setType(OrphanTokenType.CERTIFICATE);
        this.xmlOrphanTokens.put(orphanCertificateRef.getDSSIdAsString(), orphanToken);
        return orphanToken;
    }

    private List<XmlTimestamp> getXmlTimestamps(AdvancedSignature signature) {
        ArrayList<XmlTimestamp> xmlTimestamps = new ArrayList<XmlTimestamp>();
        xmlTimestamps.addAll(this.getXmlTimestamps(signature.getAllTimestamps()));
        return xmlTimestamps;
    }

    private List<XmlFoundTimestamp> getXmlFoundTimestamps(AdvancedSignature signature) {
        ArrayList<XmlFoundTimestamp> foundTimestamps = new ArrayList<XmlFoundTimestamp>();
        foundTimestamps.addAll(this.getFoundTimestamps(signature.getAllTimestamps()));
        return foundTimestamps;
    }

    private List<XmlFoundTimestamp> getFoundTimestamps(List<TimestampToken> tsts) {
        ArrayList<XmlFoundTimestamp> foundTimestamps = new ArrayList<XmlFoundTimestamp>();
        for (TimestampToken timestampToken : tsts) {
            XmlFoundTimestamp foundTimestamp = new XmlFoundTimestamp();
            foundTimestamp.setTimestamp(this.xmlTimestamps.get(timestampToken.getDSSIdAsString()));
            foundTimestamp.setLocation(timestampToken.getTimestampLocation());
            foundTimestamps.add(foundTimestamp);
        }
        return foundTimestamps;
    }

    private XmlFoundRevocations getXmlFoundRevocations(AdvancedSignature signature) {
        XmlFoundRevocations foundRevocations = new XmlFoundRevocations();
        foundRevocations.getRelatedRevocations().addAll(this.getXmlRelatedRevocations(signature));
        List<EncapsulatedRevocationTokenIdentifier> orphanRevocations = this.getOrphanRevocations(signature);
        if (Utils.isCollectionNotEmpty(orphanRevocations)) {
            foundRevocations.getOrphanRevocations().addAll(this.getXmlOrphanRevocations(orphanRevocations, signature));
        }
        List<RevocationRef> orphanRevocationRefs = signature.getOrphanRevocationRefs();
        for (List<RevocationRef> assignedRevocationRefs : this.revocationRefsMap.values()) {
            orphanRevocationRefs.removeAll(assignedRevocationRefs);
        }
        for (RevocationRef leftRevocationRef : orphanRevocationRefs) {
            XmlOrphanRevocation revocationFromRef = this.createOrphanRevocationFromRef(leftRevocationRef);
            foundRevocations.getOrphanRevocations().add(revocationFromRef);
        }
        return foundRevocations;
    }

    private List<EncapsulatedRevocationTokenIdentifier> getOrphanRevocations(AdvancedSignature signature) {
        ArrayList<EncapsulatedRevocationTokenIdentifier> orphanIdentifiers = new ArrayList<EncapsulatedRevocationTokenIdentifier>();
        List<EncapsulatedRevocationTokenIdentifier> revocationIdentifiers = signature.getAllFoundRevocationIdentifiers();
        for (EncapsulatedRevocationTokenIdentifier revocationIdentifier : revocationIdentifiers) {
            if (this.xmlRevocations.containsKey(revocationIdentifier.asXmlId())) continue;
            orphanIdentifiers.add(revocationIdentifier);
        }
        return orphanIdentifiers;
    }

    private List<XmlRelatedRevocation> getXmlRelatedRevocations(AdvancedSignature signature) {
        ArrayList<XmlRelatedRevocation> xmlRelatedRevocations = new ArrayList<XmlRelatedRevocation>();
        xmlRelatedRevocations.addAll(this.getXmlRevocationsByType(signature, signature.getAllRevocationTokens()));
        return xmlRelatedRevocations;
    }

    private List<XmlRelatedRevocation> getXmlRevocationsByType(AdvancedSignature signature, Collection<RevocationToken> revocationTokens) {
        ArrayList<XmlRelatedRevocation> xmlRelatedRevocations = new ArrayList<XmlRelatedRevocation>();
        HashSet<String> revocationKeys = new HashSet<String>();
        for (RevocationToken revocationToken : revocationTokens) {
            XmlRevocation xmlRevocation;
            if (revocationKeys.contains(revocationToken.getDSSIdAsString()) || (xmlRevocation = this.xmlRevocations.get(revocationToken.getDSSIdAsString())) == null) continue;
            XmlRelatedRevocation xmlRelatedRevocation = new XmlRelatedRevocation();
            xmlRelatedRevocation.setRevocation(xmlRevocation);
            xmlRelatedRevocation.setType(revocationToken.getRevocationType());
            xmlRelatedRevocation.getOrigins().addAll(revocationToken.getOrigins());
            List<RevocationRef> revocationRefs = signature.findRefsForRevocationToken(revocationToken);
            if (Utils.isCollectionNotEmpty(revocationRefs)) {
                xmlRelatedRevocation.getRevocationRefs().addAll(this.getXmlRevocationRefs(revocationRefs));
            }
            xmlRelatedRevocations.add(xmlRelatedRevocation);
            revocationKeys.add(revocationToken.getDSSIdAsString());
            this.revocationRefsMap.put(revocationToken.getDSSIdAsString(), revocationRefs);
        }
        return xmlRelatedRevocations;
    }

    private List<XmlRevocationRef> getXmlRevocationRefs(List<RevocationRef> revocationRefs) {
        ArrayList<XmlRevocationRef> xmlRevocationRefs = new ArrayList<XmlRevocationRef>();
        for (RevocationRef ref : revocationRefs) {
            XmlRevocationRef revocationRef = ref instanceof CRLRef ? this.getXmlCRLRevocationRef((CRLRef)ref) : this.getXmlOCSPRevocationRef((OCSPRef)ref);
            xmlRevocationRefs.add(revocationRef);
        }
        return xmlRevocationRefs;
    }

    private XmlRevocationRef getXmlCRLRevocationRef(CRLRef crlRef) {
        XmlRevocationRef xmlRevocationRef = new XmlRevocationRef();
        xmlRevocationRef.getOrigins().addAll(crlRef.getOrigins());
        if (crlRef.getDigest() != null) {
            xmlRevocationRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(crlRef.getDigest()));
        }
        return xmlRevocationRef;
    }

    private XmlRevocationRef getXmlOCSPRevocationRef(OCSPRef ocspRef) {
        byte[] key;
        XmlRevocationRef xmlRevocationRef = new XmlRevocationRef();
        xmlRevocationRef.getOrigins().addAll(ocspRef.getOrigins());
        if (ocspRef.getDigest() != null) {
            xmlRevocationRef.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(ocspRef.getDigest()));
        }
        xmlRevocationRef.setProducedAt(ocspRef.getProducedAt());
        String name = ocspRef.getResponderId().getName();
        if (Utils.isStringNotEmpty(name)) {
            xmlRevocationRef.setResponderIdName(name);
        }
        if (Utils.isArrayNotEmpty(key = ocspRef.getResponderId().getKey())) {
            xmlRevocationRef.setResponderIdKey(key);
        }
        return xmlRevocationRef;
    }

    private List<XmlOrphanRevocation> getXmlOrphanRevocations(Collection<EncapsulatedRevocationTokenIdentifier> orphanRevocations, AdvancedSignature signature) {
        ArrayList<XmlOrphanRevocation> xmlOrphanRevocations = new ArrayList<XmlOrphanRevocation>();
        for (EncapsulatedRevocationTokenIdentifier revocationIdentifier : orphanRevocations) {
            xmlOrphanRevocations.add(this.getXmlOrphanRevocation(revocationIdentifier, signature));
        }
        return xmlOrphanRevocations;
    }

    private XmlOrphanRevocation getXmlOrphanRevocation(EncapsulatedRevocationTokenIdentifier revocationIdentifier, AdvancedSignature signature) {
        XmlOrphanRevocation xmlOrphanRevocation = new XmlOrphanRevocation();
        xmlOrphanRevocation.setToken(this.createOrphanTokenFromRevocationIdentifier(revocationIdentifier));
        if (revocationIdentifier instanceof CRLBinary) {
            xmlOrphanRevocation.setType(RevocationType.CRL);
            for (RevocationOrigin origin : signature.getCompleteCRLSource().getRevocationOrigins((CRLBinary)revocationIdentifier)) {
                xmlOrphanRevocation.getOrigins().add(origin);
            }
        } else {
            xmlOrphanRevocation.setType(RevocationType.OCSP);
            for (RevocationOrigin origin : signature.getCompleteOCSPSource().getRevocationOrigins((OCSPResponseBinary)revocationIdentifier)) {
                xmlOrphanRevocation.getOrigins().add(origin);
            }
        }
        List<RevocationRef> refsForRevocationToken = signature.findRefsForRevocationIdentifier(revocationIdentifier);
        for (RevocationRef revocationRef : refsForRevocationToken) {
            xmlOrphanRevocation.getRevocationRefs().add(this.revocationRefToXml(revocationRef));
        }
        this.revocationRefsMap.put(revocationIdentifier.asXmlId(), refsForRevocationToken);
        return xmlOrphanRevocation;
    }

    private XmlRevocationRef revocationRefToXml(RevocationRef ref) {
        XmlRevocationRef xmlRevocationRef = ref instanceof CRLRef ? this.getXmlCRLRevocationRef((CRLRef)ref) : this.getXmlOCSPRevocationRef((OCSPRef)ref);
        return xmlRevocationRef;
    }

    private XmlOrphanToken createOrphanTokenFromRevocationIdentifier(EncapsulatedRevocationTokenIdentifier revocationIdentifier) {
        XmlOrphanToken orphanToken = new XmlOrphanToken();
        String tokenId = revocationIdentifier.asXmlId();
        orphanToken.setId(tokenId);
        orphanToken.setType(OrphanTokenType.REVOCATION);
        if (this.includeRawRevocationData) {
            orphanToken.setBase64Encoded(revocationIdentifier.getBinaries());
        } else {
            byte[] digestValue = revocationIdentifier.getDigestValue(this.defaultDigestAlgorithm);
            orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, digestValue));
        }
        if (!this.xmlOrphanTokens.containsKey(tokenId)) {
            this.xmlOrphanTokens.put(tokenId, orphanToken);
        }
        return orphanToken;
    }

    private XmlOrphanRevocation createOrphanRevocationFromRef(RevocationRef ref) {
        XmlOrphanRevocation xmlOrphanRevocation = new XmlOrphanRevocation();
        XmlOrphanToken orphanToken = new XmlOrphanToken();
        orphanToken.setId(ref.getDSSIdAsString());
        orphanToken.setType(OrphanTokenType.REVOCATION);
        orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(ref.getDigest()));
        this.xmlOrphanTokens.put(ref.getDSSIdAsString(), orphanToken);
        xmlOrphanRevocation.setToken(orphanToken);
        if (ref instanceof CRLRef) {
            xmlOrphanRevocation.setType(RevocationType.CRL);
        } else {
            xmlOrphanRevocation.setType(RevocationType.OCSP);
        }
        xmlOrphanRevocation.getRevocationRefs().add(this.revocationRefToXml(ref));
        return xmlOrphanRevocation;
    }

    private XmlPolicy getXmlPolicy(AdvancedSignature signature) {
        SignaturePolicy signaturePolicy = signature.getPolicyId();
        if (signaturePolicy == null) {
            return null;
        }
        XmlPolicy xmlPolicy = new XmlPolicy();
        xmlPolicy.setId(signaturePolicy.getIdentifier());
        xmlPolicy.setUrl(signaturePolicy.getUrl());
        xmlPolicy.setDescription(signaturePolicy.getDescription());
        xmlPolicy.setNotice(signaturePolicy.getNotice());
        xmlPolicy.setZeroHash(signaturePolicy.isZeroHash());
        Digest digest = signaturePolicy.getDigest();
        if (digest != null) {
            xmlPolicy.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(digest));
        }
        try {
            SignaturePolicyValidator validator = null;
            ServiceLoader<SignaturePolicyValidator> loader = ServiceLoader.load(SignaturePolicyValidator.class);
            Iterator<SignaturePolicyValidator> validatorOptions = loader.iterator();
            if (validatorOptions.hasNext()) {
                for (SignaturePolicyValidator signaturePolicyValidator : loader) {
                    signaturePolicyValidator.setSignature(signature);
                    if (!signaturePolicyValidator.canValidate()) continue;
                    validator = signaturePolicyValidator;
                    break;
                }
            }
            if (validator == null) {
                validator = new BasicASNSignaturePolicyValidator();
                validator.setSignature(signature);
            }
            validator.validate();
            xmlPolicy.setAsn1Processable(validator.isAsn1Processable());
            xmlPolicy.setDigestAlgorithmsEqual(validator.isDigestAlgorithmsEqual());
            xmlPolicy.setIdentified(validator.isIdentified());
            xmlPolicy.setStatus(validator.isStatus());
            xmlPolicy.setProcessingError(validator.getProcessingErrors());
        }
        catch (Exception e) {
            xmlPolicy.setStatus(false);
            xmlPolicy.setProcessingError(e.getMessage());
            LOG.warn(e.getMessage(), e);
        }
        return xmlPolicy;
    }

    private List<XmlTimestamp> getXmlTimestamps(List<TimestampToken> timestamps) {
        ArrayList<XmlTimestamp> xmlTimestampsList = new ArrayList<XmlTimestamp>();
        if (Utils.isCollectionNotEmpty(timestamps)) {
            for (TimestampToken timestampToken : timestamps) {
                XmlTimestamp xmlTimestamp = this.getXmlTimestamp(timestampToken);
                xmlTimestampsList.add(xmlTimestamp);
                this.xmlTimestamps.put(xmlTimestamp.getId(), xmlTimestamp);
            }
        }
        return xmlTimestampsList;
    }

    private XmlTimestamp getXmlTimestamp(TimestampToken timestampToken) {
        XmlTimestamp xmlTimestampToken = new XmlTimestamp();
        xmlTimestampToken.setId(timestampToken.getDSSIdAsString());
        xmlTimestampToken.setType(timestampToken.getTimeStampType());
        xmlTimestampToken.setArchiveTimestampType(timestampToken.getArchiveTimestampType());
        xmlTimestampToken.setProductionTime(timestampToken.getGenerationTime());
        xmlTimestampToken.setDigestMatcher(this.getXmlDigestMatcher(timestampToken));
        xmlTimestampToken.setBasicSignature(this.getXmlBasicSignature(timestampToken));
        xmlTimestampToken.setSigningCertificate(this.getXmlSigningCertificate(timestampToken.getPublicKeyOfTheSigner()));
        xmlTimestampToken.setCertificateChain(this.getXmlForCertificateChain(timestampToken.getPublicKeyOfTheSigner()));
        xmlTimestampToken.setTimestampedObjects(this.getXmlTimestampedObjects(timestampToken));
        if (this.includeRawTimestampTokens) {
            xmlTimestampToken.setBase64Encoded(timestampToken.getEncoded());
        } else {
            byte[] certDigest = timestampToken.getDigest(this.defaultDigestAlgorithm);
            xmlTimestampToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certDigest));
        }
        return xmlTimestampToken;
    }

    private XmlDigestMatcher getXmlDigestMatcher(TimestampToken timestampToken) {
        XmlDigestMatcher digestMatcher = new XmlDigestMatcher();
        digestMatcher.setType(DigestMatcherType.MESSAGE_IMPRINT);
        DigestAlgorithm digestAlgo = timestampToken.getSignedDataDigestAlgo();
        digestMatcher.setDigestMethod(digestAlgo);
        digestMatcher.setDigestValue(timestampToken.getMessageImprintDigest());
        digestMatcher.setDataFound(timestampToken.isMessageImprintDataFound());
        digestMatcher.setDataIntact(timestampToken.isMessageImprintDataIntact());
        return digestMatcher;
    }

    private List<XmlTimestampedObject> getXmlTimestampedObjects(TimestampToken timestampToken) {
        List<TimestampedReference> timestampReferences = timestampToken.getTimestampedReferences();
        if (Utils.isCollectionNotEmpty(timestampReferences)) {
            ArrayList<XmlTimestampedObject> objects = new ArrayList<XmlTimestampedObject>();
            for (TimestampedReference timestampReference : timestampReferences) {
                objects.add(this.createXmlTimestampedObject(timestampReference));
            }
            return objects;
        }
        return null;
    }

    private XmlTimestampedObject createXmlTimestampedObject(TimestampedReference timestampReference) {
        XmlTimestampedObject timestampedObj = new XmlTimestampedObject();
        timestampedObj.setCategory(timestampReference.getCategory());
        String objectId = timestampReference.getObjectId();
        switch (timestampReference.getCategory()) {
            case SIGNATURE: {
                timestampedObj.setToken(this.xmlSignatures.get(objectId));
                return timestampedObj;
            }
            case CERTIFICATE: {
                if (!this.isUsedToken(objectId, this.usedCertificates)) {
                    String relatedCertificateId = this.getRelatedCertificateId(objectId);
                    if (relatedCertificateId == null || !this.isUsedToken(relatedCertificateId, this.usedCertificates)) break;
                    objectId = relatedCertificateId;
                }
                timestampedObj.setToken(this.xmlCerts.get(objectId));
                return timestampedObj;
            }
            case REVOCATION: {
                if (!this.isUsedToken(objectId, this.usedRevocations)) {
                    String relatedRevocationId = this.getRelatedRevocationId(objectId);
                    if (relatedRevocationId == null || !this.isUsedToken(relatedRevocationId, this.usedRevocations)) break;
                    objectId = relatedRevocationId;
                }
                timestampedObj.setToken(this.xmlRevocations.get(objectId));
                return timestampedObj;
            }
            case TIMESTAMP: {
                timestampedObj.setToken(this.xmlTimestamps.get(objectId));
                return timestampedObj;
            }
            case SIGNED_DATA: {
                timestampedObj.setToken(this.xmlSignedData.get(objectId));
                return timestampedObj;
            }
            default: {
                throw new DSSException("Unsupported category " + (Object)((Object)timestampReference.getCategory()));
            }
        }
        timestampedObj.setCategory(TimestampedObjectType.ORPHAN);
        timestampedObj.setToken(this.xmlOrphanTokens.get(objectId));
        return timestampedObj;
    }

    private <T extends Token> boolean isUsedToken(String tokenId, Collection<T> usedTokens) {
        for (Token token : usedTokens) {
            if (!token.getDSSIdAsString().equals(tokenId)) continue;
            return true;
        }
        return false;
    }

    private String getRelatedCertificateId(String orphanCertId) {
        for (Map.Entry<String, List<CertificateRef>> entry : this.certificateRefsMap.entrySet()) {
            for (CertificateRef certificateRef : entry.getValue()) {
                if (!certificateRef.getDSSIdAsString().equals(orphanCertId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private String getRelatedRevocationId(String orphanRevocationId) {
        for (Map.Entry<String, List<RevocationRef>> entry : this.revocationRefsMap.entrySet()) {
            for (RevocationRef revocationRef : entry.getValue()) {
                if (!revocationRef.getDSSIdAsString().equals(orphanRevocationId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private XmlBasicSignature getXmlBasicSignature(Token token) {
        XmlBasicSignature xmlBasicSignatureType = new XmlBasicSignature();
        SignatureAlgorithm signatureAlgorithm = token.getSignatureAlgorithm();
        if (signatureAlgorithm != null) {
            xmlBasicSignatureType.setEncryptionAlgoUsedToSignThisToken(signatureAlgorithm.getEncryptionAlgorithm());
            xmlBasicSignatureType.setDigestAlgoUsedToSignThisToken(signatureAlgorithm.getDigestAlgorithm());
            xmlBasicSignatureType.setMaskGenerationFunctionUsedToSignThisToken(signatureAlgorithm.getMaskGenerationFunction());
        }
        xmlBasicSignatureType.setKeyLengthUsedToSignThisToken(DSSPKUtils.getPublicKeySize(token));
        boolean signatureValid = token.isSignatureValid();
        xmlBasicSignatureType.setSignatureIntact(signatureValid);
        xmlBasicSignatureType.setSignatureValid(signatureValid);
        return xmlBasicSignatureType;
    }

    private XmlBasicSignature getXmlBasicSignature(AdvancedSignature signature, PublicKey signingCertificatePublicKey) {
        XmlBasicSignature xmlBasicSignature = new XmlBasicSignature();
        xmlBasicSignature.setEncryptionAlgoUsedToSignThisToken(signature.getEncryptionAlgorithm());
        int keyLength = signingCertificatePublicKey == null ? 0 : DSSPKUtils.getPublicKeySize(signingCertificatePublicKey);
        xmlBasicSignature.setKeyLengthUsedToSignThisToken(String.valueOf(keyLength));
        xmlBasicSignature.setDigestAlgoUsedToSignThisToken(signature.getDigestAlgorithm());
        xmlBasicSignature.setMaskGenerationFunctionUsedToSignThisToken(signature.getMaskGenerationFunction());
        SignatureCryptographicVerification scv = signature.getSignatureCryptographicVerification();
        xmlBasicSignature.setSignatureIntact(scv.isSignatureIntact());
        xmlBasicSignature.setSignatureValid(scv.isSignatureValid());
        return xmlBasicSignature;
    }

    private List<XmlDigestMatcher> getXmlDigestMatchers(AdvancedSignature signature) {
        ArrayList<XmlDigestMatcher> refs = new ArrayList<XmlDigestMatcher>();
        List<ReferenceValidation> refValidations = signature.getReferenceValidations();
        for (ReferenceValidation referenceValidation : refValidations) {
            refs.add(this.getXmlDigestMatcher(referenceValidation));
            List<ReferenceValidation> dependentValidations = referenceValidation.getDependentValidations();
            if (!Utils.isCollectionNotEmpty(dependentValidations) || !Utils.isCollectionNotEmpty(signature.getDetachedContents()) && !this.isAtLeastOneFound(dependentValidations)) continue;
            for (ReferenceValidation dependentValidation : referenceValidation.getDependentValidations()) {
                refs.add(this.getXmlDigestMatcher(dependentValidation));
            }
        }
        return refs;
    }

    public boolean isAtLeastOneFound(List<ReferenceValidation> referenceValidations) {
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (!referenceValidation.isFound()) continue;
            return true;
        }
        return false;
    }

    private XmlDigestMatcher getXmlDigestMatcher(ReferenceValidation referenceValidation) {
        XmlDigestMatcher ref = new XmlDigestMatcher();
        ref.setType(referenceValidation.getType());
        ref.setName(referenceValidation.getName());
        Digest digest = referenceValidation.getDigest();
        if (digest != null) {
            ref.setDigestValue(digest.getValue());
            ref.setDigestMethod(digest.getAlgorithm());
        }
        ref.setDataFound(referenceValidation.isFound());
        ref.setDataIntact(referenceValidation.isIntact());
        return ref;
    }

    private List<XmlSignatureScope> getXmlSignatureScopes(List<SignatureScope> scopes) {
        ArrayList<XmlSignatureScope> xmlScopes = new ArrayList<XmlSignatureScope>();
        if (Utils.isCollectionNotEmpty(scopes)) {
            for (SignatureScope xmlSignatureScope : scopes) {
                xmlScopes.add(this.getXmlSignatureScope(xmlSignatureScope));
            }
        }
        return xmlScopes;
    }

    private XmlSignatureScope getXmlSignatureScope(SignatureScope scope) {
        XmlSignatureScope xmlSignatureScope = new XmlSignatureScope();
        xmlSignatureScope.setName(scope.getName());
        xmlSignatureScope.setScope(scope.getType());
        xmlSignatureScope.setDescription(scope.getDescription());
        xmlSignatureScope.setTransformations(scope.getTransformations());
        xmlSignatureScope.setSignerData(this.xmlSignedData.get(scope.getDSSIdAsString()));
        return xmlSignatureScope;
    }

    private XmlCertificate buildDetachedXmlCertificate(CertificateToken certToken) {
        XmlCertificate xmlCert = new XmlCertificate();
        xmlCert.setId(certToken.getDSSIdAsString());
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", certToken.getSubjectX500Principal()));
        xmlCert.getSubjectDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", certToken.getSubjectX500Principal()));
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("CANONICAL", certToken.getIssuerX500Principal()));
        xmlCert.getIssuerDistinguishedName().add(this.getXmlDistinguishedName("RFC2253", certToken.getIssuerX500Principal()));
        xmlCert.setSerialNumber(certToken.getSerialNumber());
        X500Principal x500Principal = certToken.getSubjectX500Principal();
        xmlCert.setCommonName(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.CN, x500Principal));
        xmlCert.setLocality(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.L, x500Principal));
        xmlCert.setState(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.ST, x500Principal));
        xmlCert.setCountryName(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.C, x500Principal));
        xmlCert.setOrganizationName(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.O, x500Principal));
        xmlCert.setGivenName(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.GIVENNAME, x500Principal));
        xmlCert.setOrganizationalUnit(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.OU, x500Principal));
        xmlCert.setSurname(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.SURNAME, x500Principal));
        xmlCert.setPseudonym(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.PSEUDONYM, x500Principal));
        xmlCert.setEmail(DSSASN1Utils.extractAttributeFromX500Principal(BCStyle.E, x500Principal));
        xmlCert.setAuthorityInformationAccessUrls(DSSASN1Utils.getCAAccessLocations(certToken));
        xmlCert.setOCSPAccessUrls(DSSASN1Utils.getOCSPAccessLocations(certToken));
        xmlCert.setCRLDistributionPoints(DSSASN1Utils.getCrlUrls(certToken));
        xmlCert.setSources(this.getXmlCertificateSources(certToken));
        xmlCert.setNotAfter(certToken.getNotAfter());
        xmlCert.setNotBefore(certToken.getNotBefore());
        PublicKey publicKey = certToken.getPublicKey();
        xmlCert.setPublicKeySize(DSSPKUtils.getPublicKeySize(publicKey));
        xmlCert.setPublicKeyEncryptionAlgo(EncryptionAlgorithm.forKey(publicKey));
        xmlCert.setKeyUsageBits(certToken.getKeyUsageBits());
        xmlCert.setExtendedKeyUsages(this.getXmlOids(DSSASN1Utils.getExtendedKeyUsage(certToken)));
        xmlCert.setIdPkixOcspNoCheck(DSSASN1Utils.hasIdPkixOcspNoCheckExtension(certToken));
        xmlCert.setBasicSignature(this.getXmlBasicSignature(certToken));
        xmlCert.setQCStatementIds(this.getXmlOids(DSSASN1Utils.getQCStatementsIdList(certToken)));
        xmlCert.setQCTypes(this.getXmlOids(DSSASN1Utils.getQCTypesIdList(certToken)));
        xmlCert.setCertificatePolicies(this.getXmlCertificatePolicies(DSSASN1Utils.getCertificatePolicies(certToken)));
        xmlCert.setSelfSigned(certToken.isSelfSigned());
        xmlCert.setTrusted(this.isTrusted(certToken));
        if (this.includeRawCertificateTokens) {
            xmlCert.setBase64Encoded(certToken.getEncoded());
        } else {
            byte[] certDigest = certToken.getDigest(this.defaultDigestAlgorithm);
            xmlCert.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, certDigest));
        }
        return xmlCert;
    }

    private List<CertificateSourceType> getXmlCertificateSources(CertificateToken token) {
        Set<CertificateSourceType> sourceTypes;
        ArrayList<CertificateSourceType> certificateSources = new ArrayList<CertificateSourceType>();
        if (this.certificateSourceTypes != null && (sourceTypes = this.certificateSourceTypes.get(token)) != null) {
            certificateSources.addAll(sourceTypes);
        }
        if (Utils.isCollectionEmpty(certificateSources)) {
            certificateSources.add(CertificateSourceType.UNKNOWN);
        }
        return certificateSources;
    }

    private CertificateToken getCertificateToken(String certificateId) {
        for (CertificateToken certificateToken : this.usedCertificates) {
            if (!Utils.areStringsEqual(certificateId, certificateToken.getDSSIdAsString())) continue;
            return certificateToken;
        }
        return null;
    }

    private Set<RevocationToken> getRevocationsForCert(CertificateToken certToken) {
        HashSet<RevocationToken> revocations = new HashSet<RevocationToken>();
        if (Utils.isCollectionNotEmpty(this.usedRevocations)) {
            for (RevocationToken revocationToken : this.usedRevocations) {
                if (!Utils.areStringsEqual(certToken.getDSSIdAsString(), revocationToken.getRelatedCertificateID())) continue;
                revocations.add(revocationToken);
            }
        }
        return revocations;
    }

    private List<XmlCertificatePolicy> getXmlCertificatePolicies(List<CertificatePolicy> certificatePolicies) {
        ArrayList<XmlCertificatePolicy> result = new ArrayList<XmlCertificatePolicy>();
        for (CertificatePolicy cp : certificatePolicies) {
            XmlCertificatePolicy xmlCP = new XmlCertificatePolicy();
            xmlCP.setValue(cp.getOid());
            xmlCP.setDescription(OidRepository.getDescription(cp.getOid()));
            xmlCP.setCpsUrl(cp.getCpsUrl());
            result.add(xmlCP);
        }
        return result;
    }

    private List<XmlOID> getXmlOids(List<String> oidList) {
        ArrayList<XmlOID> result = new ArrayList<XmlOID>();
        if (Utils.isCollectionNotEmpty(oidList)) {
            for (String oid : oidList) {
                XmlOID xmlOID = new XmlOID();
                xmlOID.setValue(oid);
                xmlOID.setDescription(OidRepository.getDescription(oid));
                result.add(xmlOID);
            }
        }
        return result;
    }

    private List<XmlTrustedServiceProvider> getXmlTrustedServiceProviders(CertificateToken certToken) {
        ArrayList<XmlTrustedServiceProvider> result = new ArrayList<XmlTrustedServiceProvider>();
        Map<CertificateToken, Set<ServiceInfo>> servicesByTrustedCert = this.getRelatedTrustServices(certToken);
        for (Map.Entry<CertificateToken, Set<ServiceInfo>> entry : servicesByTrustedCert.entrySet()) {
            CertificateToken trustedCert = entry.getKey();
            Set<ServiceInfo> services = entry.getValue();
            Map<String, List<ServiceInfo>> servicesByProviders = this.classifyByServiceProvider(services);
            for (List<ServiceInfo> servicesByProvider : servicesByProviders.values()) {
                ServiceInfo first = servicesByProvider.get(0);
                XmlTrustedServiceProvider serviceProvider = new XmlTrustedServiceProvider();
                serviceProvider.setCountryCode(first.getTlCountryCode());
                serviceProvider.setTSPName(first.getTspName());
                serviceProvider.setTSPRegistrationIdentifier(first.getTspRegistrationIdentifier());
                serviceProvider.setTrustedServices(this.getXmlTrustedServices(servicesByProvider, certToken, trustedCert));
                result.add(serviceProvider);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private Map<CertificateToken, Set<ServiceInfo>> getRelatedTrustServices(CertificateToken certToken) {
        if (this.trustedCertSource instanceof TrustedListsCertificateSource) {
            HashMap<CertificateToken, Set<ServiceInfo>> result = new HashMap<CertificateToken, Set<ServiceInfo>>();
            HashSet<CertificateToken> processedTokens = new HashSet<CertificateToken>();
            while (certToken != null) {
                Set<ServiceInfo> trustServices = this.trustedCertSource.getTrustServices(certToken);
                if (!trustServices.isEmpty()) {
                    result.put(certToken, trustServices);
                }
                if (certToken.isSelfSigned() || processedTokens.contains(certToken)) break;
                processedTokens.add(certToken);
                certToken = this.getCertificateByPubKey(certToken.getPublicKeyOfTheSigner());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    private List<XmlTrustedService> getXmlTrustedServices(List<ServiceInfo> serviceInfos, CertificateToken certToken, CertificateToken trustedCert) {
        ArrayList<XmlTrustedService> result = new ArrayList<XmlTrustedService>();
        for (ServiceInfo serviceInfo : serviceInfos) {
            List<ServiceInfoStatus> serviceStatusAfterOfEqualsCertIssuance = serviceInfo.getStatus().getAfter(certToken.getNotBefore());
            if (!Utils.isCollectionNotEmpty(serviceStatusAfterOfEqualsCertIssuance)) continue;
            for (ServiceInfoStatus serviceInfoStatus : serviceStatusAfterOfEqualsCertIssuance) {
                List<String> serviceSupplyPoints;
                List<String> additionalServiceInfoUris;
                XmlTrustedService trustedService = new XmlTrustedService();
                trustedService.setServiceDigitalIdentifier(this.xmlCerts.get(trustedCert.getDSSIdAsString()));
                trustedService.setServiceName(serviceInfoStatus.getServiceName());
                trustedService.setServiceType(serviceInfoStatus.getType());
                trustedService.setStatus(serviceInfoStatus.getStatus());
                trustedService.setStartDate(serviceInfoStatus.getStartDate());
                trustedService.setEndDate(serviceInfoStatus.getEndDate());
                List<String> qualifiers = this.getQualifiers(serviceInfoStatus, certToken);
                if (Utils.isCollectionNotEmpty(qualifiers)) {
                    trustedService.setCapturedQualifiers(qualifiers);
                }
                if (Utils.isCollectionNotEmpty(additionalServiceInfoUris = serviceInfoStatus.getAdditionalServiceInfoUris())) {
                    trustedService.setAdditionalServiceInfoUris(additionalServiceInfoUris);
                }
                if (Utils.isCollectionNotEmpty(serviceSupplyPoints = serviceInfoStatus.getServiceSupplyPoints())) {
                    trustedService.setServiceSupplyPoints(serviceSupplyPoints);
                }
                trustedService.setExpiredCertsRevocationInfo(serviceInfoStatus.getExpiredCertsRevocationInfo());
                result.add(trustedService);
            }
        }
        return Collections.unmodifiableList(result);
    }

    private Map<String, List<ServiceInfo>> classifyByServiceProvider(Set<ServiceInfo> services) {
        HashMap<String, List<ServiceInfo>> servicesByProviders = new HashMap<String, List<ServiceInfo>>();
        if (Utils.isCollectionNotEmpty(services)) {
            for (ServiceInfo serviceInfo : services) {
                String tradeName = serviceInfo.getTspTradeName();
                ArrayList<ServiceInfo> servicesByProvider = (ArrayList<ServiceInfo>)servicesByProviders.get(tradeName);
                if (servicesByProvider == null) {
                    servicesByProvider = new ArrayList<ServiceInfo>();
                    servicesByProviders.put(tradeName, servicesByProvider);
                }
                servicesByProvider.add(serviceInfo);
            }
        }
        return servicesByProviders;
    }

    private List<String> getQualifiers(ServiceInfoStatus serviceInfoStatus, CertificateToken certificateToken) {
        LOG.trace("--> GET_QUALIFIERS()");
        ArrayList<String> list = new ArrayList<String>();
        Map<String, List<Condition>> qualifiersAndConditions = serviceInfoStatus.getQualifiersAndConditions();
        block0: for (Map.Entry<String, List<Condition>> conditionEntry : qualifiersAndConditions.entrySet()) {
            List<Condition> conditions = conditionEntry.getValue();
            LOG.trace("  --> {}", (Object)conditions);
            for (Condition condition : conditions) {
                if (!condition.check(certificateToken)) continue;
                LOG.trace("    --> CONDITION TRUE / {}", (Object)conditionEntry.getKey());
                list.add(conditionEntry.getKey());
                continue block0;
            }
        }
        return list;
    }

    private XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(Digest digest) {
        if (digest == null) {
            return this.getXmlDigestAlgoAndValue(null, null);
        }
        return this.getXmlDigestAlgoAndValue(digest.getAlgorithm(), digest.getValue());
    }

    private XmlDigestAlgoAndValue getXmlDigestAlgoAndValue(DigestAlgorithm digestAlgo, byte[] digestValue) {
        XmlDigestAlgoAndValue xmlDigestAlgAndValue = new XmlDigestAlgoAndValue();
        xmlDigestAlgAndValue.setDigestMethod(digestAlgo);
        xmlDigestAlgAndValue.setDigestValue(digestValue == null ? DSSUtils.EMPTY_BYTE_ARRAY : digestValue);
        return xmlDigestAlgAndValue;
    }

    private String emptyToNull(String text) {
        if (Utils.isStringEmpty(text)) {
            return null;
        }
        return text;
    }
}

