/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.spi.client.http.DataLoader;
import eu.europa.esig.dss.spi.client.http.NativeHTTPDataLoader;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ListCRLSource;
import eu.europa.esig.dss.validation.ListOCSPSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCertificateVerifier
implements CertificateVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCertificateVerifier.class);
    private CertificateSource trustedCertSource;
    private CertificateSource adjunctCertSource;
    private OCSPSource ocspSource;
    private CRLSource crlSource;
    private DataLoader dataLoader;
    private ListCRLSource signatureCRLSource;
    private ListOCSPSource signatureOCSPSource;
    private boolean exceptionOnMissingRevocationData = true;
    private boolean exceptionOnUncoveredPOE = false;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private boolean includeCertificateTokens = false;
    private boolean includeRawRevocationData = false;
    private boolean includeRawTimestampTokens = false;
    private boolean exceptionOnRevokedCertificate = true;
    private boolean exceptionOnInvalidTimestamp = true;
    private boolean exceptionOnNoRevocationAfterBestSignatureTime = false;
    private boolean checkRevocationForUntrustedChains = false;

    public CommonCertificateVerifier() {
        this(false);
    }

    public CommonCertificateVerifier(boolean simpleCreationOnly) {
        LOG.info("+ New CommonCertificateVerifier created.");
        if (!simpleCreationOnly) {
            this.dataLoader = new NativeHTTPDataLoader();
        }
    }

    public CommonCertificateVerifier(CertificateSource trustedCertSource, CRLSource crlSource, OCSPSource ocspSource, DataLoader dataLoader) {
        LOG.info("+ New CommonCertificateVerifier created with parameters.");
        this.trustedCertSource = trustedCertSource;
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
        this.dataLoader = dataLoader;
        if (dataLoader == null) {
            LOG.warn("DataLoader is null. It's required to access AIA certificate source");
        }
    }

    @Override
    public CertificateSource getTrustedCertSource() {
        return this.trustedCertSource;
    }

    @Override
    public OCSPSource getOcspSource() {
        return this.ocspSource;
    }

    @Override
    public CRLSource getCrlSource() {
        return this.crlSource;
    }

    @Override
    public void setCrlSource(CRLSource crlSource) {
        this.crlSource = crlSource;
    }

    @Override
    public void setOcspSource(OCSPSource ocspSource) {
        this.ocspSource = ocspSource;
    }

    @Override
    public void setTrustedCertSource(CertificateSource trustedCertSource) {
        this.trustedCertSource = trustedCertSource;
    }

    @Override
    public CertificateSource getAdjunctCertSource() {
        return this.adjunctCertSource;
    }

    @Override
    public void setAdjunctCertSource(CertificateSource adjunctCertSource) {
        if (adjunctCertSource instanceof CommonTrustedCertificateSource) {
            LOG.warn("Adjunct certificate source shouldn't be trusted. This source contains missing intermediate certificates");
        }
        this.adjunctCertSource = adjunctCertSource;
    }

    @Override
    public DataLoader getDataLoader() {
        return this.dataLoader;
    }

    @Override
    public void setDataLoader(DataLoader dataLoader) {
        this.dataLoader = dataLoader;
    }

    @Override
    public ListCRLSource getSignatureCRLSource() {
        return this.signatureCRLSource;
    }

    @Override
    public void setSignatureCRLSource(ListCRLSource signatureCRLSource) {
        this.signatureCRLSource = signatureCRLSource;
    }

    @Override
    public ListOCSPSource getSignatureOCSPSource() {
        return this.signatureOCSPSource;
    }

    @Override
    public void setSignatureOCSPSource(ListOCSPSource signatureOCSPSource) {
        this.signatureOCSPSource = signatureOCSPSource;
    }

    @Override
    public void setExceptionOnMissingRevocationData(boolean throwExceptionOnMissingRevocationData) {
        this.exceptionOnMissingRevocationData = throwExceptionOnMissingRevocationData;
    }

    @Override
    public boolean isExceptionOnMissingRevocationData() {
        return this.exceptionOnMissingRevocationData;
    }

    @Override
    public boolean isExceptionOnUncoveredPOE() {
        return this.exceptionOnUncoveredPOE;
    }

    @Override
    public void setExceptionOnUncoveredPOE(boolean exceptionOnUncoveredPOE) {
        this.exceptionOnUncoveredPOE = exceptionOnUncoveredPOE;
    }

    @Override
    public boolean isExceptionOnRevokedCertificate() {
        return this.exceptionOnRevokedCertificate;
    }

    @Override
    public void setExceptionOnRevokedCertificate(boolean exceptionOnRevokedCertificate) {
        this.exceptionOnRevokedCertificate = exceptionOnRevokedCertificate;
    }

    @Override
    public void setExceptionOnInvalidTimestamp(boolean throwExceptionOnInvalidTimestamp) {
        this.exceptionOnInvalidTimestamp = throwExceptionOnInvalidTimestamp;
    }

    @Override
    public boolean isExceptionOnInvalidTimestamp() {
        return this.exceptionOnInvalidTimestamp;
    }

    @Override
    public void setExceptionOnNoRevocationAfterBestSignatureTime(boolean exceptionOnNoRevocationAfterBestSignatureTime) {
        this.exceptionOnNoRevocationAfterBestSignatureTime = exceptionOnNoRevocationAfterBestSignatureTime;
    }

    @Override
    public boolean isExceptionOnNoRevocationAfterBestSignatureTime() {
        return this.exceptionOnNoRevocationAfterBestSignatureTime;
    }

    @Override
    public boolean isCheckRevocationForUntrustedChains() {
        return this.checkRevocationForUntrustedChains;
    }

    @Override
    public void setCheckRevocationForUntrustedChains(boolean checkRevocationForUntrustedChains) {
        this.checkRevocationForUntrustedChains = checkRevocationForUntrustedChains;
    }

    @Override
    public CertificatePool createValidationPool() {
        CertificatePool validationPool = new CertificatePool();
        if (this.trustedCertSource != null) {
            validationPool.importCerts(this.trustedCertSource);
        }
        if (this.adjunctCertSource != null) {
            validationPool.importCerts(this.adjunctCertSource);
        }
        return validationPool;
    }

    @Override
    public void setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.defaultDigestAlgorithm = digestAlgorithm;
    }

    @Override
    public DigestAlgorithm getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    @Override
    public void setIncludeCertificateTokenValues(boolean includeCertificateTokens) {
        this.includeCertificateTokens = includeCertificateTokens;
    }

    @Override
    public boolean isIncludeCertificateTokenValues() {
        return this.includeCertificateTokens;
    }

    @Override
    public void setIncludeCertificateRevocationValues(boolean include) {
        this.includeRawRevocationData = include;
    }

    @Override
    public boolean isIncludeCertificateRevocationValues() {
        return this.includeRawRevocationData;
    }

    @Override
    public void setIncludeTimestampTokenValues(boolean include) {
        this.includeRawTimestampTokens = include;
    }

    @Override
    public boolean isIncludeTimestampTokenValues() {
        return this.includeRawTimestampTokens;
    }
}

