/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMSOCSPSource
extends SignatureOCSPSource {
    private static final Logger LOG = LoggerFactory.getLogger(CMSOCSPSource.class);
    protected final transient CMSSignedData cmsSignedData;
    protected final transient AttributeTable unsignedAttributes;
    private List<OCSPResponseBinary> signedDataOCSPIdentifiers = new ArrayList<OCSPResponseBinary>();

    protected CMSOCSPSource(CMSSignedData cms, AttributeTable unsignedAttributes) {
        this.cmsSignedData = cms;
        this.unsignedAttributes = unsignedAttributes;
        this.appendContainedOCSPResponses();
    }

    protected RevocationOrigin getRevocationValuesOrigin() {
        return RevocationOrigin.REVOCATION_VALUES;
    }

    protected RevocationRefOrigin getCompleteRevocationRefsOrigin() {
        return RevocationRefOrigin.COMPLETE_REVOCATION_REFS;
    }

    protected RevocationRefOrigin getAttributeRevocationRefsOrigin() {
        return RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS;
    }

    public List<OCSPResponseBinary> getSignedDataOCSPIdentifiers() {
        return this.signedDataOCSPIdentifiers;
    }

    @Override
    public void appendContainedOCSPResponses() {
        this.collectFromSignedData();
        if (this.unsignedAttributes != null) {
            this.collectRevocationValues(this.unsignedAttributes, PKCSObjectIdentifiers.id_aa_ets_revocationValues, this.getRevocationValuesOrigin());
            this.collectRevocationRefs(this.unsignedAttributes, PKCSObjectIdentifiers.id_aa_ets_revocationRefs, this.getCompleteRevocationRefsOrigin());
            this.collectRevocationRefs(this.unsignedAttributes, OID.attributeRevocationRefsOid, this.getAttributeRevocationRefsOrigin());
        }
    }

    private void collectFromSignedData() {
        this.addBasicOcspRespFrom_id_ri_ocsp_response();
        this.addBasicOcspRespFrom_id_pkix_ocsp_basic();
    }

    private void addBasicOcspRespFrom_id_ri_ocsp_response() {
        Store otherRevocationInfo = this.cmsSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response);
        Collection otherRevocationInfoMatches = otherRevocationInfo.getMatches(null);
        for (Object object : otherRevocationInfoMatches) {
            if (object instanceof DERSequence) {
                OCSPResponseBinary ocspResponseIdentifier;
                BasicOCSPResp basicOCSPResp;
                DERSequence otherRevocationInfoMatch = (DERSequence)object;
                if (otherRevocationInfoMatch.size() == 4) {
                    basicOCSPResp = DSSRevocationUtils.getBasicOcspResp(otherRevocationInfoMatch);
                } else {
                    OCSPResp ocspResp = DSSRevocationUtils.getOcspResp(otherRevocationInfoMatch);
                    basicOCSPResp = DSSRevocationUtils.fromRespToBasic(ocspResp);
                }
                if ((ocspResponseIdentifier = this.addBasicOcspResp(basicOCSPResp, this.getRevocationValuesOrigin())) == null) continue;
                ocspResponseIdentifier.setAsn1ObjectIdentifier(CMSObjectIdentifiers.id_ri_ocsp_response);
                this.signedDataOCSPIdentifiers.add(ocspResponseIdentifier);
                continue;
            }
            LOG.warn("Unsupported object type for id_ri_ocsp_response (SHALL be DER encoding) : {}", (Object)object.getClass().getSimpleName());
        }
    }

    private void addBasicOcspRespFrom_id_pkix_ocsp_basic() {
        Store otherRevocationInfo = this.cmsSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
        Collection otherRevocationInfoMatches = otherRevocationInfo.getMatches(null);
        for (Object object : otherRevocationInfoMatches) {
            if (object instanceof DERSequence) {
                DERSequence otherRevocationInfoMatch = (DERSequence)object;
                BasicOCSPResp basicOCSPResp = DSSRevocationUtils.getBasicOcspResp(otherRevocationInfoMatch);
                OCSPResponseBinary ocspResponseIdentifier = this.addBasicOcspResp(basicOCSPResp, this.getRevocationValuesOrigin());
                if (ocspResponseIdentifier == null) continue;
                ocspResponseIdentifier.setAsn1ObjectIdentifier(OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                this.signedDataOCSPIdentifiers.add(ocspResponseIdentifier);
                continue;
            }
            LOG.warn("Unsupported object type for id_pkix_ocsp_basic (SHALL be DER encoding) : {}", (Object)object.getClass().getSimpleName());
        }
    }

    private void collectRevocationValues(AttributeTable unsignedAttributes, ASN1ObjectIdentifier revocacationValuesAttribute, RevocationOrigin origin) {
        ASN1Set attrValues;
        ASN1Encodable attValue;
        RevocationValues revocationValues;
        Attribute attribute = unsignedAttributes.get(revocacationValuesAttribute);
        if (attribute != null && (revocationValues = DSSASN1Utils.getRevocationValues(attValue = (attrValues = attribute.getAttrValues()).getObjectAt(0))) != null) {
            for (BasicOCSPResponse basicOCSPResponse : revocationValues.getOcspVals()) {
                BasicOCSPResp basicOCSPResp = new BasicOCSPResp(basicOCSPResponse);
                this.addBasicOcspResp(basicOCSPResp, origin);
            }
        }
    }

    private void collectRevocationRefs(AttributeTable unsignedAttributes, ASN1ObjectIdentifier revocationReferencesAttribute, RevocationRefOrigin origin) {
        Attribute attribute = unsignedAttributes.get(revocationReferencesAttribute);
        if (attribute == null) {
            return;
        }
        ASN1Set attrValues = attribute.getAttrValues();
        if (attrValues.size() <= 0) {
            return;
        }
        ASN1Encodable attrValue = attrValues.getObjectAt(0);
        ASN1Sequence completeRevocationRefs = (ASN1Sequence)attrValue;
        for (int i = 0; i < completeRevocationRefs.size(); ++i) {
            CrlOcspRef otherCertId = CrlOcspRef.getInstance(completeRevocationRefs.getObjectAt(i));
            OcspListID ocspListID = otherCertId.getOcspids();
            if (ocspListID == null) continue;
            for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                OCSPRef ocspRef = new OCSPRef(ocspResponsesID, origin);
                this.addReference(ocspRef, origin);
            }
        }
    }

    protected OCSPResponseBinary addBasicOcspResp(BasicOCSPResp basicOCSPResp, RevocationOrigin origin) {
        if (basicOCSPResp != null) {
            OCSPResponseBinary ocspResponse = OCSPResponseBinary.build(basicOCSPResp);
            this.addOCSPResponse(ocspResponse, origin);
            return ocspResponse;
        }
        return null;
    }
}

