/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CMSCertificateSource
extends SignatureCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(CMSCertificateSource.class);
    protected final transient AttributeTable unsignedAttributes;

    protected CMSCertificateSource(AttributeTable unsignedAttributes, CertificatePool certPool) {
        super(certPool);
        this.unsignedAttributes = unsignedAttributes;
    }

    @Override
    public List<CertificateToken> getCertificateValues() {
        return this.getCertificateFromUnsignedAttribute(PKCSObjectIdentifiers.id_aa_ets_certValues);
    }

    @Override
    public List<CertificateRef> getCompleteCertificateRefs() {
        return this.getCertificateRefsFromUnsignedAttribute(PKCSObjectIdentifiers.id_aa_ets_certificateRefs, CertificateRefOrigin.COMPLETE_CERTIFICATE_REFS);
    }

    @Override
    public List<CertificateRef> getAttributeCertificateRefs() {
        return this.getCertificateRefsFromUnsignedAttribute(OID.attributeCertificateRefsOid, CertificateRefOrigin.ATTRIBUTE_CERTIFICATE_REFS);
    }

    private List<CertificateToken> getCertificateFromUnsignedAttribute(ASN1ObjectIdentifier attributeOid) {
        Attribute attribute;
        ArrayList<CertificateToken> certs = new ArrayList<CertificateToken>();
        if (this.unsignedAttributes != null && (attribute = this.unsignedAttributes.get(attributeOid)) != null) {
            ASN1Sequence seq = (ASN1Sequence)attribute.getAttrValues().getObjectAt(0);
            for (int ii = 0; ii < seq.size(); ++ii) {
                try {
                    Certificate cs = Certificate.getInstance(seq.getObjectAt(ii));
                    CertificateToken certToken = this.addCertificate(DSSUtils.loadCertificate(cs.getEncoded()));
                    if (certs.contains(certToken)) continue;
                    certs.add(certToken);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Unable to parse encapsulated certificate : {}", (Object)e.getMessage());
                }
            }
        }
        return certs;
    }

    private List<CertificateRef> getCertificateRefsFromUnsignedAttribute(ASN1ObjectIdentifier attributeOid, CertificateRefOrigin location) {
        Attribute attribute;
        ArrayList<CertificateRef> result = new ArrayList<CertificateRef>();
        if (this.unsignedAttributes != null && (attribute = this.unsignedAttributes.get(attributeOid)) != null) {
            ASN1Sequence seq = (ASN1Sequence)attribute.getAttrValues().getObjectAt(0);
            for (int ii = 0; ii < seq.size(); ++ii) {
                try {
                    OtherCertID otherCertId = OtherCertID.getInstance(seq.getObjectAt(ii));
                    DigestAlgorithm digestAlgo = DigestAlgorithm.forOID(otherCertId.getAlgorithmHash().getAlgorithm().getId());
                    CertificateRef certRef = new CertificateRef();
                    certRef.setCertDigest(new Digest(digestAlgo, otherCertId.getCertHash()));
                    IssuerSerial issuerSerial = otherCertId.getIssuerSerial();
                    if (issuerSerial != null) {
                        certRef.setIssuerInfo(this.getIssuerInfo(issuerSerial));
                    }
                    certRef.setOrigin(location);
                    result.add(certRef);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn("Unable to parse encapsulated OtherCertID : {}", (Object)e.getMessage());
                }
            }
        }
        return result;
    }
}

