/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CMSCertificateSource;
import eu.europa.esig.dss.validation.CertificateRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESCertificateSource
extends CMSCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESCertificateSource.class);
    private final transient CMSSignedData cmsSignedData;
    private final transient AttributeTable signedAttributes;
    private List<CertificateToken> keyInfoCertificates;
    private List<CertificateRef> signingCertificateValues;

    public CAdESCertificateSource(CMSSignedData cmsSignedData, CertificatePool certPool) {
        this(cmsSignedData, DSSASN1Utils.getFirstSignerInformation(cmsSignedData), certPool);
    }

    public CAdESCertificateSource(CMSSignedData cmsSignedData, SignerInformation signerInformation, CertificatePool certPool) {
        super(signerInformation.getUnsignedAttributes(), certPool);
        Objects.requireNonNull(cmsSignedData, "CMS SignedData is null, it must be provided!");
        Objects.requireNonNull(signerInformation, "SignerInformation is null, it must be provided!");
        this.cmsSignedData = cmsSignedData;
        this.signedAttributes = signerInformation.getSignedAttributes();
        this.getKeyInfoCertificates();
        this.getCertificateValues();
    }

    @Override
    public List<CertificateToken> getKeyInfoCertificates() {
        if (this.keyInfoCertificates == null) {
            this.keyInfoCertificates = new ArrayList<CertificateToken>();
            try {
                Collection<X509CertificateHolder> x509CertificateHolders = this.cmsSignedData.getCertificates().getMatches(null);
                for (X509CertificateHolder x509CertificateHolder : x509CertificateHolders) {
                    CertificateToken certificateToken = this.addCertificate(DSSASN1Utils.getCertificate(x509CertificateHolder));
                    if (this.keyInfoCertificates.contains(certificateToken)) continue;
                    this.keyInfoCertificates.add(certificateToken);
                }
            }
            catch (Exception e) {
                LOG.warn("Cannot extract certificates from CMS Signed Data : {}", (Object)e.getMessage());
            }
        }
        return this.keyInfoCertificates;
    }

    @Override
    public List<CertificateToken> getAttrAuthoritiesCertValues() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateToken> getTimeStampValidationDataCertValues() {
        return Collections.emptyList();
    }

    @Override
    public List<CertificateRef> getSigningCertificateValues() {
        if (this.signingCertificateValues == null) {
            this.signingCertificateValues = new ArrayList<CertificateRef>();
            if (this.signedAttributes != null && this.signedAttributes.size() > 0) {
                Attribute signingCertificateAttributeV2;
                Attribute signingCertificateAttributeV1 = this.signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificate);
                if (signingCertificateAttributeV1 != null) {
                    this.signingCertificateValues.addAll(this.extractSigningCertificateV1(signingCertificateAttributeV1));
                }
                if ((signingCertificateAttributeV2 = this.signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2)) != null) {
                    this.signingCertificateValues.addAll(this.extractSigningCertificateV2(signingCertificateAttributeV2));
                }
            }
        }
        return this.signingCertificateValues;
    }

    private List<CertificateRef> extractSigningCertificateV1(Attribute attribute) {
        ArrayList<CertificateRef> certificateRefs = new ArrayList<CertificateRef>();
        ASN1Set attrValues = attribute.getAttrValues();
        for (int ii = 0; ii < attrValues.size(); ++ii) {
            ASN1Encodable asn1Encodable = attrValues.getObjectAt(ii);
            SigningCertificate signingCertificate = SigningCertificate.getInstance(asn1Encodable);
            if (signingCertificate != null) {
                certificateRefs.addAll(this.extractESSCertIDs(signingCertificate.getCerts(), CertificateRefOrigin.SIGNING_CERTIFICATE));
                continue;
            }
            LOG.warn("SigningCertificate attribute is not well defined!");
        }
        return certificateRefs;
    }

    private List<CertificateRef> extractESSCertIDs(ESSCertID[] essCertIDs, CertificateRefOrigin location) {
        ArrayList<CertificateRef> certificateRefs = new ArrayList<CertificateRef>();
        for (ESSCertID essCertID : essCertIDs) {
            IssuerSerial issuerSerial;
            CertificateRef certRef = new CertificateRef();
            byte[] certHash = essCertID.getCertHash();
            if (Utils.isArrayNotEmpty(certHash)) {
                certRef.setCertDigest(new Digest(DigestAlgorithm.SHA1, certHash));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found Certificate Hash in signingCertificateAttributeV1 {} with algorithm {}", (Object)Utils.toHex(certHash), (Object)DigestAlgorithm.SHA1);
                }
            }
            if ((issuerSerial = essCertID.getIssuerSerial()) != null) {
                certRef.setIssuerInfo(this.getIssuerInfo(issuerSerial));
            }
            certRef.setOrigin(location);
            certificateRefs.add(certRef);
        }
        return certificateRefs;
    }

    private List<CertificateRef> extractSigningCertificateV2(Attribute attribute) {
        ArrayList<CertificateRef> certificateRefs = new ArrayList<CertificateRef>();
        ASN1Set attrValues = attribute.getAttrValues();
        for (int ii = 0; ii < attrValues.size(); ++ii) {
            ASN1Encodable asn1Encodable = attrValues.getObjectAt(ii);
            SigningCertificateV2 signingCertificate = SigningCertificateV2.getInstance(asn1Encodable);
            if (signingCertificate == null) continue;
            certificateRefs.addAll(this.extractESSCertIDv2s(signingCertificate.getCerts(), CertificateRefOrigin.SIGNING_CERTIFICATE));
        }
        return certificateRefs;
    }

    private List<CertificateRef> extractESSCertIDv2s(ESSCertIDv2[] essCertIDv2s, CertificateRefOrigin location) {
        ArrayList<CertificateRef> certificateRefs = new ArrayList<CertificateRef>();
        for (ESSCertIDv2 essCertIDv2 : essCertIDv2s) {
            IssuerSerial issuerSerial;
            CertificateRef certRef = new CertificateRef();
            String algorithmId = essCertIDv2.getHashAlgorithm().getAlgorithm().getId();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(algorithmId);
            byte[] certHash = essCertIDv2.getCertHash();
            certRef.setCertDigest(new Digest(digestAlgorithm, certHash));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found Certificate Hash in SigningCertificateV2 {} with algorithm {}", (Object)Utils.toHex(certHash), (Object)digestAlgorithm);
            }
            if ((issuerSerial = essCertIDv2.getIssuerSerial()) != null) {
                certRef.setIssuerInfo(this.getIssuerInfo(issuerSerial));
            }
            certRef.setOrigin(location);
            certificateRefs.add(certRef);
        }
        return certificateRefs;
    }
}

