/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.task;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.scene.control.ChoiceDialog;

public class SelectCertificateTask
implements Callable<DSSPrivateKeyEntry> {
    private List<DSSPrivateKeyEntry> keys;

    public SelectCertificateTask(List<DSSPrivateKeyEntry> keys) {
        this.keys = keys;
    }

    @Override
    public DSSPrivateKeyEntry call() throws Exception {
        HashMap<String, DSSPrivateKeyEntry> map = new HashMap<String, DSSPrivateKeyEntry>();
        for (DSSPrivateKeyEntry dssPrivateKeyEntry : this.keys) {
            CertificateToken certificate = dssPrivateKeyEntry.getCertificate();
            String text = DSSASN1Utils.getHumanReadableName(certificate) + " (" + certificate.getSerialNumber() + ")";
            map.put(text, dssPrivateKeyEntry);
        }
        Set keySet = map.keySet();
        ChoiceDialog dialog = new ChoiceDialog(keySet.iterator().next(), keySet);
        dialog.setHeaderText("Select your certificate");
        Optional result = dialog.showAndWait();
        try {
            return (DSSPrivateKeyEntry)map.get(result.get());
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

