/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.standalone.controller;

import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.SignatureTokenType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.standalone.fx.FileToStringConverter;
import eu.europa.esig.dss.standalone.model.SignatureModel;
import eu.europa.esig.dss.standalone.task.SigningTask;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.ws.signature.common.RemoteDocumentSignatureService;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureController
implements Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureController.class);
    @FXML
    private Button fileSelectButton;
    @FXML
    private RadioButton asicsRadio;
    @FXML
    private RadioButton asiceRadio;
    @FXML
    private ToggleGroup toggleAsicContainerType;
    @FXML
    private ToggleGroup toogleSigFormat;
    @FXML
    private ToggleGroup toggleSigPackaging;
    @FXML
    private RadioButton cadesRadio;
    @FXML
    private RadioButton padesRadio;
    @FXML
    private RadioButton xadesRadio;
    @FXML
    private HBox hSignaturePackaging;
    @FXML
    private HBox hBoxDigestAlgos;
    @FXML
    private RadioButton envelopedRadio;
    @FXML
    private RadioButton envelopingRadio;
    @FXML
    private RadioButton detachedRadio;
    @FXML
    private RadioButton internallyDetachedRadio;
    @FXML
    private ComboBox<SignatureLevel> comboLevel;
    @FXML
    private Label warningLabel;
    @FXML
    private ToggleGroup toggleDigestAlgo;
    @FXML
    private ToggleGroup toggleSigToken;
    @FXML
    private RadioButton pkcs11Radio;
    @FXML
    private RadioButton pkcs12Radio;
    @FXML
    private RadioButton mscapiRadio;
    @FXML
    private HBox hPkcsFile;
    @FXML
    private Label labelPkcs11File;
    @FXML
    private Label labelPkcs12File;
    @FXML
    private HBox hPkcsPassword;
    @FXML
    private Button pkcsFileButton;
    @FXML
    private PasswordField pkcsPassword;
    @FXML
    private Button signButton;
    @FXML
    private ProgressIndicator progressSign;
    private Stage stage;
    private SignatureModel model;
    private RemoteDocumentSignatureService signatureService;

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void setSignatureService(RemoteDocumentSignatureService signatureService) {
        this.signatureService = signatureService;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.model = new SignatureModel();
        this.hPkcsFile.managedProperty().bind((ObservableValue)this.hPkcsFile.visibleProperty());
        this.hPkcsPassword.managedProperty().bind((ObservableValue)this.hPkcsPassword.visibleProperty());
        this.labelPkcs11File.managedProperty().bind((ObservableValue)this.labelPkcs11File.visibleProperty());
        this.labelPkcs12File.managedProperty().bind((ObservableValue)this.labelPkcs12File.visibleProperty());
        this.fileSelectButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("File to sign");
                File fileToSign = fileChooser.showOpenDialog((Window)SignatureController.this.stage);
                SignatureController.this.model.setFileToSign(fileToSign);
            }
        });
        this.fileSelectButton.textProperty().bindBidirectional(this.model.fileToSignProperty(), (StringConverter)new FileToStringConverter());
        this.asicsRadio.setUserData((Object)ASiCContainerType.ASiC_S);
        this.asiceRadio.setUserData((Object)ASiCContainerType.ASiC_E);
        this.toggleAsicContainerType.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    ASiCContainerType newContainerType = (ASiCContainerType)((Object)newValue.getUserData());
                    SignatureController.this.updateSignatureFormForASiC(newContainerType);
                } else {
                    SignatureController.this.updateSignatureFormForASiC(null);
                }
            }
        });
        this.cadesRadio.setUserData((Object)SignatureForm.CAdES);
        this.xadesRadio.setUserData((Object)SignatureForm.XAdES);
        this.padesRadio.setUserData((Object)SignatureForm.PAdES);
        this.toogleSigFormat.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    SignatureForm newSigForm = (SignatureForm)((Object)newValue.getUserData());
                    SignatureController.this.updateSignatureForm(newSigForm);
                } else {
                    SignatureController.this.updateSignatureForm(null);
                }
            }
        });
        this.envelopedRadio.setUserData((Object)SignaturePackaging.ENVELOPED);
        this.envelopingRadio.setUserData((Object)SignaturePackaging.ENVELOPING);
        this.detachedRadio.setUserData((Object)SignaturePackaging.DETACHED);
        this.internallyDetachedRadio.setUserData((Object)SignaturePackaging.INTERNALLY_DETACHED);
        this.toggleSigPackaging.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    SignaturePackaging newPackaging = (SignaturePackaging)((Object)newValue.getUserData());
                    SignatureController.this.model.setSignaturePackaging(newPackaging);
                } else {
                    SignatureController.this.model.setSignaturePackaging(null);
                }
            }
        });
        List<DigestAlgorithm> skipAlgos = Arrays.asList(DigestAlgorithm.MD2, DigestAlgorithm.MD5, DigestAlgorithm.RIPEMD160);
        for (DigestAlgorithm digestAlgo : DigestAlgorithm.values()) {
            if (skipAlgos.contains(digestAlgo)) continue;
            RadioButton rb = new RadioButton(digestAlgo.getName());
            rb.setUserData((Object)digestAlgo);
            rb.setToggleGroup(this.toggleDigestAlgo);
            this.hBoxDigestAlgos.getChildren().add((Object)rb);
        }
        this.toggleDigestAlgo.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    DigestAlgorithm digestAlgorithm = (DigestAlgorithm)newValue.getUserData();
                    SignatureController.this.model.setDigestAlgorithm(digestAlgorithm);
                } else {
                    SignatureController.this.model.setDigestAlgorithm(null);
                }
            }
        });
        this.comboLevel.valueProperty().bindBidirectional(this.model.signatureLevelProperty());
        this.pkcs11Radio.setUserData((Object)SignatureTokenType.PKCS11);
        this.pkcs12Radio.setUserData((Object)SignatureTokenType.PKCS12);
        this.mscapiRadio.setUserData((Object)SignatureTokenType.MSCAPI);
        this.toggleSigToken.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (newValue != null) {
                    SignatureTokenType tokenType = (SignatureTokenType)((Object)newValue.getUserData());
                    SignatureController.this.model.setTokenType(tokenType);
                }
                SignatureController.this.model.setPkcsFile(null);
                SignatureController.this.model.setPassword(null);
            }
        });
        this.pkcsFileButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FileChooser fileChooser = new FileChooser();
                if (SignatureTokenType.PKCS11.equals((Object)SignatureController.this.model.getTokenType())) {
                    fileChooser.setTitle("Library");
                    fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PKCS11 library (*.dll)", new String[]{"*.dll"}));
                } else if (SignatureTokenType.PKCS12.equals((Object)SignatureController.this.model.getTokenType())) {
                    fileChooser.setTitle("Keystore");
                    fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PKCS12 keystore (*.p12, *.pfx)", new String[]{"*.p12", "*.pfx"}));
                }
                FileChooser.ExtensionFilter allFilesExtensionFilter = new FileChooser.ExtensionFilter("All files", new String[]{"*"});
                fileChooser.getExtensionFilters().add((Object)allFilesExtensionFilter);
                File pkcsFile = fileChooser.showOpenDialog((Window)SignatureController.this.stage);
                SignatureController.this.model.setPkcsFile(pkcsFile);
            }
        });
        this.pkcsFileButton.textProperty().bindBidirectional(this.model.pkcsFileProperty(), (StringConverter)new FileToStringConverter());
        this.pkcsPassword.textProperty().bindBidirectional((Property)this.model.passwordProperty());
        BooleanBinding isPkcs11Or12 = this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS11).or((ObservableBooleanValue)this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS12));
        this.hPkcsFile.visibleProperty().bind((ObservableValue)isPkcs11Or12);
        this.hPkcsPassword.visibleProperty().bind((ObservableValue)isPkcs11Or12);
        this.labelPkcs11File.visibleProperty().bind((ObservableValue)this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS11));
        this.labelPkcs12File.visibleProperty().bind((ObservableValue)this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS12));
        BooleanBinding isMandatoryFieldsEmpty = this.model.fileToSignProperty().isNull().or((ObservableBooleanValue)this.model.signatureFormProperty().isNull()).or((ObservableBooleanValue)this.model.digestAlgorithmProperty().isNull()).or((ObservableBooleanValue)this.model.tokenTypeProperty().isNull());
        BooleanBinding isASiCorPackagingPresent = this.model.asicContainerTypeProperty().isNull().and((ObservableBooleanValue)this.model.signaturePackagingProperty().isNull());
        BooleanBinding isEmptyFileOrPassword = this.model.pkcsFileProperty().isNull().or((ObservableBooleanValue)this.model.passwordProperty().isEmpty());
        BooleanBinding isPKCSIncomplete = this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS11).or((ObservableBooleanValue)this.model.tokenTypeProperty().isEqualTo((Object)SignatureTokenType.PKCS12)).and((ObservableBooleanValue)isEmptyFileOrPassword);
        final BooleanBinding disableSignButton = isMandatoryFieldsEmpty.or((ObservableBooleanValue)isASiCorPackagingPresent).or((ObservableBooleanValue)isPKCSIncomplete);
        this.signButton.disableProperty().bind((ObservableValue)disableSignButton);
        this.signButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                SignatureController.this.progressSign.setDisable(false);
                Service<DSSDocument> service = new Service<DSSDocument>(){

                    protected Task<DSSDocument> createTask() {
                        return new SigningTask(SignatureController.this.signatureService, SignatureController.this.model);
                    }
                };
                service.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>((Service)service){
                    final /* synthetic */ Service val$service;
                    {
                        this.val$service = service;
                    }

                    public void handle(WorkerStateEvent event) {
                        SignatureController.this.save((DSSDocument)this.val$service.getValue());
                        SignatureController.this.signButton.disableProperty().bind((ObservableValue)disableSignButton);
                        SignatureController.this.model.setPassword(null);
                    }
                });
                service.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>((Service)service){
                    final /* synthetic */ Service val$service;
                    {
                        this.val$service = service;
                    }

                    public void handle(WorkerStateEvent event) {
                        String errorMessage = "Oops an error occurred : " + this.val$service.getMessage();
                        LOG.error(errorMessage, this.val$service.getException());
                        Alert alert = new Alert(Alert.AlertType.ERROR, errorMessage, new ButtonType[]{ButtonType.CLOSE});
                        alert.showAndWait();
                        SignatureController.this.signButton.disableProperty().bind((ObservableValue)disableSignButton);
                        SignatureController.this.model.setPassword(null);
                    }
                });
                SignatureController.this.progressSign.progressProperty().bind((ObservableValue)service.progressProperty());
                SignatureController.this.signButton.disableProperty().bind((ObservableValue)service.runningProperty());
                service.start();
            }
        });
    }

    protected void updateSignatureFormForASiC(ASiCContainerType newValue) {
        this.model.setAsicContainerType(newValue);
        this.reinitSignatureFormats();
        this.reinitSignaturePackagings();
        if (newValue != null) {
            this.cadesRadio.setDisable(false);
            this.xadesRadio.setDisable(false);
            this.hSignaturePackaging.setVisible(false);
        } else {
            this.cadesRadio.setDisable(false);
            this.padesRadio.setDisable(false);
            this.xadesRadio.setDisable(false);
            this.hSignaturePackaging.setVisible(true);
        }
    }

    protected void updateSignatureForm(SignatureForm signatureForm) {
        this.model.setSignatureForm(signatureForm);
        this.reinitSignaturePackagings();
        this.comboLevel.setDisable(false);
        this.comboLevel.getItems().removeAll((Collection)this.comboLevel.getItems());
        if (signatureForm != null) {
            switch (signatureForm) {
                case CAdES: {
                    this.envelopingRadio.setDisable(false);
                    this.detachedRadio.setDisable(false);
                    this.comboLevel.getItems().addAll((Object[])new SignatureLevel[]{SignatureLevel.CAdES_BASELINE_B, SignatureLevel.CAdES_BASELINE_T, SignatureLevel.CAdES_BASELINE_LT, SignatureLevel.CAdES_BASELINE_LTA});
                    this.comboLevel.setValue((Object)SignatureLevel.CAdES_BASELINE_B);
                    break;
                }
                case PAdES: {
                    this.envelopedRadio.setDisable(false);
                    this.envelopedRadio.setSelected(true);
                    this.comboLevel.getItems().addAll((Object[])new SignatureLevel[]{SignatureLevel.PAdES_BASELINE_B, SignatureLevel.PAdES_BASELINE_T, SignatureLevel.PAdES_BASELINE_LT, SignatureLevel.PAdES_BASELINE_LTA});
                    this.comboLevel.setValue((Object)SignatureLevel.PAdES_BASELINE_B);
                    break;
                }
                case XAdES: {
                    this.envelopingRadio.setDisable(false);
                    this.envelopedRadio.setDisable(false);
                    this.detachedRadio.setDisable(false);
                    this.internallyDetachedRadio.setDisable(false);
                    this.comboLevel.getItems().addAll((Object[])new SignatureLevel[]{SignatureLevel.XAdES_BASELINE_B, SignatureLevel.XAdES_BASELINE_T, SignatureLevel.XAdES_BASELINE_LT, SignatureLevel.XAdES_BASELINE_LTA});
                    this.comboLevel.setValue((Object)SignatureLevel.XAdES_BASELINE_B);
                    break;
                }
            }
        }
    }

    private void reinitSignatureFormats() {
        this.cadesRadio.setDisable(true);
        this.padesRadio.setDisable(true);
        this.xadesRadio.setDisable(true);
        this.cadesRadio.setSelected(false);
        this.padesRadio.setSelected(false);
        this.xadesRadio.setSelected(false);
    }

    private void reinitSignaturePackagings() {
        this.envelopingRadio.setDisable(true);
        this.envelopedRadio.setDisable(true);
        this.detachedRadio.setDisable(true);
        this.internallyDetachedRadio.setDisable(true);
        this.envelopingRadio.setSelected(false);
        this.envelopedRadio.setSelected(false);
        this.detachedRadio.setSelected(false);
        this.internallyDetachedRadio.setSelected(false);
    }

    private void save(DSSDocument signedDocument) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialFileName(signedDocument.getName());
        MimeType mimeType = signedDocument.getMimeType();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(mimeType.getMimeTypeString(), new String[]{"*." + MimeType.getExtension(mimeType)});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File fileToSave = fileChooser.showSaveDialog((Window)this.stage);
        if (fileToSave != null) {
            try (FileOutputStream fos = new FileOutputStream(fileToSave);){
                Utils.copy(signedDocument.openStream(), fos);
            }
            catch (Exception e) {
                Alert alert = new Alert(Alert.AlertType.ERROR, "Unable to save file : " + e.getMessage(), new ButtonType[]{ButtonType.CLOSE});
                alert.showAndWait();
                return;
            }
        }
    }

    static {
        System.setProperty("glass.accessible.force", "false");
    }
}

