/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRespStatus;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPTokenBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(OCSPTokenBuilder.class);
    private final BasicOCSPResp basicOCSPResp;
    private final CertificateToken certificateToken;
    private final CertificateToken issuerCertificateToken;
    private boolean available = false;
    private String ocspAccessLocation;
    private OCSPRespStatus responseStatus;
    private BigInteger nonce;

    public OCSPTokenBuilder(OCSPResp ocspResp, CertificateToken certificateToken, CertificateToken issuerCertificateToken) throws OCSPException {
        this((BasicOCSPResp)ocspResp.getResponseObject(), certificateToken, issuerCertificateToken);
        this.responseStatus = OCSPRespStatus.fromInt(ocspResp.getStatus());
        if (OCSPRespStatus.SUCCESSFUL.equals((Object)this.responseStatus)) {
            this.available = true;
        }
    }

    public OCSPTokenBuilder(BasicOCSPResp basicOCSPResp, CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        this.basicOCSPResp = basicOCSPResp;
        this.certificateToken = certificateToken;
        this.issuerCertificateToken = issuerCertificateToken;
    }

    public void setSourceURL(String sourceURL) {
        this.ocspAccessLocation = sourceURL;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setOCSPResponseStatus(OCSPRespStatus respStatus) {
        this.responseStatus = respStatus;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public OCSPToken build() throws OCSPException {
        Objects.requireNonNull(this.basicOCSPResp, "The basic OCSP response must be filled");
        Objects.requireNonNull(this.certificateToken, "The Certificate token must be filled");
        OCSPToken ocspToken = new OCSPToken();
        if (this.ocspAccessLocation != null) {
            ocspToken.setSourceURL(this.ocspAccessLocation);
            ocspToken.setRevocationTokenKey(DSSRevocationUtils.getOcspRevocationKey(this.certificateToken, this.ocspAccessLocation));
        }
        ocspToken.setCertId(DSSRevocationUtils.getOCSPCertificateID(this.certificateToken, this.issuerCertificateToken));
        ocspToken.setAvailable(this.available);
        ocspToken.setResponseStatus(this.responseStatus);
        ocspToken.setRelatedCertificate(this.certificateToken);
        ocspToken.setBasicOCSPResp(this.basicOCSPResp);
        if (this.nonce != null) {
            ocspToken.setUseNonce(true);
            boolean nonceMatch = this.isNonceMatch(this.basicOCSPResp, this.nonce);
            if (nonceMatch) {
                ocspToken.setNonceMatch(true);
            } else {
                throw new OCSPException("Nonce received from OCSP response does not match a dispatched nonce.");
            }
        }
        ocspToken.initInfo();
        return ocspToken;
    }

    private boolean isNonceMatch(BasicOCSPResp basicOCSPResp, BigInteger expectedNonceValue) {
        ASN1Primitive value;
        Extension extension = basicOCSPResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        ASN1OctetString extnValue = extension.getExtnValue();
        try {
            value = ASN1Primitive.fromByteArray(extnValue.getOctets());
        }
        catch (IOException ex) {
            LOG.warn("Invalid encoding of nonce extension value in OCSP response", ex);
            return false;
        }
        if (value instanceof DEROctetString) {
            BigInteger receivedNonce = new BigInteger(((DEROctetString)value).getOctets());
            return expectedNonceValue.equals(receivedNonce);
        }
        LOG.warn("Nonce extension value in OCSP response is not an OCTET STRING");
        return false;
    }
}

