/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.utils.Utils;
import java.io.Serializable;
import java.util.Set;

public abstract class RevocationRef
implements Serializable {
    private static final long serialVersionUID = 7313118727647264457L;
    protected Digest digest = null;
    protected Set<RevocationRefOrigin> origins;
    private String dssId;

    public Digest getDigest() {
        return this.digest;
    }

    public Set<RevocationRefOrigin> getOrigins() {
        return this.origins;
    }

    public void addOrigin(RevocationRefOrigin revocationRefOrigin) {
        this.origins.add(revocationRefOrigin);
    }

    public String getDSSIdAsString() {
        if (this.dssId == null) {
            this.dssId = "R-" + this.digest.getHexValue().toUpperCase();
        }
        return this.dssId;
    }

    public String toString() {
        return Utils.toBase64(this.digest.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RevocationRef)) {
            return false;
        }
        RevocationRef o = (RevocationRef)obj;
        return this.digest.equals(o.getDigest());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.digest == null ? 0 : this.digest.hashCode());
        return result;
    }
}

