/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CommonCertificateSource
implements CertificateSource {
    private final CertificatePool certPool;
    private final List<CertificateToken> certificateTokens = new ArrayList<CertificateToken>();

    public CommonCertificateSource() {
        this.certPool = new CertificatePool();
    }

    public CommonCertificateSource(CertificatePool certPool) {
        Objects.requireNonNull(certPool, "Certificate pool is missing");
        this.certPool = certPool;
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.OTHER;
    }

    protected CertificatePool getCertificatePool() {
        return this.certPool;
    }

    @Override
    public CertificateToken addCertificate(CertificateToken token) {
        CertificateToken certToken = this.certPool.getInstance(token, this.getCertificateSourceType());
        if (!this.certificateTokens.contains(certToken)) {
            this.certificateTokens.add(certToken);
        }
        return certToken;
    }

    @Override
    public List<CertificateToken> getCertificates() {
        return Collections.unmodifiableList(this.certificateTokens);
    }

    public boolean removeCertificate(CertificateToken certificate) {
        return this.certificateTokens.remove(certificate);
    }

    public int getNumberOfCertificates() {
        return this.certificateTokens.size();
    }

    public CertificateToken getCertificateTokenByDigest(Digest digest) {
        for (CertificateToken certificate : this.certificateTokens) {
            byte[] digestValue = certificate.getDigest(digest.getAlgorithm());
            if (!Arrays.equals(digestValue, digest.getValue())) continue;
            return certificate;
        }
        return null;
    }

    @Override
    public boolean isTrusted(CertificateToken certificateToken) {
        return this.certPool.isTrusted(certificateToken);
    }
}

